/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ClientInterceptor
public class TraceDebugInterceptor
implements ClientExecutionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceDebugInterceptor.class);
    private boolean logHttp;

    public TraceDebugInterceptor() {
        this(true);
    }

    public TraceDebugInterceptor(boolean logHttp) {
        this.logHttp = logHttp;
    }

    private void log(String msg) {
        if (this.logHttp) {
            log.info(msg);
        } else {
            log.trace(msg);
        }
    }

    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        if (!this.logHttp && !log.isTraceEnabled()) {
            return ctx.proceed();
        }
        this.log(">> REST Request: " + ctx.getRequest().getHttpMethod() + " => " + ctx.getRequest().getUri());
        for (String key : ctx.getRequest().getHeaders().keySet()) {
            String headerVal = ((List)ctx.getRequest().getHeaders().get((Object)key)).toString();
            if (key.equals("X-Auth-Token")) {
                headerVal = this.maskHeaderValues((List)ctx.getRequest().getHeaders().get((Object)key));
            }
            this.log(">> Header: " + key + " = " + headerVal);
        }
        this.log(">> Body: " + ctx.getRequest().getBody());
        ClientResponse result = ctx.proceed();
        this.log("<< REST Response: " + result.getResponseStatus().getStatusCode() + ":" + result.getResponseStatus());
        for (Object key : result.getHeaders().keySet()) {
            this.log("<< Header: " + key + " = " + result.getHeaders().get(key));
        }
        return result;
    }

    private String maskHeaderValues(List<String> headerValues) {
        ArrayList<String> maskedList = new ArrayList<String>(headerValues.size());
        for (String actualValue : headerValues) {
            maskedList.add(actualValue.replaceAll(".", "*"));
        }
        return ((Object)maskedList).toString();
    }
}

