/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.rest.client.ApiKeyHeaderDecorator;
import org.zanata.rest.client.IAccountResource;
import org.zanata.rest.client.IFileResource;
import org.zanata.rest.client.IGlossaryResource;
import org.zanata.rest.client.IProjectIterationResource;
import org.zanata.rest.client.IProjectResource;
import org.zanata.rest.client.IProjectsResource;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ITranslationResourcesFactory;
import org.zanata.rest.client.IVersionResource;
import org.zanata.rest.client.TraceDebugInterceptor;
import org.zanata.rest.dto.VersionInfo;
import org.zanata.rest.service.AsynchronousProcessResource;
import org.zanata.rest.service.CopyTransResource;
import org.zanata.rest.service.StatisticsResource;

public class ZanataProxyFactory
implements ITranslationResourcesFactory {
    private String clientVersion;
    private String serverVersion;
    private static final Logger log;
    private final ClientRequestFactory crf;

    public ZanataProxyFactory(URI base, String username, String apiKey, VersionInfo clientApiVersion, boolean logHttp, boolean sslCertDisabled) {
        ClientExecutor clientExecutor = sslCertDisabled ? ZanataProxyFactory.createClientExecutor() : null;
        this.crf = new ClientRequestFactory(clientExecutor, null, ZanataProxyFactory.fixBase(base));
        this.registerPrefixInterceptor(new TraceDebugInterceptor(logHttp));
        this.registerPrefixInterceptor(new ApiKeyHeaderDecorator(username, apiKey, clientApiVersion.getVersionNo()));
        this.clientVersion = clientApiVersion.getVersionNo();
        String clientTimestamp = clientApiVersion.getBuildTimeStamp();
        IVersionResource iversion = this.createIVersionResource();
        ClientResponse versionResp = iversion.get();
        VersionInfo serverVersionInfo = null;
        if (versionResp.getResponseStatus() == Response.Status.UNAUTHORIZED) {
            throw new RuntimeException("Incorrect username/password");
        }
        serverVersionInfo = (VersionInfo)versionResp.getEntity();
        this.serverVersion = serverVersionInfo.getVersionNo();
        String serverTimestamp = serverVersionInfo.getBuildTimeStamp();
        log.info("client API version: {}, server API version: {}", (Object)this.clientVersion, (Object)this.serverVersion);
        if (!this.serverVersion.equals(this.clientVersion)) {
            log.warn("client API version is {}, but server API version is {}", (Object)this.clientVersion, (Object)this.serverVersion);
        } else if (this.serverVersion.contains("SNAPSHOT") && !serverTimestamp.equalsIgnoreCase(clientTimestamp)) {
            log.warn("client API timestamp is {}, but server API timestamp is {}", (Object)clientTimestamp, (Object)serverTimestamp);
        }
    }

    private static ClientExecutor createClientExecutor() {
        try {
            TrustManager[] trustOurCerts = new TrustManager[]{new AcceptAllX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustOurCerts, new SecureRandom());
            SSLSocketFactory factory = new SSLSocketFactory(sslContext);
            DefaultHttpClient client = new DefaultHttpClient();
            ClientConnectionManager manager = client.getConnectionManager();
            manager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)factory));
            return new ApacheHttpClient4Executor((HttpClient)client);
        }
        catch (Exception e) {
            log.warn("error disabling SSL certificate", (Throwable)e);
            log.warn("fall back to SSL certificate verification.");
            return null;
        }
    }

    private URL getBaseUrl() {
        try {
            return new URL(ZanataProxyFactory.fixBase(this.crf.getBase()).toString() + this.getUrlPrefix());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getUrlPrefix() {
        return "rest/";
    }

    public <T> T createProxy(Class<T> clazz, URI baseUri) {
        log.debug("{} proxy uri: {}", (Object)clazz.getSimpleName(), (Object)baseUri);
        Object proxy = this.crf.createProxy(clazz, baseUri);
        return (T)proxy;
    }

    public <T> T createProxy(Class<T> clazz) {
        try {
            return this.createProxy(clazz, new URI(this.getBaseUrl().toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static URI fixBase(URI base) {
        String baseString;
        if (base != null && !(baseString = base.toString()).endsWith("/")) {
            try {
                URI result = new URI(baseString + "/");
                log.warn("Appending '/' to base URL '{}': using '{}'", (Object)baseString, (Object)result);
                return result;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return base;
    }

    public IGlossaryResource getGlossaryResource() {
        return this.createProxy(IGlossaryResource.class, this.getGlossaryResourceURI());
    }

    public URI getGlossaryResourceURI() {
        try {
            URL url = new URL(this.getBaseUrl(), "glossary");
            return url.toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IAccountResource getAccount(String username) {
        return this.createProxy(IAccountResource.class, this.getAccountURI(username));
    }

    public URI getAccountURI(String username) {
        try {
            URL url = new URL(this.getBaseUrl(), "accounts/u/" + username);
            return url.toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IProjectResource getProject(String proj) {
        return this.createProxy(IProjectResource.class, this.getProjectURI(proj));
    }

    public URI getProjectURI(String proj) {
        try {
            URL url = new URL(this.getBaseUrl(), "projects/p/" + proj);
            return url.toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IProjectIterationResource getProjectIteration(String proj, String iter) {
        return this.createProxy(IProjectIterationResource.class, this.getProjectIterationURI(proj, iter));
    }

    public URI getProjectIterationURI(String proj, String iter) {
        try {
            URL url = new URL(this.getBaseUrl(), "projects/p/" + proj + "/iterations/i/" + iter);
            return url.toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IProjectsResource getProjects(URI uri) {
        return this.createProxy(IProjectsResource.class, uri);
    }

    @Override
    public ITranslatedDocResource getTranslatedDocResource(String projectSlug, String versionSlug) {
        return this.createProxy(ITranslatedDocResource.class, this.getResourceURI(projectSlug, versionSlug));
    }

    public ISourceDocResource getSourceDocResource(String projectSlug, String versionSlug) {
        return this.createProxy(ISourceDocResource.class, this.getResourceURI(projectSlug, versionSlug));
    }

    public IFileResource getFileResource() {
        return this.createProxy(IFileResource.class, this.getFileURI());
    }

    private URI getFileURI() {
        String spec = "file/";
        try {
            return new URL(this.getBaseUrl(), spec).toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            log.error("URI Syntax error. Part of url: {}", (Object)spec);
            throw new RuntimeException(e);
        }
    }

    public StatisticsResource getStatisticsResource() {
        return this.createProxy(StatisticsResource.class);
    }

    public CopyTransResource getCopyTransResource() {
        return this.createProxy(CopyTransResource.class);
    }

    public AsynchronousProcessResource getAsynchronousProcessResource() {
        return this.createProxy(AsynchronousProcessResource.class);
    }

    @Override
    public URI getResourceURI(String projectSlug, String versionSlug) {
        String spec = "projects/p/" + projectSlug + "/iterations/i/" + versionSlug + "/r";
        try {
            return new URL(this.getBaseUrl(), spec).toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            String msg = "URI Syntax error. Please make sure your project (project ID) and version are correct.";
            log.error(msg);
            log.error("part of your url: {}", (Object)spec);
            throw new RuntimeException(msg);
        }
    }

    public void registerPrefixInterceptor(Object interceptor) {
        this.crf.getPrefixInterceptors().registerInterceptor(interceptor);
    }

    protected IVersionResource createIVersionResource() {
        try {
            URL url = new URL(this.getBaseUrl(), "version");
            return this.createProxy(IVersionResource.class, url.toURI());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public int compareToServerVersion(String version) {
        DefaultArtifactVersion srvVersion = new DefaultArtifactVersion(this.serverVersion);
        DefaultArtifactVersion providedVersion = new DefaultArtifactVersion(version);
        return srvVersion.compareTo((ArtifactVersion)providedVersion);
    }

    static {
        ResteasyProviderFactory instance = ResteasyProviderFactory.getInstance();
        RegisterBuiltin.register((ResteasyProviderFactory)instance);
        log = LoggerFactory.getLogger(ZanataProxyFactory.class);
    }

    private static class AcceptAllX509TrustManager
    implements X509TrustManager {
        private AcceptAllX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

