/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.fn;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.util.Maps;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.web.util.resource.ServletContextLocator;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.Taglibs;
import org.zkoss.xel.util.SimpleResolver;
import org.zkoss.xel.util.SimpleXelContext;
import org.zkoss.xel.zel.ELFactory;

public class ThemeProperties {
    private static final ELFactory _ELF = new ELFactory();
    private static final String THEME_FN_URL = "http://www.zkoss.org/dsp/web/theme";
    private static final String CORE_FN_URL = "http://www.zkoss.org/dsp/web/core";

    private ThemeProperties() {
    }

    public static boolean loadProperties(ServletRequest req, String bundleName) {
        Locators.StreamLocation loc = Locators.locateAsStream((String)bundleName, null, (Locator)Locators.getDefault());
        if (loc != null) {
            return ThemeProperties.loadProperties(req, loc.stream);
        }
        String root = ((HttpServletRequest)req).getContextPath();
        ServletContext context = ServletFns.getCurrentServletContext();
        bundleName = bundleName.replace(root, "");
        return ThemeProperties.loadProperties(req, new ServletContextLocator(context).getResourceAsStream(bundleName));
    }

    public static boolean loadProperties(ServletRequest req, InputStream in) {
        LinkedHashMap<String, Object> pmap = new LinkedHashMap<String, Object>();
        try {
            Maps.load(pmap, (InputStream)in);
            return ThemeProperties.loadProperties(req, pmap);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean loadProperties(ServletRequest req, Map<String, Object> pmap) {
        Map<String, Object> map = ThemeProperties.getPropertyMap(req, "_theme");
        XelContext ctx = ThemeProperties.buildXelContext(map);
        for (Map.Entry<String, Object> e : pmap.entrySet()) {
            String v;
            Object objv = e.getValue();
            if (objv == null || Strings.isBlank((String)(v = objv.toString()))) continue;
            String w = v.contains("${") ? _ELF.evaluate(ctx, v, Object.class) : v;
            map.put(e.getKey(), w);
            req.setAttribute(e.getKey(), (Object)w);
        }
        return true;
    }

    public static Map<String, Object> getPropertyMap(ServletRequest req, String key) {
        Object obj = req.getAttribute(key);
        if (obj == null) {
            HashMap<String, Object> m = new HashMap<String, Object>(200);
            req.setAttribute(key, m);
            Enumeration names = req.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                m.put(name, req.getAttribute(name));
            }
            return m;
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        throw new IllegalStateException("Root node is not a Map: " + key);
    }

    private static XelContext buildXelContext(Map<String, Object> map) {
        List<Taglib> libs = Arrays.asList(new Taglib("t", THEME_FN_URL), new Taglib("c", CORE_FN_URL));
        FunctionMapper mapper = Taglibs.getFunctionMapper(libs, (Locator)Locators.getDefault());
        SimpleResolver resolver = new SimpleResolver(map);
        return new SimpleXelContext((VariableResolver)resolver, mapper);
    }
}

