/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.embeddedelasticsearch.HttpClient;
import pl.allegro.tech.embeddedelasticsearch.IndexRequest;
import pl.allegro.tech.embeddedelasticsearch.IndexSettings;
import pl.allegro.tech.embeddedelasticsearch.IndicesDescription;
import pl.allegro.tech.embeddedelasticsearch.TemplatesDescription;

class ElasticRestClient {
    private static final Logger logger = LoggerFactory.getLogger(ElasticRestClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private int elasticsearchHttpPort;
    private final HttpClient httpClient;
    private final IndicesDescription indicesDescription;
    private final TemplatesDescription templatesDescription;

    ElasticRestClient(int elasticsearchHttpPort, HttpClient httpClient, IndicesDescription indicesDescription, TemplatesDescription templatesDescription) {
        this.elasticsearchHttpPort = elasticsearchHttpPort;
        this.httpClient = httpClient;
        this.indicesDescription = indicesDescription;
        this.templatesDescription = templatesDescription;
    }

    void createIndices() {
        this.waitForClusterYellow();
        this.indicesDescription.getIndicesNames().forEach(this::createIndex);
    }

    void createIndex(String indexName) {
        if (!this.indexExists(indexName)) {
            HttpPut request = new HttpPut(this.url("/" + indexName));
            this.indicesDescription.getIndexSettings(indexName).ifPresent(indexSettings -> this.setIndexSettingsAsEntity(request, (IndexSettings)indexSettings));
            this.httpClient.execute((HttpRequestBase)request, response -> {
                if (response.getStatusLine().getStatusCode() != 200) {
                    String responseBody = this.readBodySafely((CloseableHttpResponse)response);
                    throw new RuntimeException("Call to elasticsearch resulted in error:\n" + responseBody);
                }
            });
            this.waitForClusterYellow();
        }
    }

    private void setIndexSettingsAsEntity(HttpPut request, IndexSettings indexSettings) {
        request.setEntity((HttpEntity)new StringEntity(indexSettings.toJson().toString(), ContentType.APPLICATION_JSON));
    }

    private boolean indexExists(String indexName) {
        HttpHead request = new HttpHead(this.url("/" + indexName));
        return this.httpClient.execute((HttpRequestBase)request, response -> response.getStatusLine().getStatusCode() == 200);
    }

    void createTemplates() {
        this.templatesDescription.getTemplatesNames().forEach(this::createTemplate);
    }

    void createTemplate(String templateName) {
        if (!this.templateExists(templateName)) {
            HttpPut request = new HttpPut(this.url("/_template/" + templateName));
            request.setEntity((HttpEntity)new StringEntity(this.templatesDescription.getTemplateSettings(templateName), ContentType.APPLICATION_JSON));
            this.httpClient.execute((HttpRequestBase)request, response -> {
                if (response.getStatusLine().getStatusCode() != 200) {
                    String responseBody = this.readBodySafely((CloseableHttpResponse)response);
                    throw new RuntimeException("Call to elasticsearch resulted in error:\n" + responseBody);
                }
            });
            this.waitForClusterYellow();
        }
    }

    private boolean templateExists(String templateName) {
        HttpHead request = new HttpHead(this.url("/" + templateName));
        return this.httpClient.execute((HttpRequestBase)request, response -> response.getStatusLine().getStatusCode() == 200);
    }

    void deleteTemplates() {
        this.templatesDescription.getTemplatesNames().forEach(this::deleteTemplate);
    }

    void deleteTemplate(String templateName) {
        if (this.indexExists(templateName)) {
            HttpDelete request = new HttpDelete(this.url("/_template/" + templateName));
            this.httpClient.execute((HttpRequestBase)request, response -> this.assertOk((CloseableHttpResponse)response, "Delete request resulted in error"));
            this.waitForClusterYellow();
        } else {
            logger.warn("Template: {} does not exists so cannot be removed", (Object)templateName);
        }
    }

    private void waitForClusterYellow() {
        HttpGet request = new HttpGet(this.url("/_cluster/health?wait_for_status=yellow&timeout=60s"));
        this.httpClient.execute((HttpRequestBase)request, response -> this.assertOk((CloseableHttpResponse)response, "Cluster does not reached yellow status in specified timeout"));
    }

    void deleteIndices() {
        this.indicesDescription.getIndicesNames().forEach(this::deleteIndex);
    }

    void deleteIndex(String indexName) {
        if (this.indexExists(indexName)) {
            HttpDelete request = new HttpDelete(this.url("/" + indexName));
            this.httpClient.execute((HttpRequestBase)request, response -> this.assertOk((CloseableHttpResponse)response, "Delete request resulted in error"));
            this.waitForClusterYellow();
        } else {
            logger.warn("Index: {} does not exists so cannot be removed", (Object)indexName);
        }
    }

    void bulkIndex(Collection<IndexRequest> indexRequests) {
        String bulkRequestBody = indexRequests.stream().flatMap(request -> Stream.of(this.indexMetadataJson(request.getIndexName(), request.getIndexType(), request.getId(), request.getRouting()), request.getJson())).map(jsonNodes -> jsonNodes.replace('\n', ' ').replace('\r', ' ')).collect(Collectors.joining("\n")) + "\n";
        this.performBulkRequest(this.url("/_bulk"), bulkRequestBody);
    }

    private String indexMetadataJson(String indexName, String indexType, String id, String routing) {
        StringJoiner joiner = new StringJoiner(",");
        if (indexName != null) {
            joiner.add("\"_index\": \"" + indexName + "\"");
        }
        if (indexType != null) {
            joiner.add("\"_type\": \"" + indexType + "\"");
        }
        if (id != null) {
            joiner.add("\"_id\": \"" + id + "\"");
        }
        if (routing != null) {
            joiner.add("\"_routing\": \"" + routing + "\"");
        }
        return "{ \"index\": {" + joiner.toString() + "} }";
    }

    void refresh() {
        HttpPost request = new HttpPost(this.url("/_refresh"));
        try {
            this.httpClient.execute((HttpRequestBase)request);
        }
        finally {
            request.releaseConnection();
        }
    }

    private void performBulkRequest(String requestUrl, String bulkRequestBody) {
        HttpPost request = new HttpPost(requestUrl);
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
        request.setEntity((HttpEntity)new StringEntity(bulkRequestBody, StandardCharsets.UTF_8));
        this.httpClient.execute((HttpRequestBase)request, response -> this.assertOk((CloseableHttpResponse)response, "Request finished with error"));
        this.refresh();
    }

    private String url(String path) {
        return "http://localhost:" + this.elasticsearchHttpPort + path;
    }

    private void assertOk(CloseableHttpResponse response, String message) {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IllegalStateException(message + "\nResponse body:\n" + this.readBodySafely(response));
        }
    }

    private String readBodySafely(CloseableHttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error during reading response body", (Throwable)e);
            return "";
        }
    }

    List<String> fetchAllDocuments(String ... indices) {
        return this.fetchAllDocuments((String)null, indices);
    }

    List<String> fetchAllDocuments(String routing, String ... indices) {
        if (indices.length == 0) {
            return this.searchForDocuments(Optional.empty()).collect(Collectors.toList());
        }
        return Stream.of(indices).flatMap(index -> this.searchForDocuments(Optional.of(index), Optional.ofNullable(routing))).collect(Collectors.toList());
    }

    private Stream<String> searchForDocuments(Optional<String> indexMaybe) {
        return this.searchForDocuments(indexMaybe, Optional.empty());
    }

    private Stream<String> searchForDocuments(Optional<String> indexMaybe, Optional<String> routing) {
        String searchCommand = this.prepareQuery(indexMaybe, routing);
        String body = this.fetchDocuments(searchCommand);
        return this.parseDocuments(body);
    }

    private String prepareQuery(Optional<String> indexMaybe, Optional<String> routing) {
        String routingQueryParam = routing.map(r -> "?routing=" + r).orElse("");
        return indexMaybe.map(index -> "/" + index + "/_search" + routingQueryParam).orElse("/_search");
    }

    private String fetchDocuments(String searchCommand) {
        HttpGet request = new HttpGet(this.url(searchCommand));
        return this.httpClient.execute((HttpRequestBase)request, response -> {
            this.assertOk((CloseableHttpResponse)response, "Error during search (" + searchCommand + ")");
            return this.readBodySafely((CloseableHttpResponse)response);
        });
    }

    private Stream<String> parseDocuments(String body) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(body);
            return StreamSupport.stream(jsonNode.get("hits").get("hits").spliterator(), false).map(hitNode -> hitNode.get("_source")).map(JsonNode::toString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

