/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import pl.allegro.tech.embeddedelasticsearch.DocumentWithId;
import pl.allegro.tech.embeddedelasticsearch.ElasticRestClient;
import pl.allegro.tech.embeddedelasticsearch.ElasticSearchInstaller;
import pl.allegro.tech.embeddedelasticsearch.ElasticServer;
import pl.allegro.tech.embeddedelasticsearch.HttpClient;
import pl.allegro.tech.embeddedelasticsearch.IndexSettings;
import pl.allegro.tech.embeddedelasticsearch.IndicesDescription;
import pl.allegro.tech.embeddedelasticsearch.InstallationDescription;
import pl.allegro.tech.embeddedelasticsearch.InstanceSettings;

public final class EmbeddedElastic {
    private final String esJavaOpts;
    private final InstanceSettings instanceSettings;
    private final IndicesDescription indicesDescription;
    private final InstallationDescription installationDescription;
    private final long startTimeoutInMs;
    private ElasticServer elasticServer;
    private ElasticRestClient elasticRestClient;

    public static Builder builder() {
        return new Builder();
    }

    private EmbeddedElastic(String esJavaOpts, InstanceSettings instanceSettings, IndicesDescription indicesDescription, InstallationDescription installationDescription, long startTimeoutInMs) {
        this.esJavaOpts = esJavaOpts;
        this.instanceSettings = instanceSettings;
        this.indicesDescription = indicesDescription;
        this.installationDescription = installationDescription;
        this.startTimeoutInMs = startTimeoutInMs;
    }

    public EmbeddedElastic start() throws IOException, InterruptedException {
        this.installElastic();
        this.startElastic();
        this.createRestClient();
        this.createIndices();
        return this;
    }

    private void installElastic() throws IOException, InterruptedException {
        ElasticSearchInstaller elasticSearchInstaller = new ElasticSearchInstaller(this.instanceSettings, this.installationDescription);
        elasticSearchInstaller.install();
        File executableFile = elasticSearchInstaller.getExecutableFile();
        File installationDirectory = elasticSearchInstaller.getInstallationDirectory();
        this.elasticServer = new ElasticServer(this.esJavaOpts, installationDirectory, executableFile, this.startTimeoutInMs, this.installationDescription.isCleanInstallationDirectoryOnStop());
    }

    private void startElastic() throws IOException, InterruptedException {
        if (!this.elasticServer.isStarted()) {
            this.elasticServer.start();
        }
    }

    private void createRestClient() throws UnknownHostException {
        this.elasticRestClient = new ElasticRestClient(this.elasticServer.getHttpPort(), new HttpClient(), this.indicesDescription);
    }

    public void stop() {
        this.elasticServer.stop();
    }

    public void index(String indexName, String indexType, Map<CharSequence, CharSequence> idJsonMap) {
        this.elasticRestClient.indexWithIds(indexName, indexType, idJsonMap.entrySet().stream().map(entry -> new DocumentWithId(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString())).collect(Collectors.toList()));
    }

    public void index(String indexName, String indexType, String ... json) {
        this.index(indexName, indexType, Arrays.asList(json));
    }

    public void index(String indexName, String indexType, List<CharSequence> jsons) {
        this.elasticRestClient.indexWithIds(indexName, indexType, jsons.stream().map(json -> new DocumentWithId(null, json.toString())).collect(Collectors.toList()));
    }

    public void recreateIndices() {
        this.deleteIndices();
        this.createIndices();
    }

    public void recreateIndex(String indexName) {
        this.deleteIndex(indexName);
        this.createIndex(indexName);
    }

    public void deleteIndices() {
        this.elasticRestClient.deleteIndices();
    }

    public void deleteIndex(String indexName) {
        this.elasticRestClient.deleteIndex(indexName);
    }

    public void createIndices() {
        this.elasticRestClient.createIndices();
    }

    public void createIndex(String indexName) {
        this.elasticRestClient.createIndex(indexName);
    }

    public void refreshIndices() {
        this.elasticRestClient.refresh();
    }

    public List<String> fetchAllDocuments(String ... indices) throws UnknownHostException {
        return this.elasticRestClient.fetchAllDocuments(indices);
    }

    public int getTransportTcpPort() {
        return this.elasticServer.getTransportTcpPort();
    }

    public int getHttpPort() {
        return this.elasticServer.getHttpPort();
    }

    public static final class Builder {
        private Optional<String> version = Optional.empty();
        private List<InstallationDescription.Plugin> plugins = new ArrayList<InstallationDescription.Plugin>();
        private Optional<URL> downloadUrl = Optional.empty();
        private Map<String, IndexSettings> indices = new HashMap<String, IndexSettings>();
        private InstanceSettings settings = new InstanceSettings();
        private String esJavaOpts = "";
        private long startTimeoutInMs = 15000L;
        private boolean cleanInstallationDirectoryOnStop = true;
        private Optional<File> installationDirectory = Optional.empty();
        private Optional<File> downloadDirectory = Optional.empty();

        private Builder() {
        }

        public Builder withSetting(String name, Object value) {
            this.settings = this.settings.withSetting(name, value);
            return this;
        }

        public Builder withEsJavaOpts(String javaOpts) {
            this.esJavaOpts = javaOpts;
            return this;
        }

        public Builder withInstallationDirectory(File installationDirectory) {
            this.installationDirectory = Optional.of(installationDirectory);
            return this;
        }

        public Builder withDownloadDirectory(File downloadDirectory) {
            this.downloadDirectory = Optional.of(downloadDirectory);
            return this;
        }

        public Builder withCleanInstallationDirectoryOnStop(boolean cleanInstallationDirectoryOnStop) {
            this.cleanInstallationDirectoryOnStop = cleanInstallationDirectoryOnStop;
            return this;
        }

        public Builder withElasticVersion(String version) {
            this.version = Optional.of(version);
            return this;
        }

        public Builder withDownloadUrl(URL downloadUrl) {
            this.downloadUrl = Optional.of(downloadUrl);
            return this;
        }

        public Builder withPlugin(String expression) {
            this.plugins.add(new InstallationDescription.Plugin(expression));
            return this;
        }

        public Builder withIndex(String indexName) {
            return this.withIndex(indexName, IndexSettings.builder().build());
        }

        public Builder withIndex(String indexName, IndexSettings indexSettings) {
            this.indices.put(indexName, indexSettings);
            return this;
        }

        public Builder withStartTimeout(long value, TimeUnit unit) {
            this.startTimeoutInMs = unit.toMillis(value);
            return this;
        }

        public EmbeddedElastic build() {
            return new EmbeddedElastic(this.esJavaOpts, this.settings, new IndicesDescription(this.indices), new InstallationDescription(this.version, this.downloadUrl, this.downloadDirectory, this.installationDirectory, this.cleanInstallationDirectoryOnStop, this.plugins), this.startTimeoutInMs);
        }
    }
}

