/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import pl.allegro.tech.embeddedelasticsearch.TypeWithMapping;

public class IndexSettings {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final List<TypeWithMapping> types;
    private final Optional<JsonNode> settings;

    public static Builder builder() {
        return new Builder();
    }

    public IndexSettings(List<TypeWithMapping> types, Optional<String> settings) {
        this.types = types;
        this.settings = settings.map(rawSettingsJson -> {
            try {
                return OBJECT_MAPPER.readTree(rawSettingsJson);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem with provided settings for index", e);
            }
        });
    }

    public ObjectNode toJson() {
        ObjectNode objectNode = new ObjectMapper().createObjectNode();
        objectNode.set("settings", this.settings.orElse((JsonNode)OBJECT_MAPPER.createObjectNode()));
        ObjectNode mappingsObject = this.prepareMappingsObject();
        objectNode.set("mappings", (JsonNode)mappingsObject);
        return objectNode;
    }

    private ObjectNode prepareMappingsObject() {
        ObjectNode mappingsObject = OBJECT_MAPPER.createObjectNode();
        this.types.forEach(type -> mappingsObject.set(type.getType(), type.getMapping()));
        return mappingsObject;
    }

    public static class Builder {
        private final List<TypeWithMapping> types = new ArrayList<TypeWithMapping>();
        private Optional<String> settings = Optional.empty();

        public Builder withType(String type, InputStream mapping) throws IOException {
            return this.withType(type, IOUtils.toString((InputStream)mapping, (Charset)StandardCharsets.UTF_8));
        }

        public Builder withType(String type, String mapping) {
            this.types.add(new TypeWithMapping(type, mapping));
            return this;
        }

        public Builder withSettings(InputStream settings) throws IOException {
            return this.withSettings(IOUtils.toString((InputStream)settings, (Charset)StandardCharsets.UTF_8));
        }

        public Builder withSettings(String settings) {
            this.settings = Optional.of(settings);
            return this;
        }

        public IndexSettings build() {
            return new IndexSettings(this.types, this.settings);
        }
    }
}

