/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.embeddedelasticsearch.DocumentWithId;
import pl.allegro.tech.embeddedelasticsearch.HttpClient;
import pl.allegro.tech.embeddedelasticsearch.IndicesDescription;

class ElasticRestClient {
    private static final Logger logger = LoggerFactory.getLogger(ElasticRestClient.class);
    private int elasticsearchHttpPort;
    private final HttpClient httpClient;
    private final IndicesDescription indicesDescription;

    ElasticRestClient(int elasticsearchHttpPort, HttpClient httpClient, IndicesDescription indicesDescription) {
        this.elasticsearchHttpPort = elasticsearchHttpPort;
        this.httpClient = httpClient;
        this.indicesDescription = indicesDescription;
    }

    void createIndices() {
        this.indicesDescription.getIndicesNames().forEach(this::createIndex);
    }

    void createIndex(String indexName) {
        if (!this.indexExists(indexName)) {
            HttpPut request = new HttpPut(this.url("/" + indexName));
            request.setEntity((HttpEntity)new StringEntity(this.indicesDescription.getIndexSettings(indexName).toJson().toString(), ContentType.APPLICATION_JSON));
            CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                String responseBody = this.readBodySafely(response);
                throw new RuntimeException("Call to elasticsearch resulted in error:\n" + responseBody);
            }
            this.waitForClusterYellow();
        }
    }

    private boolean indexExists(String indexName) {
        HttpHead request = new HttpHead(this.url("/" + indexName));
        CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)request);
        return response.getStatusLine().getStatusCode() == 200;
    }

    private void waitForClusterYellow() {
        HttpGet request = new HttpGet(this.url("/_cluster/health?wait_for_status=yellow&timeout=60s"));
        CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)request);
        this.assertOk(response, "Cluster does not reached yellow status in specified timeout");
    }

    void deleteIndices() {
        this.indicesDescription.getIndicesNames().forEach(this::deleteIndex);
    }

    void deleteIndex(String indexName) {
        if (this.indexExists(indexName)) {
            HttpDelete request = new HttpDelete(this.url("/" + indexName));
            this.assertOk(this.httpClient.execute((HttpRequestBase)request), "Delete request resulted in error");
            this.waitForClusterYellow();
        } else {
            logger.warn("Index: {} does not exists so cannot be removed", (Object)indexName);
        }
    }

    void indexWithIds(String indexName, String indexType, Collection<DocumentWithId> idJsonMap) {
        String bulkRequestBody = idJsonMap.stream().flatMap(json -> Stream.of(this.indexMetadataJsonWithId(json.getId()), json.getDocument())).map(jsonNodes -> jsonNodes.replace('\n', ' ').replace('\r', ' ')).collect(Collectors.joining("\n")) + "\n";
        HttpPost request = new HttpPost(this.url("/" + indexName + "/" + indexType + "/_bulk"));
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
        request.setEntity((HttpEntity)new StringEntity(bulkRequestBody, StandardCharsets.UTF_8));
        CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)request);
        this.assertOk(response, "Request finished with error");
        this.refresh();
    }

    private String indexMetadataJsonWithId(String id) {
        if (id == null) {
            return "{ \"index\": {} }";
        }
        return "{ \"index\": { \"_id\": \"" + id + "\"} }";
    }

    void refresh() {
        HttpPost request = new HttpPost(this.url("/_refresh"));
        this.httpClient.execute((HttpRequestBase)request);
    }

    private String url(String path) {
        return "http://localhost:" + this.elasticsearchHttpPort + path;
    }

    private void assertOk(CloseableHttpResponse response, String message) {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IllegalStateException(message + "\nResponse body:\n" + this.readBodySafely(response));
        }
    }

    private String readBodySafely(CloseableHttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error during reading response body", (Throwable)e);
            return "";
        }
    }

    List<String> fetchAllDocuments(String ... indices) {
        if (indices.length == 0) {
            return this.searchForDocuments(Optional.empty()).collect(Collectors.toList());
        }
        return Stream.of(indices).flatMap(index -> this.searchForDocuments(Optional.of(index))).collect(Collectors.toList());
    }

    private Stream<String> searchForDocuments(Optional<String> indexMaybe) {
        String searchCommand = indexMaybe.map(index -> "/" + index + "/_search").orElse("/_search");
        HttpGet request = new HttpGet(this.url(searchCommand));
        CloseableHttpResponse response = this.httpClient.execute((HttpRequestBase)request);
        this.assertOk(response, "Error during search (" + searchCommand + ")");
        String body = this.readBodySafely(response);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(body);
            return StreamSupport.stream(jsonNode.get("hits").get("hits").spliterator(), false).map(hitNode -> hitNode.get("_source")).map(JsonNode::toString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

