/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.embeddedelasticsearch.ElasticDownloadUrlUtils;
import pl.allegro.tech.embeddedelasticsearch.EmbeddedElasticsearchStartupException;
import pl.allegro.tech.embeddedelasticsearch.InstallationDescription;
import pl.allegro.tech.embeddedelasticsearch.InstanceSettings;

class ElasticSearchInstaller {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchInstaller.class);
    private static final String ELS_PACKAGE_STATUS_FILE_SUFFIX = "-downloaded";
    private static final String ELS_PACKAGE_PREFIX = "elasticsearch-";
    private static final List<String> ELS_EXECUTABLE_FILES = Arrays.asList("elasticsearch", "elasticsearch.in.sh");
    private final InstanceSettings instanceSettings;
    private final InstallationDescription installationDescription;

    ElasticSearchInstaller(InstanceSettings instanceSettings, InstallationDescription installationDescription) {
        this.instanceSettings = instanceSettings;
        this.installationDescription = installationDescription;
    }

    File getExecutableFile() {
        return this.fileRelativeToInstallationDir("bin", this.systemDependentExtension("elasticsearch"));
    }

    File getInstallationDirectory() {
        return FileUtils.getFile((File)this.installationDescription.getInstallationDirectory(), (String[])new String[]{ELS_PACKAGE_PREFIX + this.installationDescription.getVersion()});
    }

    File getDownloadDirectory() {
        return FileUtils.getFile((File)this.installationDescription.getDownloadDirectory(), (String[])new String[0]);
    }

    void install() throws IOException, InterruptedException {
        this.prepareDirectories();
        this.installElastic();
        this.configureElastic();
        this.installPlugins();
        this.applyElasticPermissionRights();
    }

    private void prepareDirectories() throws IOException {
        FileUtils.forceMkdir((File)this.getInstallationDirectory());
        FileUtils.forceMkdir((File)this.getDownloadDirectory());
    }

    private void installElastic() throws IOException {
        Path downloadedTo = this.download(this.installationDescription.getDownloadUrl());
        this.install("Elasticsearch", "", downloadedTo);
    }

    private void configureElastic() throws IOException {
        File elasticsearchYml = FileUtils.getFile((File)this.getInstallationDirectory(), (String[])new String[]{"config", "elasticsearch.yml"});
        FileUtils.writeStringToFile((File)elasticsearchYml, (String)this.instanceSettings.toYaml(), (Charset)StandardCharsets.UTF_8);
    }

    private void installPlugins() throws IOException, InterruptedException {
        File pluginManager = this.pluginManagerExecutable();
        this.setExecutable(pluginManager);
        for (InstallationDescription.Plugin plugin : this.installationDescription.getPlugins()) {
            logger.info("> " + pluginManager + " install " + plugin.getExpression());
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            builder.command(this.prepareInstallCommand(pluginManager, plugin));
            Process process = builder.start();
            if (process.waitFor() == 0) continue;
            throw new EmbeddedElasticsearchStartupException("Unable to install plugin: " + plugin);
        }
    }

    private String[] prepareInstallCommand(File pluginManager, InstallationDescription.Plugin plugin) {
        if (this.installationDescription.versionIs1x() && plugin.expressionIsUrl()) {
            return new String[]{pluginManager.getAbsolutePath(), "--install", plugin.getPluginName(), "--url", plugin.getExpression()};
        }
        return new String[]{pluginManager.getAbsolutePath(), "install", plugin.getExpression()};
    }

    private File pluginManagerExecutable() {
        File elasticsearchPlugin = this.fileRelativeToInstallationDir("bin", this.systemDependentExtension("elasticsearch-plugin"));
        if (elasticsearchPlugin.exists()) {
            return elasticsearchPlugin;
        }
        return this.fileRelativeToInstallationDir("bin", this.systemDependentExtension("plugin"));
    }

    private String systemDependentExtension(String baseFileName) {
        return baseFileName + (SystemUtils.IS_OS_WINDOWS ? ".bat" : "");
    }

    private File fileRelativeToInstallationDir(String ... path) {
        return FileUtils.getFile((File)this.getInstallationDirectory(), (String[])path);
    }

    private Path download(URL source) throws IOException {
        File target = new File(this.getDownloadDirectory(), ElasticDownloadUrlUtils.constructLocalFileName(source));
        File statusFile = new File(target.getParentFile(), target.getName() + ELS_PACKAGE_STATUS_FILE_SUFFIX);
        this.removeBrokenDownload(target, statusFile);
        if (!target.exists()) {
            this.download(source, target, statusFile);
        } else if (!statusFile.exists() && this.maybeDownloading(target)) {
            this.waitForDownload(target, statusFile);
        } else {
            if (!statusFile.exists()) {
                throw new IOException("Broken download. File '" + target + "' exits but status '" + statusFile + "' file wash not created");
            }
            logger.info("Download skipped");
        }
        return target.toPath();
    }

    private void removeBrokenDownload(File target, File statusFile) throws IOException {
        if (target.exists() && !statusFile.exists() && !this.maybeDownloading(target)) {
            logger.info("Removing broken download file {}", (Object)target);
            FileUtils.forceDelete((File)target);
        }
    }

    private boolean maybeDownloading(File target) {
        return System.currentTimeMillis() - target.lastModified() < TimeUnit.SECONDS.toMillis(10L);
    }

    private void download(URL source, File target, File statusFile) throws IOException {
        logger.info("Downloading {} to {} ...", (Object)source, (Object)target);
        FileUtils.copyURLToFile((URL)source, (File)target);
        FileUtils.touch((File)statusFile);
        logger.info("Download complete");
    }

    private void waitForDownload(File target, File statusFile) throws IOException {
        boolean downloaded;
        do {
            logger.info("File {} (size={}) is probably being downloaded by another thread/jvm. Waiting ...", (Object)target, (Object)target.length());
        } while (!(downloaded = FileUtils.waitFor((File)statusFile, (int)30)) && this.maybeDownloading(target));
        if (!downloaded) {
            throw new IOException("Broken download. Another party probably failed to download " + target);
        }
        logger.info("File was downloaded by another thread/jvm. Download skipped");
    }

    private void install(String what, String relativePath, Path downloadedFile) throws IOException {
        Path destination = new File(this.getInstallationDirectory().getParentFile(), relativePath).toPath();
        logger.info("Installing " + what + " into " + destination + "...");
        try {
            ZipFile zipFile = new ZipFile(downloadedFile.toString());
            zipFile.extractAll(destination.toString());
            logger.info("Done");
        }
        catch (ZipException e) {
            logger.info("Failure : " + (Object)((Object)e));
            throw new EmbeddedElasticsearchStartupException(e);
        }
    }

    private void applyElasticPermissionRights() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        File binDirectory = FileUtils.getFile((File)this.getInstallationDirectory(), (String[])new String[]{"bin"});
        for (String fn : ELS_EXECUTABLE_FILES) {
            this.setExecutable(new File(binDirectory, fn));
        }
    }

    private void setExecutable(File executableFile) throws IOException {
        logger.info("Applying executable permissions on " + executableFile);
        executableFile.setExecutable(true);
    }
}

