/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.embeddedelasticsearch;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import pl.allegro.tech.embeddedelasticsearch.ElasticDownloadUrlUtils;
import pl.allegro.tech.embeddedelasticsearch.Require;

class InstallationDescription {
    private static final Supplier<File> DEFAULT_INSTALL_DIR = () -> new File(System.getProperty("java.io.tmpdir"), "embedded-elasticsearch-temp-dir");
    private static final Supplier<File> DEFAULT_DOWNLOAD_DIR = DEFAULT_INSTALL_DIR;
    private final String version;
    private final URL downloadUrl;
    private final List<Plugin> plugins;
    private final boolean cleanInstallationDirectoryOnStop;
    private final File installationDirectory;
    private final File downloadDirectory;

    InstallationDescription(Optional<String> versionMaybe, Optional<URL> downloadUrlMaybe, Optional<File> downloadDirectory, Optional<File> installationDirectory, boolean cleanInstallationDirectoryOnStop, List<Plugin> plugins) {
        Require.require(versionMaybe.isPresent() ^ downloadUrlMaybe.isPresent(), "You must specify elasticsearch version, or download url");
        if (versionMaybe.isPresent()) {
            this.version = versionMaybe.get();
            this.downloadUrl = ElasticDownloadUrlUtils.urlFromVersion(versionMaybe.get());
        } else {
            this.version = ElasticDownloadUrlUtils.versionFromUrl(downloadUrlMaybe.get());
            this.downloadUrl = downloadUrlMaybe.get();
        }
        this.plugins = plugins;
        this.cleanInstallationDirectoryOnStop = cleanInstallationDirectoryOnStop;
        this.installationDirectory = FileUtils.getFile((File)installationDirectory.orElseGet(DEFAULT_INSTALL_DIR), (String[])new String[0]);
        this.downloadDirectory = FileUtils.getFile((File)downloadDirectory.orElseGet(DEFAULT_DOWNLOAD_DIR), (String[])new String[0]);
    }

    String getVersion() {
        return this.version;
    }

    URL getDownloadUrl() {
        return this.downloadUrl;
    }

    List<Plugin> getPlugins() {
        return this.plugins;
    }

    boolean versionIs1x() {
        return this.version.startsWith("1.");
    }

    boolean isCleanInstallationDirectoryOnStop() {
        return this.cleanInstallationDirectoryOnStop;
    }

    File getInstallationDirectory() {
        return this.installationDirectory;
    }

    public File getDownloadDirectory() {
        return this.downloadDirectory;
    }

    static class Plugin {
        private String expression;

        Plugin(String expression) {
            this.expression = expression;
        }

        String getExpression() {
            return this.expression;
        }

        public String toString() {
            return this.expression;
        }

        String getPluginName() {
            if (this.expressionIsUrl()) {
                return FilenameUtils.getBaseName((String)this.expression).replaceAll("-[\\d].*", "");
            }
            return this.expression;
        }

        boolean expressionIsUrl() {
            return this.expression.startsWith("http");
        }
    }
}

