/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.ircbot;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.codehaus.plexus.ircbot.IrcBot;

public abstract class AbstractIrcBot
implements IrcBot {
    private BufferedReader input;
    private BufferedWriter output;
    private Socket clientSocket;
    private String botName;
    private String botDescription;

    public void connect(String serverHostname, int serverPort) {
        this.connect(serverHostname, serverPort, null);
    }

    public void connect(String serverHostname, int serverPort, String botName) {
        this.botName = botName;
        try {
            this.clientSocket = new Socket(serverHostname, serverPort);
        }
        catch (Exception e) {
            System.err.println("error connecting to IRC server");
            e.printStackTrace();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.clientSocket.getInputStream();
            outputStream = this.clientSocket.getOutputStream();
        }
        catch (Exception e) {
            System.err.println("error opening streams to IRC server");
            e.printStackTrace();
            System.exit(0);
        }
        this.input = new BufferedReader(new InputStreamReader(inputStream));
        this.output = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public void disconnect() {
        try {
            this.input.close();
            this.output.close();
        }
        catch (IOException e) {
            System.err.println("Error disconnecting from IRC server");
            e.printStackTrace();
        }
    }

    public boolean ircsend(String message) {
        System.out.println("irc: '" + message + "'");
        try {
            this.output.write(message);
            this.output.newLine();
            this.output.flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void logoff() {
        BufferedWriter bw = this.output;
        try {
            if (!this.ircsend("quit terminating")) {
                // empty if block
            }
            bw.write("quit terminating");
            bw.newLine();
            bw.flush();
        }
        catch (Exception e) {
            System.out.println("logoff error: " + e);
            System.exit(0);
        }
    }

    public void logon() {
        BufferedWriter bw = this.output;
        try {
            bw.write("user " + this.botName + " ware2 irc :" + this.botDescription);
            bw.newLine();
            bw.write("nick " + this.botName);
            bw.newLine();
            bw.flush();
        }
        catch (Exception e) {
            System.out.println("logon error: " + e);
            System.exit(0);
        }
    }

    private void parsePrivateMessage(String username, String params) {
        System.out.println("parse_privmsg passed '" + params + "' from '" + username + "'");
        String me = params.substring(0, params.indexOf(32));
        params = params.substring(params.indexOf(32) + 1);
        String message = params.substring(0, 1).equals(":") ? params.substring(1) : params.substring(0);
        this.processPrivateMessage(username, message);
    }

    private boolean pingpong(String msg) throws IOException {
        if (msg.substring(0, 4).equalsIgnoreCase("ping")) {
            String pongmsg = "pong " + msg.substring(5);
            this.output.write(pongmsg);
            this.output.newLine();
            this.output.flush();
            System.out.println("ping pong");
            return true;
        }
        return false;
    }

    public boolean sendNotice(String username, String message) {
        String command = "notice " + username + " :" + message;
        return this.ircsend(command);
    }

    public boolean sendPrivateMessage(String username, String message) {
        String command = "privmsg " + username + " :" + message;
        return this.ircsend(command);
    }

    public boolean sendMessageToChannel(String channel, String message) {
        return this.sendPrivateMessage(channel, message);
    }

    public void service() {
        try {
            if (this.input.ready()) {
                String msg = this.input.readLine();
                if (!this.pingpong(msg)) {
                    String prefix = null;
                    String command = null;
                    String params = null;
                    if (msg.substring(0, 1).equals(":")) {
                        prefix = msg.substring(1, msg.indexOf(32));
                        msg = msg.substring(msg.indexOf(32) + 1);
                    }
                    command = msg.substring(0, msg.indexOf(32));
                    params = msg.substring(msg.indexOf(32) + 1);
                    System.out.println("prefix: '" + prefix + "' command: '" + command + "' params: '" + params + "'");
                    if (command.equalsIgnoreCase("privmsg")) {
                        String username = null;
                        username = prefix.indexOf(33) != -1 ? prefix.substring(0, prefix.indexOf("!")) : prefix;
                        this.parsePrivateMessage(username, params);
                    }
                }
            } else {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            System.out.println("error: " + e);
            System.exit(0);
        }
    }

    public String getLogin() {
        return this.botName;
    }

    public void setLogin(String login) {
        this.botName = login;
    }

    public String getFullName() {
        return this.botDescription;
    }

    public void setFullName(String fullName) {
        this.botDescription = fullName;
    }

    protected void processPrivateMessage(String user, String text) {
    }
}

