/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.jetty;

import ro.pippo.core.PippoSettings;
import ro.pippo.core.WebServerSettings;

public class JettySettings
extends WebServerSettings {
    public static final String MAX_THREADS = "jetty.maxThreads";
    public static final String MIN_THREADS = "jetty.minThreads";
    public static final String IDLE_TIMEOUT = "jetty.idleTimeout";
    public static final int DEFAULT_MAX_THREADS = 200;
    public static final int DEFAULT_MIN_THREADS = 8;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    private int maxThreads;
    private int minThreads;
    private int idleTimeout;

    public JettySettings(PippoSettings pippoSettings) {
        super(pippoSettings);
        this.maxThreads = pippoSettings.getInteger(MAX_THREADS, 0);
        this.minThreads = pippoSettings.getInteger(MIN_THREADS, 0);
        this.idleTimeout = pippoSettings.getInteger(IDLE_TIMEOUT, 0);
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public JettySettings maxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public JettySettings minThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public JettySettings idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }
}

