/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.jetty.websocket;

import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.websocket.WebSocketConnection;
import ro.pippo.core.websocket.WebSocketContext;
import ro.pippo.core.websocket.WebSocketHandler;
import ro.pippo.jetty.websocket.JettyWebSocketConnection;

public class JettyWebSocketAdapter
implements WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(JettyWebSocketAdapter.class);
    private static List<WebSocketConnection> connections = new CopyOnWriteArrayList<WebSocketConnection>();
    private final WebSocketHandler handler;
    private final Map<String, String> pathParameters;
    private WebSocketContext context;
    private WebSocketConnection connection;

    public JettyWebSocketAdapter(WebSocketHandler handler, Map<String, String> pathParameters) {
        this.handler = handler;
        this.pathParameters = pathParameters;
    }

    public void onWebSocketConnect(Session session) {
        this.connection = new JettyWebSocketConnection(session);
        connections.add(this.connection);
        this.context = new WebSocketContext(connections, this.connection, this.pathParameters);
        this.handler.onOpen(this.context);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.handler.onClose(this.context, statusCode, reason);
        connections.remove(this.connection);
    }

    public void onWebSocketError(Throwable cause) {
        if (cause instanceof SocketTimeoutException) {
            this.handler.onTimeout(this.context);
        } else {
            log.error("An error occurred when using WebSocket", cause);
            this.handler.onError(this.context, cause);
        }
    }

    public void onWebSocketText(String message) {
        this.handler.onMessage(this.context, message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        ByteBuffer buffer = ByteBuffer.wrap(payload, offset, len);
        this.handler.onMessage(this.context, buffer.array());
    }
}

