/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.jetty.websocket;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Request;
import ro.pippo.core.Response;
import ro.pippo.core.websocket.AbstractWebSocketFilter;
import ro.pippo.core.websocket.WebSocketRouter;
import ro.pippo.jetty.websocket.JettyWebSocketAdapter;

public class JettyWebSocketFilter
extends AbstractWebSocketFilter {
    private static final Logger log = LoggerFactory.getLogger(JettyWebSocketFilter.class);
    private WebSocketServerFactory webSocketFactory;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            String maxTextMessageSize;
            String idleTimeout;
            WebSocketPolicy serverPolicy = WebSocketPolicy.newServerPolicy();
            String inputBufferSize = filterConfig.getInitParameter("inputBufferSize");
            if (inputBufferSize != null) {
                serverPolicy.setInputBufferSize(Integer.parseInt(inputBufferSize));
            }
            if ((idleTimeout = filterConfig.getInitParameter("idleTimeout")) != null) {
                serverPolicy.setIdleTimeout((long)Integer.parseInt(idleTimeout));
            }
            if ((maxTextMessageSize = filterConfig.getInitParameter("maxTextMessageSize")) != null) {
                serverPolicy.setMaxTextMessageSize(Integer.parseInt(maxTextMessageSize));
            }
            this.webSocketFactory = new WebSocketServerFactory(filterConfig.getServletContext(), serverPolicy);
            this.webSocketFactory.setCreator((request, response) -> this.createWebSocketAdapter(request));
            this.webSocketFactory.start();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        if (this.webSocketFactory != null) {
            try {
                this.webSocketFactory.stop();
            }
            catch (Exception e) {
                log.warn("A problem occurred while stopping the web socket factory", (Throwable)e);
            }
        }
        super.destroy();
    }

    protected boolean acceptWebSocket(Request request, Response response) throws IOException, ServletException {
        return super.acceptWebSocket(request, response) && this.webSocketFactory.acceptWebSocket(request.getHttpServletRequest(), response.getHttpServletResponse());
    }

    protected JettyWebSocketAdapter createWebSocketAdapter(ServletUpgradeRequest request) {
        WebSocketRouter.WebSocketMatch match = this.findWebSocketRoute(request.getRequestPath());
        return new JettyWebSocketAdapter(match.getHandler(), match.getPathParameters());
    }
}

