/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.bundle.lookup;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;

public class PropertyBundleLookup
implements GuiceyBundleLookup {
    public static final String BUNDLES_PROPERTY = "guicey.bundles";

    @Override
    public List<GuiceyBundle> lookup() {
        String prop = System.getProperty(BUNDLES_PROPERTY);
        List<GuiceyBundle> res = Collections.emptyList();
        if (prop != null) {
            Iterable classes = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)prop);
            try {
                res = this.toInstances(this.toClasses(classes));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to parse bundles system property '%s' value: '%s'", BUNDLES_PROPERTY, prop), e);
            }
        }
        return res;
    }

    @SafeVarargs
    public static void enableBundles(Class<? extends GuiceyBundle> ... bundles) {
        String prop = Joiner.on((char)',').join(PropertyBundleLookup.toStrings(Lists.newArrayList((Object[])bundles)));
        System.setProperty(BUNDLES_PROPERTY, prop);
    }

    private static List<String> toStrings(Iterable<Class<? extends GuiceyBundle>> list) {
        ArrayList res = Lists.newArrayList();
        for (Class<? extends GuiceyBundle> cls : list) {
            res.add(cls.getName());
        }
        return res;
    }

    private List<Class<GuiceyBundle>> toClasses(Iterable<String> list) throws Exception {
        ArrayList res = Lists.newArrayList();
        for (String cls : list) {
            res.add(Class.forName(cls));
        }
        return res;
    }

    private List<GuiceyBundle> toInstances(Iterable<Class<GuiceyBundle>> list) throws Exception {
        ArrayList res = Lists.newArrayList();
        for (Class<GuiceyBundle> cls : list) {
            res.add(cls.newInstance());
        }
        return res;
    }
}

