/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.info.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;

public class ItemInfoImpl
implements ItemInfo {
    private final ConfigItem itemType;
    private final Class<?> type;
    private final Set<Class<?>> registeredBy = Sets.newLinkedHashSet();
    private Class<?> registrationScope;
    private int registrationAttempts;

    public ItemInfoImpl(ConfigItem itemType, Class<?> type) {
        this.itemType = itemType;
        this.type = type;
    }

    @Override
    public ConfigItem getItemType() {
        return this.itemType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Set<Class<?>> getRegisteredBy() {
        return this.registeredBy;
    }

    @Override
    public int getRegistrationAttempts() {
        return this.registrationAttempts;
    }

    @Override
    public boolean isRegistered() {
        return !this.registeredBy.isEmpty();
    }

    @Override
    public boolean isRegisteredDirectly() {
        return this.getRegisteredBy().contains(ConfigScope.Application.getType());
    }

    @Override
    public Class<?> getRegistrationScope() {
        return this.registrationScope;
    }

    @Override
    public ConfigScope getRegistrationScopeType() {
        return ConfigScope.recognize(this.getRegistrationScope());
    }

    public void countRegistrationAttempt() {
        ++this.registrationAttempts;
    }

    public void setRegistrationScope(Class<?> registrationScope) {
        this.registrationScope = registrationScope;
    }

    public String toString() {
        return this.itemType.name() + " " + this.type.getSimpleName();
    }
}

