/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.stat;

import com.google.common.base.Preconditions;

public enum Stat {
    GuiceyTime(true),
    CommandTime(true),
    ScanTime(true),
    ScanClassesCount(false),
    BundleTime(true),
    BundleResolutionTime(true),
    InjectorCreationTime(true),
    InstallersTime(true),
    ExtensionsRecognitionTime(true),
    ExtensionsInstallationTime(true),
    HKTime(true),
    JerseyInstallerTime(true);

    private boolean timer;

    private Stat(boolean timer) {
        this.timer = timer;
    }

    public boolean isTimer() {
        return this.timer;
    }

    public void requiresTimer() {
        Preconditions.checkState((boolean)this.isTimer(), (String)"%s is not timer stat", (Object)this.name());
    }

    public void requiresCounter() {
        Preconditions.checkState((!this.isTimer() ? 1 : 0) != 0, (String)"%s is not counter stat", (Object)this.name());
    }
}

