/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationTreeAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;
import ru.vyarus.dropwizard.guice.module.support.OptionsAwareModule;

public final class ModulesSupport {
    private ModulesSupport() {
    }

    public static void configureModules(ConfigurationContext context) {
        Options options = new Options(context.options());
        for (Module mod : context.getEnabledModules()) {
            if (mod instanceof BootstrapAwareModule) {
                ((BootstrapAwareModule)mod).setBootstrap(context.getBootstrap());
            }
            if (mod instanceof ConfigurationAwareModule) {
                ((ConfigurationAwareModule)mod).setConfiguration(context.getConfiguration());
            }
            if (mod instanceof ConfigurationTreeAwareModule) {
                ((ConfigurationTreeAwareModule)mod).setConfigurationTree(context.getConfigurationTree());
            }
            if (mod instanceof EnvironmentAwareModule) {
                ((EnvironmentAwareModule)mod).setEnvironment(context.getEnvironment());
            }
            if (!(mod instanceof OptionsAwareModule)) continue;
            ((OptionsAwareModule)mod).setOptions(options);
        }
    }

    public static Iterable<Module> prepareModules(ConfigurationContext context) {
        List<Module> normalModules = context.getNormalModules();
        List<Module> overridingModules = context.getOverridingModules();
        context.lifecycle().injectorCreation(new ArrayList<Module>(normalModules), new ArrayList<Module>(overridingModules), context.getDisabledModules());
        return overridingModules.isEmpty() ? normalModules : Collections.singletonList(Modules.override(normalModules).with(overridingModules));
    }
}

