/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.module.context.debug.util.RenderUtils;

public class BindingsOverrideInjectorFactory
implements InjectorFactory {
    private static final ThreadLocal<Module[]> OVERRIDING_MODULES = new ThreadLocal();
    private static final ThreadLocal<Boolean> TOO_LATE = new ThreadLocal();
    private final Logger logger = LoggerFactory.getLogger(BindingsOverrideInjectorFactory.class);

    public BindingsOverrideInjectorFactory() {
        OVERRIDING_MODULES.remove();
        TOO_LATE.remove();
    }

    @Override
    public Injector createInjector(Stage stage, Iterable<? extends Module> modules) {
        Module[] override = OVERRIDING_MODULES.get();
        OVERRIDING_MODULES.remove();
        TOO_LATE.set(true);
        if (override != null) {
            this.printOverridingModules(override);
        }
        return Guice.createInjector((Stage)stage, override == null ? modules : Lists.newArrayList((Object[])new Module[]{Modules.override(modules).with(override)}));
    }

    public static void override(Module ... modules) {
        Preconditions.checkState((TOO_LATE.get() == null ? 1 : 0) != 0, (Object)"Too late overriding bindings registration: injector was already created");
        OVERRIDING_MODULES.set(modules);
    }

    private void printOverridingModules(Module ... modules) {
        StringBuilder builder = new StringBuilder().append("\n\n");
        for (Module module : modules) {
            builder.append('\t').append(RenderUtils.renderClassLine(module.getClass(), null)).append('\n');
        }
        this.logger.info("Overriding modules = {}", (Object)builder.toString());
    }
}

