/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.FindingDetails;
import software.amazon.awssdk.services.accessanalyzer.model.FindingDetailsListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatus;
import software.amazon.awssdk.services.accessanalyzer.model.FindingType;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingV2Response
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, GetFindingV2Response> {
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("analyzedAt").getter(GetFindingV2Response.getter(GetFindingV2Response::analyzedAt)).setter(GetFindingV2Response.setter(Builder::analyzedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetFindingV2Response.getter(GetFindingV2Response::createdAt)).setter(GetFindingV2Response.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(GetFindingV2Response.getter(GetFindingV2Response::error)).setter(GetFindingV2Response.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetFindingV2Response.getter(GetFindingV2Response::id)).setter(GetFindingV2Response.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetFindingV2Response.getter(GetFindingV2Response::nextToken)).setter(GetFindingV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(GetFindingV2Response.getter(GetFindingV2Response::resource)).setter(GetFindingV2Response.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(GetFindingV2Response.getter(GetFindingV2Response::resourceTypeAsString)).setter(GetFindingV2Response.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwnerAccount").getter(GetFindingV2Response.getter(GetFindingV2Response::resourceOwnerAccount)).setter(GetFindingV2Response.setter(Builder::resourceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetFindingV2Response.getter(GetFindingV2Response::statusAsString)).setter(GetFindingV2Response.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetFindingV2Response.getter(GetFindingV2Response::updatedAt)).setter(GetFindingV2Response.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<FindingDetails>> FINDING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingDetails").getter(GetFindingV2Response.getter(GetFindingV2Response::findingDetails)).setter(GetFindingV2Response.setter(Builder::findingDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingType").getter(GetFindingV2Response.getter(GetFindingV2Response::findingTypeAsString)).setter(GetFindingV2Response.setter(Builder::findingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZED_AT_FIELD, CREATED_AT_FIELD, ERROR_FIELD, ID_FIELD, NEXT_TOKEN_FIELD, RESOURCE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, FINDING_DETAILS_FIELD, FINDING_TYPE_FIELD));
    private final Instant analyzedAt;
    private final Instant createdAt;
    private final String error;
    private final String id;
    private final String nextToken;
    private final String resource;
    private final String resourceType;
    private final String resourceOwnerAccount;
    private final String status;
    private final Instant updatedAt;
    private final List<FindingDetails> findingDetails;
    private final String findingType;

    private GetFindingV2Response(BuilderImpl builder) {
        super(builder);
        this.analyzedAt = builder.analyzedAt;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.id = builder.id;
        this.nextToken = builder.nextToken;
        this.resource = builder.resource;
        this.resourceType = builder.resourceType;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.findingDetails = builder.findingDetails;
        this.findingType = builder.findingType;
    }

    public final Instant analyzedAt() {
        return this.analyzedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String error() {
        return this.error;
    }

    public final String id() {
        return this.id;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String resource() {
        return this.resource;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasFindingDetails() {
        return this.findingDetails != null && !(this.findingDetails instanceof SdkAutoConstructList);
    }

    public final List<FindingDetails> findingDetails() {
        return this.findingDetails;
    }

    public final FindingType findingType() {
        return FindingType.fromValue(this.findingType);
    }

    public final String findingTypeAsString() {
        return this.findingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingDetails() ? this.findingDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingV2Response)) {
            return false;
        }
        GetFindingV2Response other = (GetFindingV2Response)((Object)obj);
        return Objects.equals(this.analyzedAt(), other.analyzedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceOwnerAccount(), other.resourceOwnerAccount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasFindingDetails() == other.hasFindingDetails() && Objects.equals(this.findingDetails(), other.findingDetails()) && Objects.equals(this.findingTypeAsString(), other.findingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingV2Response").add("AnalyzedAt", (Object)this.analyzedAt()).add("CreatedAt", (Object)this.createdAt()).add("Error", (Object)this.error()).add("Id", (Object)this.id()).add("NextToken", (Object)this.nextToken()).add("Resource", (Object)this.resource()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceOwnerAccount", (Object)this.resourceOwnerAccount()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("FindingDetails", this.hasFindingDetails() ? this.findingDetails() : null).add("FindingType", (Object)this.findingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzedAt": {
                return Optional.ofNullable(clazz.cast(this.analyzedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAccount()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "findingDetails": {
                return Optional.ofNullable(clazz.cast(this.findingDetails()));
            }
            case "findingType": {
                return Optional.ofNullable(clazz.cast(this.findingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingV2Response, T> g) {
        return obj -> g.apply((GetFindingV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private Instant analyzedAt;
        private Instant createdAt;
        private String error;
        private String id;
        private String nextToken;
        private String resource;
        private String resourceType;
        private String resourceOwnerAccount;
        private String status;
        private Instant updatedAt;
        private List<FindingDetails> findingDetails = DefaultSdkAutoConstructList.getInstance();
        private String findingType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingV2Response model) {
            super(model);
            this.analyzedAt(model.analyzedAt);
            this.createdAt(model.createdAt);
            this.error(model.error);
            this.id(model.id);
            this.nextToken(model.nextToken);
            this.resource(model.resource);
            this.resourceType(model.resourceType);
            this.resourceOwnerAccount(model.resourceOwnerAccount);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
            this.findingDetails(model.findingDetails);
            this.findingType(model.findingType);
        }

        public final Instant getAnalyzedAt() {
            return this.analyzedAt;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceOwnerAccount() {
            return this.resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<FindingDetails.Builder> getFindingDetails() {
            List<FindingDetails.Builder> result = FindingDetailsListCopier.copyToBuilder(this.findingDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingDetails(Collection<FindingDetails.BuilderImpl> findingDetails) {
            this.findingDetails = FindingDetailsListCopier.copyFromBuilder(findingDetails);
        }

        @Override
        public final Builder findingDetails(Collection<FindingDetails> findingDetails) {
            this.findingDetails = FindingDetailsListCopier.copy(findingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(FindingDetails ... findingDetails) {
            this.findingDetails(Arrays.asList(findingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingDetails(Consumer<FindingDetails.Builder> ... findingDetails) {
            this.findingDetails(Stream.of(findingDetails).map(c -> (FindingDetails)((FindingDetails.Builder)FindingDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFindingType() {
            return this.findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(FindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        @Override
        public GetFindingV2Response build() {
            return new GetFindingV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingV2Response> {
        public Builder analyzedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder error(String var1);

        public Builder id(String var1);

        public Builder nextToken(String var1);

        public Builder resource(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceOwnerAccount(String var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder updatedAt(Instant var1);

        public Builder findingDetails(Collection<FindingDetails> var1);

        public Builder findingDetails(FindingDetails ... var1);

        public Builder findingDetails(Consumer<FindingDetails.Builder> ... var1);

        public Builder findingType(String var1);

        public Builder findingType(FindingType var1);
    }
}

