/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse;

public class ListAccessPreviewFindingsPublisher
implements SdkPublisher<ListAccessPreviewFindingsResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ListAccessPreviewFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPreviewFindingsPublisher(AccessAnalyzerAsyncClient client, ListAccessPreviewFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPreviewFindingsPublisher(AccessAnalyzerAsyncClient client, ListAccessPreviewFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPreviewFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPreviewFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessPreviewFinding> findings() {
        Function<ListAccessPreviewFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessPreviewFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessPreviewFindingsResponseFetcher
    implements AsyncPageFetcher<ListAccessPreviewFindingsResponse> {
        private ListAccessPreviewFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPreviewFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPreviewFindingsResponse> nextPage(ListAccessPreviewFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPreviewFindingsPublisher.this.client.listAccessPreviewFindings(ListAccessPreviewFindingsPublisher.this.firstRequest);
            }
            return ListAccessPreviewFindingsPublisher.this.client.listAccessPreviewFindings((ListAccessPreviewFindingsRequest)((Object)ListAccessPreviewFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

