/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutContactInformationRequest extends AccountRequest implements
        ToCopyableBuilder<PutContactInformationRequest.Builder, PutContactInformationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(PutContactInformationRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<ContactInformation> CONTACT_INFORMATION_FIELD = SdkField
            .<ContactInformation> builder(MarshallingType.SDK_POJO).memberName("ContactInformation")
            .getter(getter(PutContactInformationRequest::contactInformation)).setter(setter(Builder::contactInformation))
            .constructor(ContactInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactInformation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            CONTACT_INFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final ContactInformation contactInformation;

    private PutContactInformationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.contactInformation = builder.contactInformation;
    }

    /**
     * <p>
     * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify
     * with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services account of the
     * identity used to call the operation. To use this parameter, the caller must be an identity in the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >organization's management account</a> or a delegated administrator account. The specified account ID must be a
     * member account in the same organization. The organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features enabled</a>, and the organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     * access</a> enabled for the Account Management service, and optionally a <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
     * admin</a> account assigned.
     * </p>
     * <note>
     * <p>
     * The management account can't specify its own <code>AccountId</code>. It must call the operation in standalone
     * context by not including the <code>AccountId</code> parameter.
     * </p>
     * </note>
     * <p>
     * To call this operation on an account that is not a member of an organization, don't specify this parameter.
     * Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or
     * modify.
     * </p>
     * 
     * @return Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or
     *         modify with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services
     *         account of the identity used to call the operation. To use this parameter, the caller must be an identity
     *         in the <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     *         >organization's management account</a> or a delegated administrator account. The specified account ID
     *         must be a member account in the same organization. The organization must have <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >all features enabled</a>, and the organization must have <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     *         access</a> enabled for the Account Management service, and optionally a <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
     *         >delegated admin</a> account assigned.</p> <note>
     *         <p>
     *         The management account can't specify its own <code>AccountId</code>. It must call the operation in
     *         standalone context by not including the <code>AccountId</code> parameter.
     *         </p>
     *         </note>
     *         <p>
     *         To call this operation on an account that is not a member of an organization, don't specify this
     *         parameter. Instead, call the operation using an identity belonging to the account whose contacts you wish
     *         to retrieve or modify.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Contains the details of the primary contact information associated with an Amazon Web Services account.
     * </p>
     * 
     * @return Contains the details of the primary contact information associated with an Amazon Web Services account.
     */
    public final ContactInformation contactInformation() {
        return contactInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(contactInformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutContactInformationRequest)) {
            return false;
        }
        PutContactInformationRequest other = (PutContactInformationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(contactInformation(), other.contactInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutContactInformationRequest").add("AccountId", accountId())
                .add("ContactInformation", contactInformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ContactInformation":
            return Optional.ofNullable(clazz.cast(contactInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ContactInformation", CONTACT_INFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutContactInformationRequest, T> g) {
        return obj -> g.apply((PutContactInformationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccountRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutContactInformationRequest> {
        /**
         * <p>
         * Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or modify
         * with this operation. If you don't specify this parameter, it defaults to the Amazon Web Services account of
         * the identity used to call the operation. To use this parameter, the caller must be an identity in the <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account">
         * organization's management account</a> or a delegated administrator account. The specified account ID must be
         * a member account in the same organization. The organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         * >all features enabled</a>, and the organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
         * access</a> enabled for the Account Management service, and optionally a <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
         * admin</a> account assigned.
         * </p>
         * <note>
         * <p>
         * The management account can't specify its own <code>AccountId</code>. It must call the operation in standalone
         * context by not including the <code>AccountId</code> parameter.
         * </p>
         * </note>
         * <p>
         * To call this operation on an account that is not a member of an organization, don't specify this parameter.
         * Instead, call the operation using an identity belonging to the account whose contacts you wish to retrieve or
         * modify.
         * </p>
         * 
         * @param accountId
         *        Specifies the 12-digit account ID number of the Amazon Web Services account that you want to access or
         *        modify with this operation. If you don't specify this parameter, it defaults to the Amazon Web
         *        Services account of the identity used to call the operation. To use this parameter, the caller must be
         *        an identity in the <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         *        >organization's management account</a> or a delegated administrator account. The specified account ID
         *        must be a member account in the same organization. The organization must have <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         *        >all features enabled</a>, and the organization must have <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html"
         *        >trusted access</a> enabled for the Account Management service, and optionally a <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
         *        >delegated admin</a> account assigned.</p> <note>
         *        <p>
         *        The management account can't specify its own <code>AccountId</code>. It must call the operation in
         *        standalone context by not including the <code>AccountId</code> parameter.
         *        </p>
         *        </note>
         *        <p>
         *        To call this operation on an account that is not a member of an organization, don't specify this
         *        parameter. Instead, call the operation using an identity belonging to the account whose contacts you
         *        wish to retrieve or modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Contains the details of the primary contact information associated with an Amazon Web Services account.
         * </p>
         * 
         * @param contactInformation
         *        Contains the details of the primary contact information associated with an Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactInformation(ContactInformation contactInformation);

        /**
         * <p>
         * Contains the details of the primary contact information associated with an Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactInformation.Builder} avoiding the
         * need to create one manually via {@link ContactInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #contactInformation(ContactInformation)}.
         * 
         * @param contactInformation
         *        a consumer that will call methods on {@link ContactInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactInformation(ContactInformation)
         */
        default Builder contactInformation(Consumer<ContactInformation.Builder> contactInformation) {
            return contactInformation(ContactInformation.builder().applyMutation(contactInformation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccountRequest.BuilderImpl implements Builder {
        private String accountId;

        private ContactInformation contactInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutContactInformationRequest model) {
            super(model);
            accountId(model.accountId);
            contactInformation(model.contactInformation);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final ContactInformation.Builder getContactInformation() {
            return contactInformation != null ? contactInformation.toBuilder() : null;
        }

        public final void setContactInformation(ContactInformation.BuilderImpl contactInformation) {
            this.contactInformation = contactInformation != null ? contactInformation.build() : null;
        }

        @Override
        public final Builder contactInformation(ContactInformation contactInformation) {
            this.contactInformation = contactInformation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutContactInformationRequest build() {
            return new PutContactInformationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
