/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains X.509 certificate information to be placed in an issued certificate. An <code>APIPassthrough</code> or
 * <code>APICSRPassthrough</code> template variant must be selected, or else this parameter is ignored.
 * </p>
 * <p>
 * If conflicting or duplicate certificate information is supplied from other sources, Amazon Web Services Private CA
 * applies <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations">order
 * of operation rules</a> to determine what information is used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiPassthrough implements SdkPojo, Serializable, ToCopyableBuilder<ApiPassthrough.Builder, ApiPassthrough> {
    private static final SdkField<Extensions> EXTENSIONS_FIELD = SdkField.<Extensions> builder(MarshallingType.SDK_POJO)
            .memberName("Extensions").getter(getter(ApiPassthrough::extensions)).setter(setter(Builder::extensions))
            .constructor(Extensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Extensions").build()).build();

    private static final SdkField<ASN1Subject> SUBJECT_FIELD = SdkField.<ASN1Subject> builder(MarshallingType.SDK_POJO)
            .memberName("Subject").getter(getter(ApiPassthrough::subject)).setter(setter(Builder::subject))
            .constructor(ASN1Subject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSIONS_FIELD,
            SUBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Extensions extensions;

    private final ASN1Subject subject;

    private ApiPassthrough(BuilderImpl builder) {
        this.extensions = builder.extensions;
        this.subject = builder.subject;
    }

    /**
     * <p>
     * Specifies X.509 extension information for a certificate.
     * </p>
     * 
     * @return Specifies X.509 extension information for a certificate.
     */
    public final Extensions extensions() {
        return extensions;
    }

    /**
     * Returns the value of the Subject property for this object.
     * 
     * @return The value of the Subject property for this object.
     */
    public final ASN1Subject subject() {
        return subject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extensions());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiPassthrough)) {
            return false;
        }
        ApiPassthrough other = (ApiPassthrough) obj;
        return Objects.equals(extensions(), other.extensions()) && Objects.equals(subject(), other.subject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiPassthrough").add("Extensions", extensions()).add("Subject", subject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Extensions":
            return Optional.ofNullable(clazz.cast(extensions()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Extensions", EXTENSIONS_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiPassthrough, T> g) {
        return obj -> g.apply((ApiPassthrough) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiPassthrough> {
        /**
         * <p>
         * Specifies X.509 extension information for a certificate.
         * </p>
         * 
         * @param extensions
         *        Specifies X.509 extension information for a certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensions(Extensions extensions);

        /**
         * <p>
         * Specifies X.509 extension information for a certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link Extensions.Builder} avoiding the need to
         * create one manually via {@link Extensions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Extensions.Builder#build()} is called immediately and its result
         * is passed to {@link #extensions(Extensions)}.
         * 
         * @param extensions
         *        a consumer that will call methods on {@link Extensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extensions(Extensions)
         */
        default Builder extensions(Consumer<Extensions.Builder> extensions) {
            return extensions(Extensions.builder().applyMutation(extensions).build());
        }

        /**
         * Sets the value of the Subject property for this object.
         *
         * @param subject
         *        The new value for the Subject property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(ASN1Subject subject);

        /**
         * Sets the value of the Subject property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ASN1Subject.Builder} avoiding the need to
         * create one manually via {@link ASN1Subject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ASN1Subject.Builder#build()} is called immediately and its result
         * is passed to {@link #subject(ASN1Subject)}.
         * 
         * @param subject
         *        a consumer that will call methods on {@link ASN1Subject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subject(ASN1Subject)
         */
        default Builder subject(Consumer<ASN1Subject.Builder> subject) {
            return subject(ASN1Subject.builder().applyMutation(subject).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Extensions extensions;

        private ASN1Subject subject;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiPassthrough model) {
            extensions(model.extensions);
            subject(model.subject);
        }

        public final Extensions.Builder getExtensions() {
            return extensions != null ? extensions.toBuilder() : null;
        }

        public final void setExtensions(Extensions.BuilderImpl extensions) {
            this.extensions = extensions != null ? extensions.build() : null;
        }

        @Override
        public final Builder extensions(Extensions extensions) {
            this.extensions = extensions;
            return this;
        }

        public final ASN1Subject.Builder getSubject() {
            return subject != null ? subject.toBuilder() : null;
        }

        public final void setSubject(ASN1Subject.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        @Override
        public final Builder subject(ASN1Subject subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public ApiPassthrough build() {
            return new ApiPassthrough(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
