/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an ASN.1 X.400 <code>GeneralName</code> as defined in <a
 * href="https://datatracker.ietf.org/doc/html/rfc5280">RFC 5280</a>. Only one of the following naming options should be
 * provided. Providing more than one option results in an <code>InvalidArgsException</code> error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneralName implements SdkPojo, Serializable, ToCopyableBuilder<GeneralName.Builder, GeneralName> {
    private static final SdkField<OtherName> OTHER_NAME_FIELD = SdkField.<OtherName> builder(MarshallingType.SDK_POJO)
            .memberName("OtherName").getter(getter(GeneralName::otherName)).setter(setter(Builder::otherName))
            .constructor(OtherName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherName").build()).build();

    private static final SdkField<String> RFC822_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Rfc822Name").getter(getter(GeneralName::rfc822Name)).setter(setter(Builder::rfc822Name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rfc822Name").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(GeneralName::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<ASN1Subject> DIRECTORY_NAME_FIELD = SdkField.<ASN1Subject> builder(MarshallingType.SDK_POJO)
            .memberName("DirectoryName").getter(getter(GeneralName::directoryName)).setter(setter(Builder::directoryName))
            .constructor(ASN1Subject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()).build();

    private static final SdkField<EdiPartyName> EDI_PARTY_NAME_FIELD = SdkField.<EdiPartyName> builder(MarshallingType.SDK_POJO)
            .memberName("EdiPartyName").getter(getter(GeneralName::ediPartyName)).setter(setter(Builder::ediPartyName))
            .constructor(EdiPartyName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdiPartyName").build()).build();

    private static final SdkField<String> UNIFORM_RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniformResourceIdentifier").getter(getter(GeneralName::uniformResourceIdentifier))
            .setter(setter(Builder::uniformResourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniformResourceIdentifier").build())
            .build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(GeneralName::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> REGISTERED_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredId").getter(getter(GeneralName::registeredId)).setter(setter(Builder::registeredId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTHER_NAME_FIELD,
            RFC822_NAME_FIELD, DNS_NAME_FIELD, DIRECTORY_NAME_FIELD, EDI_PARTY_NAME_FIELD, UNIFORM_RESOURCE_IDENTIFIER_FIELD,
            IP_ADDRESS_FIELD, REGISTERED_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OtherName otherName;

    private final String rfc822Name;

    private final String dnsName;

    private final ASN1Subject directoryName;

    private final EdiPartyName ediPartyName;

    private final String uniformResourceIdentifier;

    private final String ipAddress;

    private final String registeredId;

    private GeneralName(BuilderImpl builder) {
        this.otherName = builder.otherName;
        this.rfc822Name = builder.rfc822Name;
        this.dnsName = builder.dnsName;
        this.directoryName = builder.directoryName;
        this.ediPartyName = builder.ediPartyName;
        this.uniformResourceIdentifier = builder.uniformResourceIdentifier;
        this.ipAddress = builder.ipAddress;
        this.registeredId = builder.registeredId;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> using an <code>OtherName</code> object.
     * </p>
     * 
     * @return Represents <code>GeneralName</code> using an <code>OtherName</code> object.
     */
    public final OtherName otherName() {
        return otherName;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> as an <a href="https://datatracker.ietf.org/doc/html/rfc822">RFC 822</a>
     * email address.
     * </p>
     * 
     * @return Represents <code>GeneralName</code> as an <a href="https://datatracker.ietf.org/doc/html/rfc822">RFC
     *         822</a> email address.
     */
    public final String rfc822Name() {
        return rfc822Name;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> as a DNS name.
     * </p>
     * 
     * @return Represents <code>GeneralName</code> as a DNS name.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * Returns the value of the DirectoryName property for this object.
     * 
     * @return The value of the DirectoryName property for this object.
     */
    public final ASN1Subject directoryName() {
        return directoryName;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.
     * </p>
     * 
     * @return Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.
     */
    public final EdiPartyName ediPartyName() {
        return ediPartyName;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> as a URI.
     * </p>
     * 
     * @return Represents <code>GeneralName</code> as a URI.
     */
    public final String uniformResourceIdentifier() {
        return uniformResourceIdentifier;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> as an IPv4 or IPv6 address.
     * </p>
     * 
     * @return Represents <code>GeneralName</code> as an IPv4 or IPv6 address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Represents <code>GeneralName</code> as an object identifier (OID).
     * </p>
     * 
     * @return Represents <code>GeneralName</code> as an object identifier (OID).
     */
    public final String registeredId() {
        return registeredId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otherName());
        hashCode = 31 * hashCode + Objects.hashCode(rfc822Name());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(ediPartyName());
        hashCode = 31 * hashCode + Objects.hashCode(uniformResourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(registeredId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneralName)) {
            return false;
        }
        GeneralName other = (GeneralName) obj;
        return Objects.equals(otherName(), other.otherName()) && Objects.equals(rfc822Name(), other.rfc822Name())
                && Objects.equals(dnsName(), other.dnsName()) && Objects.equals(directoryName(), other.directoryName())
                && Objects.equals(ediPartyName(), other.ediPartyName())
                && Objects.equals(uniformResourceIdentifier(), other.uniformResourceIdentifier())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(registeredId(), other.registeredId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneralName").add("OtherName", otherName()).add("Rfc822Name", rfc822Name())
                .add("DnsName", dnsName()).add("DirectoryName", directoryName()).add("EdiPartyName", ediPartyName())
                .add("UniformResourceIdentifier", uniformResourceIdentifier()).add("IpAddress", ipAddress())
                .add("RegisteredId", registeredId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OtherName":
            return Optional.ofNullable(clazz.cast(otherName()));
        case "Rfc822Name":
            return Optional.ofNullable(clazz.cast(rfc822Name()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "DirectoryName":
            return Optional.ofNullable(clazz.cast(directoryName()));
        case "EdiPartyName":
            return Optional.ofNullable(clazz.cast(ediPartyName()));
        case "UniformResourceIdentifier":
            return Optional.ofNullable(clazz.cast(uniformResourceIdentifier()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "RegisteredId":
            return Optional.ofNullable(clazz.cast(registeredId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OtherName", OTHER_NAME_FIELD);
        map.put("Rfc822Name", RFC822_NAME_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("DirectoryName", DIRECTORY_NAME_FIELD);
        map.put("EdiPartyName", EDI_PARTY_NAME_FIELD);
        map.put("UniformResourceIdentifier", UNIFORM_RESOURCE_IDENTIFIER_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("RegisteredId", REGISTERED_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneralName, T> g) {
        return obj -> g.apply((GeneralName) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneralName> {
        /**
         * <p>
         * Represents <code>GeneralName</code> using an <code>OtherName</code> object.
         * </p>
         * 
         * @param otherName
         *        Represents <code>GeneralName</code> using an <code>OtherName</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherName(OtherName otherName);

        /**
         * <p>
         * Represents <code>GeneralName</code> using an <code>OtherName</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link OtherName.Builder} avoiding the need to
         * create one manually via {@link OtherName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtherName.Builder#build()} is called immediately and its result
         * is passed to {@link #otherName(OtherName)}.
         * 
         * @param otherName
         *        a consumer that will call methods on {@link OtherName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otherName(OtherName)
         */
        default Builder otherName(Consumer<OtherName.Builder> otherName) {
            return otherName(OtherName.builder().applyMutation(otherName).build());
        }

        /**
         * <p>
         * Represents <code>GeneralName</code> as an <a href="https://datatracker.ietf.org/doc/html/rfc822">RFC 822</a>
         * email address.
         * </p>
         * 
         * @param rfc822Name
         *        Represents <code>GeneralName</code> as an <a href="https://datatracker.ietf.org/doc/html/rfc822">RFC
         *        822</a> email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rfc822Name(String rfc822Name);

        /**
         * <p>
         * Represents <code>GeneralName</code> as a DNS name.
         * </p>
         * 
         * @param dnsName
         *        Represents <code>GeneralName</code> as a DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * Sets the value of the DirectoryName property for this object.
         *
         * @param directoryName
         *        The new value for the DirectoryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(ASN1Subject directoryName);

        /**
         * Sets the value of the DirectoryName property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ASN1Subject.Builder} avoiding the need to
         * create one manually via {@link ASN1Subject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ASN1Subject.Builder#build()} is called immediately and its result
         * is passed to {@link #directoryName(ASN1Subject)}.
         * 
         * @param directoryName
         *        a consumer that will call methods on {@link ASN1Subject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryName(ASN1Subject)
         */
        default Builder directoryName(Consumer<ASN1Subject.Builder> directoryName) {
            return directoryName(ASN1Subject.builder().applyMutation(directoryName).build());
        }

        /**
         * <p>
         * Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.
         * </p>
         * 
         * @param ediPartyName
         *        Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ediPartyName(EdiPartyName ediPartyName);

        /**
         * <p>
         * Represents <code>GeneralName</code> as an <code>EdiPartyName</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiPartyName.Builder} avoiding the need
         * to create one manually via {@link EdiPartyName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiPartyName.Builder#build()} is called immediately and its
         * result is passed to {@link #ediPartyName(EdiPartyName)}.
         * 
         * @param ediPartyName
         *        a consumer that will call methods on {@link EdiPartyName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ediPartyName(EdiPartyName)
         */
        default Builder ediPartyName(Consumer<EdiPartyName.Builder> ediPartyName) {
            return ediPartyName(EdiPartyName.builder().applyMutation(ediPartyName).build());
        }

        /**
         * <p>
         * Represents <code>GeneralName</code> as a URI.
         * </p>
         * 
         * @param uniformResourceIdentifier
         *        Represents <code>GeneralName</code> as a URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniformResourceIdentifier(String uniformResourceIdentifier);

        /**
         * <p>
         * Represents <code>GeneralName</code> as an IPv4 or IPv6 address.
         * </p>
         * 
         * @param ipAddress
         *        Represents <code>GeneralName</code> as an IPv4 or IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Represents <code>GeneralName</code> as an object identifier (OID).
         * </p>
         * 
         * @param registeredId
         *        Represents <code>GeneralName</code> as an object identifier (OID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredId(String registeredId);
    }

    static final class BuilderImpl implements Builder {
        private OtherName otherName;

        private String rfc822Name;

        private String dnsName;

        private ASN1Subject directoryName;

        private EdiPartyName ediPartyName;

        private String uniformResourceIdentifier;

        private String ipAddress;

        private String registeredId;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneralName model) {
            otherName(model.otherName);
            rfc822Name(model.rfc822Name);
            dnsName(model.dnsName);
            directoryName(model.directoryName);
            ediPartyName(model.ediPartyName);
            uniformResourceIdentifier(model.uniformResourceIdentifier);
            ipAddress(model.ipAddress);
            registeredId(model.registeredId);
        }

        public final OtherName.Builder getOtherName() {
            return otherName != null ? otherName.toBuilder() : null;
        }

        public final void setOtherName(OtherName.BuilderImpl otherName) {
            this.otherName = otherName != null ? otherName.build() : null;
        }

        @Override
        public final Builder otherName(OtherName otherName) {
            this.otherName = otherName;
            return this;
        }

        public final String getRfc822Name() {
            return rfc822Name;
        }

        public final void setRfc822Name(String rfc822Name) {
            this.rfc822Name = rfc822Name;
        }

        @Override
        public final Builder rfc822Name(String rfc822Name) {
            this.rfc822Name = rfc822Name;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final ASN1Subject.Builder getDirectoryName() {
            return directoryName != null ? directoryName.toBuilder() : null;
        }

        public final void setDirectoryName(ASN1Subject.BuilderImpl directoryName) {
            this.directoryName = directoryName != null ? directoryName.build() : null;
        }

        @Override
        public final Builder directoryName(ASN1Subject directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final EdiPartyName.Builder getEdiPartyName() {
            return ediPartyName != null ? ediPartyName.toBuilder() : null;
        }

        public final void setEdiPartyName(EdiPartyName.BuilderImpl ediPartyName) {
            this.ediPartyName = ediPartyName != null ? ediPartyName.build() : null;
        }

        @Override
        public final Builder ediPartyName(EdiPartyName ediPartyName) {
            this.ediPartyName = ediPartyName;
            return this;
        }

        public final String getUniformResourceIdentifier() {
            return uniformResourceIdentifier;
        }

        public final void setUniformResourceIdentifier(String uniformResourceIdentifier) {
            this.uniformResourceIdentifier = uniformResourceIdentifier;
        }

        @Override
        public final Builder uniformResourceIdentifier(String uniformResourceIdentifier) {
            this.uniformResourceIdentifier = uniformResourceIdentifier;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getRegisteredId() {
            return registeredId;
        }

        public final void setRegisteredId(String registeredId) {
            this.registeredId = registeredId;
        }

        @Override
        public final Builder registeredId(String registeredId) {
            this.registeredId = registeredId;
            return this;
        }

        @Override
        public GeneralName build() {
            return new GeneralName(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
