/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeCertificateRequest extends AcmPcaRequest implements
        ToCopyableBuilder<RevokeCertificateRequest.Builder, RevokeCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn").getter(getter(RevokeCertificateRequest::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<String> CERTIFICATE_SERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateSerial").getter(getter(RevokeCertificateRequest::certificateSerial))
            .setter(setter(Builder::certificateSerial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSerial").build()).build();

    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevocationReason").getter(getter(RevokeCertificateRequest::revocationReasonAsString))
            .setter(setter(Builder::revocationReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, CERTIFICATE_SERIAL_FIELD, REVOCATION_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String certificateAuthorityArn;

    private final String certificateSerial;

    private final String revocationReason;

    private RevokeCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.certificateSerial = builder.certificateSerial;
        this.revocationReason = builder.revocationReason;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:
     * </p>
     * <p>
     * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of
     *         the form:</p>
     *         <p>
     *         <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial
     * number by calling <a
     * href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificate.html">GetCertificate</a> with
     * the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
     * <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL
     * command to list the certificate in text format and copy the hexadecimal serial number.
     * </p>
     * <p>
     * <code>openssl x509 -in <i>file_path</i> -text -noout</code>
     * </p>
     * <p>
     * You can also copy the serial number from the console or use the <a
     * href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a>
     * action in the <i>Certificate Manager API Reference</i>.
     * </p>
     * 
     * @return Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the
     *         serial number by calling <a
     *         href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificate.html"
     *         >GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your
     *         private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the
     *         following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number.
     *         </p>
     *         <p>
     *         <code>openssl x509 -in <i>file_path</i> -text -noout</code>
     *         </p>
     *         <p>
     *         You can also copy the serial number from the console or use the <a
     *         href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html"
     *         >DescribeCertificate</a> action in the <i>Certificate Manager API Reference</i>.
     */
    public final String certificateSerial() {
        return certificateSerial;
    }

    /**
     * <p>
     * Specifies why you revoked the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationReason}
     * will return {@link RevocationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationReasonAsString}.
     * </p>
     * 
     * @return Specifies why you revoked the certificate.
     * @see RevocationReason
     */
    public final RevocationReason revocationReason() {
        return RevocationReason.fromValue(revocationReason);
    }

    /**
     * <p>
     * Specifies why you revoked the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationReason}
     * will return {@link RevocationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #revocationReasonAsString}.
     * </p>
     * 
     * @return Specifies why you revoked the certificate.
     * @see RevocationReason
     */
    public final String revocationReasonAsString() {
        return revocationReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateSerial());
        hashCode = 31 * hashCode + Objects.hashCode(revocationReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeCertificateRequest)) {
            return false;
        }
        RevokeCertificateRequest other = (RevokeCertificateRequest) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(certificateSerial(), other.certificateSerial())
                && Objects.equals(revocationReasonAsString(), other.revocationReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeCertificateRequest").add("CertificateAuthorityArn", certificateAuthorityArn())
                .add("CertificateSerial", certificateSerial()).add("RevocationReason", revocationReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "CertificateSerial":
            return Optional.ofNullable(clazz.cast(certificateSerial()));
        case "RevocationReason":
            return Optional.ofNullable(clazz.cast(revocationReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("CertificateSerial", CERTIFICATE_SERIAL_FIELD);
        map.put("RevocationReason", REVOCATION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeCertificateRequest, T> g) {
        return obj -> g.apply((RevokeCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, RevokeCertificateRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the
         * form:
         * </p>
         * <p>
         * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * </p>
         * 
         * @param certificateAuthorityArn
         *        Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be
         *        of the form:</p>
         *        <p>
         *        <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the
         * serial number by calling <a
         * href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificate.html">GetCertificate</a>
         * with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
         * <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL
         * command to list the certificate in text format and copy the hexadecimal serial number.
         * </p>
         * <p>
         * <code>openssl x509 -in <i>file_path</i> -text -noout</code>
         * </p>
         * <p>
         * You can also copy the serial number from the console or use the <a
         * href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html"
         * >DescribeCertificate</a> action in the <i>Certificate Manager API Reference</i>.
         * </p>
         * 
         * @param certificateSerial
         *        Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve
         *        the serial number by calling <a
         *        href="https://docs.aws.amazon.com/privateca/latest/APIReference/API_GetCertificate.html"
         *        >GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of
         *        your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can
         *        use the following OpenSSL command to list the certificate in text format and copy the hexadecimal
         *        serial number. </p>
         *        <p>
         *        <code>openssl x509 -in <i>file_path</i> -text -noout</code>
         *        </p>
         *        <p>
         *        You can also copy the serial number from the console or use the <a
         *        href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html"
         *        >DescribeCertificate</a> action in the <i>Certificate Manager API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateSerial(String certificateSerial);

        /**
         * <p>
         * Specifies why you revoked the certificate.
         * </p>
         * 
         * @param revocationReason
         *        Specifies why you revoked the certificate.
         * @see RevocationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationReason
         */
        Builder revocationReason(String revocationReason);

        /**
         * <p>
         * Specifies why you revoked the certificate.
         * </p>
         * 
         * @param revocationReason
         *        Specifies why you revoked the certificate.
         * @see RevocationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevocationReason
         */
        Builder revocationReason(RevocationReason revocationReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private String certificateSerial;

        private String revocationReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeCertificateRequest model) {
            super(model);
            certificateAuthorityArn(model.certificateAuthorityArn);
            certificateSerial(model.certificateSerial);
            revocationReason(model.revocationReason);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getCertificateSerial() {
            return certificateSerial;
        }

        public final void setCertificateSerial(String certificateSerial) {
            this.certificateSerial = certificateSerial;
        }

        @Override
        public final Builder certificateSerial(String certificateSerial) {
            this.certificateSerial = certificateSerial;
            return this;
        }

        public final String getRevocationReason() {
            return revocationReason;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason == null ? null : revocationReason.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeCertificateRequest build() {
            return new RevokeCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
