/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConferenceProviderType {
    CHIME("CHIME"),
    BLUEJEANS("BLUEJEANS"),
    FUZE("FUZE"),
    GOOGLE_HANGOUTS("GOOGLE_HANGOUTS"),
    POLYCOM("POLYCOM"),
    RINGCENTRAL("RINGCENTRAL"),
    SKYPE_FOR_BUSINESS("SKYPE_FOR_BUSINESS"),
    WEBEX("WEBEX"),
    ZOOM("ZOOM"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConferenceProviderType> VALUE_MAP;
    private final String value;

    private ConferenceProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConferenceProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConferenceProviderType> knownValues() {
        EnumSet<ConferenceProviderType> knownValues = EnumSet.allOf(ConferenceProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConferenceProviderType.class, ConferenceProviderType::toString);
    }
}

