/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse;

public class SearchContactsIterable
implements SdkIterable<SearchContactsResponse> {
    private final AlexaForBusinessClient client;
    private final SearchContactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchContactsIterable(AlexaForBusinessClient client, SearchContactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchContactsResponseFetcher();
    }

    public Iterator<SearchContactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchContactsResponseFetcher
    implements SyncPageFetcher<SearchContactsResponse> {
        private SearchContactsResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchContactsResponse nextPage(SearchContactsResponse previousPage) {
            if (previousPage == null) {
                return SearchContactsIterable.this.client.searchContacts(SearchContactsIterable.this.firstRequest);
            }
            return SearchContactsIterable.this.client.searchContacts((SearchContactsRequest)((Object)SearchContactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

