/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SubDomainsCopier {
    static List<SubDomain> copy(Collection<? extends SubDomain> subDomainsParam) {
        List<SubDomain> list;
        if (subDomainsParam == null || subDomainsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SubDomain> modifiableList = new ArrayList<>(subDomainsParam.size());
            subDomainsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SubDomain> copyFromBuilder(Collection<? extends SubDomain.Builder> subDomainsParam) {
        List<SubDomain> list;
        if (subDomainsParam == null || subDomainsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SubDomain> modifiableList = new ArrayList<>(subDomainsParam.size());
            subDomainsParam.forEach(entry -> {
                SubDomain member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SubDomain.Builder> copyToBuilder(Collection<? extends SubDomain> subDomainsParam) {
        List<SubDomain.Builder> list;
        if (subDomainsParam == null || subDomainsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SubDomain.Builder> modifiableList = new ArrayList<>(subDomainsParam.size());
            subDomainsParam.forEach(entry -> {
                SubDomain.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
