/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Firewall configuration for a hosted Amplify application. Firewall support enables you to protect your
 * web applications with a direct integration with WAF. For more information about using WAF protections for an Amplify
 * application, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/WAF-integration.html">Firewall support
 * for hosted sites</a> in the <i>Amplify User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WafConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WafConfiguration.Builder, WafConfiguration> {
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webAclArn").getter(getter(WafConfiguration::webAclArn)).setter(setter(Builder::webAclArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAclArn").build()).build();

    private static final SdkField<String> WAF_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("wafStatus").getter(getter(WafConfiguration::wafStatusAsString)).setter(setter(Builder::wafStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wafStatus").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(WafConfiguration::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_ACL_ARN_FIELD,
            WAF_STATUS_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String webAclArn;

    private final String wafStatus;

    private final String statusReason;

    private WafConfiguration(BuilderImpl builder) {
        this.webAclArn = builder.webAclArn;
        this.wafStatus = builder.wafStatus;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
     */
    public final String webAclArn() {
        return webAclArn;
    }

    /**
     * <p>
     * The status of the process to associate or disassociate a web ACL to an Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wafStatus} will
     * return {@link WafStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wafStatusAsString}.
     * </p>
     * 
     * @return The status of the process to associate or disassociate a web ACL to an Amplify app.
     * @see WafStatus
     */
    public final WafStatus wafStatus() {
        return WafStatus.fromValue(wafStatus);
    }

    /**
     * <p>
     * The status of the process to associate or disassociate a web ACL to an Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wafStatus} will
     * return {@link WafStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wafStatusAsString}.
     * </p>
     * 
     * @return The status of the process to associate or disassociate a web ACL to an Amplify app.
     * @see WafStatus
     */
    public final String wafStatusAsString() {
        return wafStatus;
    }

    /**
     * <p>
     * The reason for the current status of the Firewall configuration.
     * </p>
     * 
     * @return The reason for the current status of the Firewall configuration.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(wafStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WafConfiguration)) {
            return false;
        }
        WafConfiguration other = (WafConfiguration) obj;
        return Objects.equals(webAclArn(), other.webAclArn()) && Objects.equals(wafStatusAsString(), other.wafStatusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WafConfiguration").add("WebAclArn", webAclArn()).add("WafStatus", wafStatusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webAclArn":
            return Optional.ofNullable(clazz.cast(webAclArn()));
        case "wafStatus":
            return Optional.ofNullable(clazz.cast(wafStatusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("webAclArn", WEB_ACL_ARN_FIELD);
        map.put("wafStatus", WAF_STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WafConfiguration, T> g) {
        return obj -> g.apply((WafConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WafConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
         * </p>
         * 
         * @param webAclArn
         *        The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclArn(String webAclArn);

        /**
         * <p>
         * The status of the process to associate or disassociate a web ACL to an Amplify app.
         * </p>
         * 
         * @param wafStatus
         *        The status of the process to associate or disassociate a web ACL to an Amplify app.
         * @see WafStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WafStatus
         */
        Builder wafStatus(String wafStatus);

        /**
         * <p>
         * The status of the process to associate or disassociate a web ACL to an Amplify app.
         * </p>
         * 
         * @param wafStatus
         *        The status of the process to associate or disassociate a web ACL to an Amplify app.
         * @see WafStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WafStatus
         */
        Builder wafStatus(WafStatus wafStatus);

        /**
         * <p>
         * The reason for the current status of the Firewall configuration.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current status of the Firewall configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String webAclArn;

        private String wafStatus;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(WafConfiguration model) {
            webAclArn(model.webAclArn);
            wafStatus(model.wafStatus);
            statusReason(model.statusReason);
        }

        public final String getWebAclArn() {
            return webAclArn;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        public final String getWafStatus() {
            return wafStatus;
        }

        public final void setWafStatus(String wafStatus) {
            this.wafStatus = wafStatus;
        }

        @Override
        public final Builder wafStatus(String wafStatus) {
            this.wafStatus = wafStatus;
            return this;
        }

        @Override
        public final Builder wafStatus(WafStatus wafStatus) {
            this.wafStatus(wafStatus == null ? null : wafStatus.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public WafConfiguration build() {
            return new WafConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
