/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication settings for accessing provisioned data models in your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendAPIAppSyncAuthSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendAPIAppSyncAuthSettings.Builder, BackendAPIAppSyncAuthSettings> {
    private static final SdkField<String> COGNITO_USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CognitoUserPoolId").getter(getter(BackendAPIAppSyncAuthSettings::cognitoUserPoolId))
            .setter(setter(Builder::cognitoUserPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoUserPoolId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(BackendAPIAppSyncAuthSettings::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> EXPIRATION_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ExpirationTime").getter(getter(BackendAPIAppSyncAuthSettings::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()).build();

    private static final SdkField<String> OPEN_ID_AUTH_TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenIDAuthTTL").getter(getter(BackendAPIAppSyncAuthSettings::openIDAuthTTL))
            .setter(setter(Builder::openIDAuthTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDAuthTTL").build()).build();

    private static final SdkField<String> OPEN_ID_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenIDClientId").getter(getter(BackendAPIAppSyncAuthSettings::openIDClientId))
            .setter(setter(Builder::openIDClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDClientId").build()).build();

    private static final SdkField<String> OPEN_ID_IAT_TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenIDIatTTL").getter(getter(BackendAPIAppSyncAuthSettings::openIDIatTTL))
            .setter(setter(Builder::openIDIatTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDIatTTL").build()).build();

    private static final SdkField<String> OPEN_ID_ISSUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenIDIssueURL").getter(getter(BackendAPIAppSyncAuthSettings::openIDIssueURL))
            .setter(setter(Builder::openIDIssueURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDIssueURL").build()).build();

    private static final SdkField<String> OPEN_ID_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpenIDProviderName").getter(getter(BackendAPIAppSyncAuthSettings::openIDProviderName))
            .setter(setter(Builder::openIDProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDProviderName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_USER_POOL_ID_FIELD,
            DESCRIPTION_FIELD, EXPIRATION_TIME_FIELD, OPEN_ID_AUTH_TTL_FIELD, OPEN_ID_CLIENT_ID_FIELD, OPEN_ID_IAT_TTL_FIELD,
            OPEN_ID_ISSUE_URL_FIELD, OPEN_ID_PROVIDER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cognitoUserPoolId;

    private final String description;

    private final Double expirationTime;

    private final String openIDAuthTTL;

    private final String openIDClientId;

    private final String openIDIatTTL;

    private final String openIDIssueURL;

    private final String openIDProviderName;

    private BackendAPIAppSyncAuthSettings(BuilderImpl builder) {
        this.cognitoUserPoolId = builder.cognitoUserPoolId;
        this.description = builder.description;
        this.expirationTime = builder.expirationTime;
        this.openIDAuthTTL = builder.openIDAuthTTL;
        this.openIDClientId = builder.openIDClientId;
        this.openIDIatTTL = builder.openIDIatTTL;
        this.openIDIssueURL = builder.openIDIssueURL;
        this.openIDProviderName = builder.openIDProviderName;
    }

    /**
     * <p>
     * The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data
     * models.
     * </p>
     * 
     * @return The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your
     *         data models.
     */
    public final String cognitoUserPoolId() {
        return cognitoUserPoolId;
    }

    /**
     * <p>
     * The API key description for API_KEY, if it was used as an authentication mechanism to access your data models.
     * </p>
     * 
     * @return The API key description for API_KEY, if it was used as an authentication mechanism to access your data
     *         models.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data
     * models.
     * </p>
     * 
     * @return The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your
     *         data models.
     */
    public final Double expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The expiry time for the OpenID authentication mechanism.
     * </p>
     * 
     * @return The expiry time for the OpenID authentication mechanism.
     */
    public final String openIDAuthTTL() {
        return openIDAuthTTL;
    }

    /**
     * <p>
     * The clientID for openID, if openID was used as an authentication setting to access your data models.
     * </p>
     * 
     * @return The clientID for openID, if openID was used as an authentication setting to access your data models.
     */
    public final String openIDClientId() {
        return openIDClientId;
    }

    /**
     * <p>
     * The expiry time for the OpenID authentication mechanism.
     * </p>
     * 
     * @return The expiry time for the OpenID authentication mechanism.
     */
    public final String openIDIatTTL() {
        return openIDIatTTL;
    }

    /**
     * <p>
     * The openID issuer URL, if openID was used as an authentication setting to access your data models.
     * </p>
     * 
     * @return The openID issuer URL, if openID was used as an authentication setting to access your data models.
     */
    public final String openIDIssueURL() {
        return openIDIssueURL;
    }

    /**
     * <p>
     * The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.
     * </p>
     * 
     * @return The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.
     */
    public final String openIDProviderName() {
        return openIDProviderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cognitoUserPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(openIDAuthTTL());
        hashCode = 31 * hashCode + Objects.hashCode(openIDClientId());
        hashCode = 31 * hashCode + Objects.hashCode(openIDIatTTL());
        hashCode = 31 * hashCode + Objects.hashCode(openIDIssueURL());
        hashCode = 31 * hashCode + Objects.hashCode(openIDProviderName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendAPIAppSyncAuthSettings)) {
            return false;
        }
        BackendAPIAppSyncAuthSettings other = (BackendAPIAppSyncAuthSettings) obj;
        return Objects.equals(cognitoUserPoolId(), other.cognitoUserPoolId())
                && Objects.equals(description(), other.description()) && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(openIDAuthTTL(), other.openIDAuthTTL())
                && Objects.equals(openIDClientId(), other.openIDClientId())
                && Objects.equals(openIDIatTTL(), other.openIDIatTTL())
                && Objects.equals(openIDIssueURL(), other.openIDIssueURL())
                && Objects.equals(openIDProviderName(), other.openIDProviderName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendAPIAppSyncAuthSettings").add("CognitoUserPoolId", cognitoUserPoolId())
                .add("Description", description()).add("ExpirationTime", expirationTime()).add("OpenIDAuthTTL", openIDAuthTTL())
                .add("OpenIDClientId", openIDClientId()).add("OpenIDIatTTL", openIDIatTTL())
                .add("OpenIDIssueURL", openIDIssueURL()).add("OpenIDProviderName", openIDProviderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CognitoUserPoolId":
            return Optional.ofNullable(clazz.cast(cognitoUserPoolId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "OpenIDAuthTTL":
            return Optional.ofNullable(clazz.cast(openIDAuthTTL()));
        case "OpenIDClientId":
            return Optional.ofNullable(clazz.cast(openIDClientId()));
        case "OpenIDIatTTL":
            return Optional.ofNullable(clazz.cast(openIDIatTTL()));
        case "OpenIDIssueURL":
            return Optional.ofNullable(clazz.cast(openIDIssueURL()));
        case "OpenIDProviderName":
            return Optional.ofNullable(clazz.cast(openIDProviderName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cognitoUserPoolId", COGNITO_USER_POOL_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("openIDAuthTTL", OPEN_ID_AUTH_TTL_FIELD);
        map.put("openIDClientId", OPEN_ID_CLIENT_ID_FIELD);
        map.put("openIDIatTTL", OPEN_ID_IAT_TTL_FIELD);
        map.put("openIDIssueURL", OPEN_ID_ISSUE_URL_FIELD);
        map.put("openIDProviderName", OPEN_ID_PROVIDER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackendAPIAppSyncAuthSettings, T> g) {
        return obj -> g.apply((BackendAPIAppSyncAuthSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendAPIAppSyncAuthSettings> {
        /**
         * <p>
         * The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data
         * models.
         * </p>
         * 
         * @param cognitoUserPoolId
         *        The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access
         *        your data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoUserPoolId(String cognitoUserPoolId);

        /**
         * <p>
         * The API key description for API_KEY, if it was used as an authentication mechanism to access your data
         * models.
         * </p>
         * 
         * @param description
         *        The API key description for API_KEY, if it was used as an authentication mechanism to access your data
         *        models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data
         * models.
         * </p>
         * 
         * @param expirationTime
         *        The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your
         *        data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Double expirationTime);

        /**
         * <p>
         * The expiry time for the OpenID authentication mechanism.
         * </p>
         * 
         * @param openIDAuthTTL
         *        The expiry time for the OpenID authentication mechanism.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDAuthTTL(String openIDAuthTTL);

        /**
         * <p>
         * The clientID for openID, if openID was used as an authentication setting to access your data models.
         * </p>
         * 
         * @param openIDClientId
         *        The clientID for openID, if openID was used as an authentication setting to access your data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDClientId(String openIDClientId);

        /**
         * <p>
         * The expiry time for the OpenID authentication mechanism.
         * </p>
         * 
         * @param openIDIatTTL
         *        The expiry time for the OpenID authentication mechanism.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDIatTTL(String openIDIatTTL);

        /**
         * <p>
         * The openID issuer URL, if openID was used as an authentication setting to access your data models.
         * </p>
         * 
         * @param openIDIssueURL
         *        The openID issuer URL, if openID was used as an authentication setting to access your data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDIssueURL(String openIDIssueURL);

        /**
         * <p>
         * The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.
         * </p>
         * 
         * @param openIDProviderName
         *        The OpenID provider name, if OpenID was used as an authentication mechanism to access your data
         *        models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDProviderName(String openIDProviderName);
    }

    static final class BuilderImpl implements Builder {
        private String cognitoUserPoolId;

        private String description;

        private Double expirationTime;

        private String openIDAuthTTL;

        private String openIDClientId;

        private String openIDIatTTL;

        private String openIDIssueURL;

        private String openIDProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendAPIAppSyncAuthSettings model) {
            cognitoUserPoolId(model.cognitoUserPoolId);
            description(model.description);
            expirationTime(model.expirationTime);
            openIDAuthTTL(model.openIDAuthTTL);
            openIDClientId(model.openIDClientId);
            openIDIatTTL(model.openIDIatTTL);
            openIDIssueURL(model.openIDIssueURL);
            openIDProviderName(model.openIDProviderName);
        }

        public final String getCognitoUserPoolId() {
            return cognitoUserPoolId;
        }

        public final void setCognitoUserPoolId(String cognitoUserPoolId) {
            this.cognitoUserPoolId = cognitoUserPoolId;
        }

        @Override
        public final Builder cognitoUserPoolId(String cognitoUserPoolId) {
            this.cognitoUserPoolId = cognitoUserPoolId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Double expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Double expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getOpenIDAuthTTL() {
            return openIDAuthTTL;
        }

        public final void setOpenIDAuthTTL(String openIDAuthTTL) {
            this.openIDAuthTTL = openIDAuthTTL;
        }

        @Override
        public final Builder openIDAuthTTL(String openIDAuthTTL) {
            this.openIDAuthTTL = openIDAuthTTL;
            return this;
        }

        public final String getOpenIDClientId() {
            return openIDClientId;
        }

        public final void setOpenIDClientId(String openIDClientId) {
            this.openIDClientId = openIDClientId;
        }

        @Override
        public final Builder openIDClientId(String openIDClientId) {
            this.openIDClientId = openIDClientId;
            return this;
        }

        public final String getOpenIDIatTTL() {
            return openIDIatTTL;
        }

        public final void setOpenIDIatTTL(String openIDIatTTL) {
            this.openIDIatTTL = openIDIatTTL;
        }

        @Override
        public final Builder openIDIatTTL(String openIDIatTTL) {
            this.openIDIatTTL = openIDIatTTL;
            return this;
        }

        public final String getOpenIDIssueURL() {
            return openIDIssueURL;
        }

        public final void setOpenIDIssueURL(String openIDIssueURL) {
            this.openIDIssueURL = openIDIssueURL;
        }

        @Override
        public final Builder openIDIssueURL(String openIDIssueURL) {
            this.openIDIssueURL = openIDIssueURL;
            return this;
        }

        public final String getOpenIDProviderName() {
            return openIDProviderName;
        }

        public final void setOpenIDProviderName(String openIDProviderName) {
            this.openIDProviderName = openIDProviderName;
        }

        @Override
        public final Builder openIDProviderName(String openIDProviderName) {
            this.openIDProviderName = openIDProviderName;
            return this;
        }

        @Override
        public BackendAPIAppSyncAuthSettings build() {
            return new BackendAPIAppSyncAuthSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
