/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ListOfS3BucketInfoCopier {
    static List<S3BucketInfo> copy(Collection<? extends S3BucketInfo> listOfS3BucketInfoParam) {
        List<S3BucketInfo> list;
        if (listOfS3BucketInfoParam == null || listOfS3BucketInfoParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3BucketInfo> modifiableList = new ArrayList<>(listOfS3BucketInfoParam.size());
            listOfS3BucketInfoParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3BucketInfo> copyFromBuilder(Collection<? extends S3BucketInfo.Builder> listOfS3BucketInfoParam) {
        List<S3BucketInfo> list;
        if (listOfS3BucketInfoParam == null || listOfS3BucketInfoParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3BucketInfo> modifiableList = new ArrayList<>(listOfS3BucketInfoParam.size());
            listOfS3BucketInfoParam.forEach(entry -> {
                S3BucketInfo member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3BucketInfo.Builder> copyToBuilder(Collection<? extends S3BucketInfo> listOfS3BucketInfoParam) {
        List<S3BucketInfo.Builder> list;
        if (listOfS3BucketInfoParam == null || listOfS3BucketInfoParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3BucketInfo.Builder> modifiableList = new ArrayList<>(listOfS3BucketInfoParam.size());
            listOfS3BucketInfoParam.forEach(entry -> {
                S3BucketInfo.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
