/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelFlowExecutionsResponse extends AppflowResponse implements
        ToCopyableBuilder<CancelFlowExecutionsResponse.Builder, CancelFlowExecutionsResponse> {
    private static final SdkField<List<String>> INVALID_EXECUTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("invalidExecutions")
            .getter(getter(CancelFlowExecutionsResponse::invalidExecutions))
            .setter(setter(Builder::invalidExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_EXECUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> invalidExecutions;

    private CancelFlowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.invalidExecutions = builder.invalidExecutions;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvalidExecutions() {
        return invalidExecutions != null && !(invalidExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of runs that Amazon AppFlow couldn't cancel. These runs might be ineligible for canceling because they
     * haven't started yet or have already completed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidExecutions} method.
     * </p>
     * 
     * @return The IDs of runs that Amazon AppFlow couldn't cancel. These runs might be ineligible for canceling because
     *         they haven't started yet or have already completed.
     */
    public final List<String> invalidExecutions() {
        return invalidExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInvalidExecutions() ? invalidExecutions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelFlowExecutionsResponse)) {
            return false;
        }
        CancelFlowExecutionsResponse other = (CancelFlowExecutionsResponse) obj;
        return hasInvalidExecutions() == other.hasInvalidExecutions()
                && Objects.equals(invalidExecutions(), other.invalidExecutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelFlowExecutionsResponse")
                .add("InvalidExecutions", hasInvalidExecutions() ? invalidExecutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invalidExecutions":
            return Optional.ofNullable(clazz.cast(invalidExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invalidExecutions", INVALID_EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelFlowExecutionsResponse, T> g) {
        return obj -> g.apply((CancelFlowExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelFlowExecutionsResponse> {
        /**
         * <p>
         * The IDs of runs that Amazon AppFlow couldn't cancel. These runs might be ineligible for canceling because
         * they haven't started yet or have already completed.
         * </p>
         * 
         * @param invalidExecutions
         *        The IDs of runs that Amazon AppFlow couldn't cancel. These runs might be ineligible for canceling
         *        because they haven't started yet or have already completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidExecutions(Collection<String> invalidExecutions);

        /**
         * <p>
         * The IDs of runs that Amazon AppFlow couldn't cancel. These runs might be ineligible for canceling because
         * they haven't started yet or have already completed.
         * </p>
         * 
         * @param invalidExecutions
         *        The IDs of runs that Amazon AppFlow couldn't cancel. These runs might be ineligible for canceling
         *        because they haven't started yet or have already completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidExecutions(String... invalidExecutions);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private List<String> invalidExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelFlowExecutionsResponse model) {
            super(model);
            invalidExecutions(model.invalidExecutions);
        }

        public final Collection<String> getInvalidExecutions() {
            if (invalidExecutions instanceof SdkAutoConstructList) {
                return null;
            }
            return invalidExecutions;
        }

        public final void setInvalidExecutions(Collection<String> invalidExecutions) {
            this.invalidExecutions = ExecutionIdsCopier.copy(invalidExecutions);
        }

        @Override
        public final Builder invalidExecutions(Collection<String> invalidExecutions) {
            this.invalidExecutions = ExecutionIdsCopier.copy(invalidExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidExecutions(String... invalidExecutions) {
            invalidExecutions(Arrays.asList(invalidExecutions));
            return this;
        }

        @Override
        public CancelFlowExecutionsResponse build() {
            return new CancelFlowExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
