/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure to specify connector-specific metadata such as <code>oAuthScopes</code>, <code>supportedRegions</code>,
 * <code>privateLinkServiceUrl</code>, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorMetadata.Builder, ConnectorMetadata> {
    private static final SdkField<AmplitudeMetadata> AMPLITUDE_FIELD = SdkField
            .<AmplitudeMetadata> builder(MarshallingType.SDK_POJO).memberName("Amplitude")
            .getter(getter(ConnectorMetadata::amplitude)).setter(setter(Builder::amplitude))
            .constructor(AmplitudeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amplitude").build()).build();

    private static final SdkField<DatadogMetadata> DATADOG_FIELD = SdkField.<DatadogMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Datadog").getter(getter(ConnectorMetadata::datadog)).setter(setter(Builder::datadog))
            .constructor(DatadogMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datadog").build()).build();

    private static final SdkField<DynatraceMetadata> DYNATRACE_FIELD = SdkField
            .<DynatraceMetadata> builder(MarshallingType.SDK_POJO).memberName("Dynatrace")
            .getter(getter(ConnectorMetadata::dynatrace)).setter(setter(Builder::dynatrace))
            .constructor(DynatraceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dynatrace").build()).build();

    private static final SdkField<GoogleAnalyticsMetadata> GOOGLE_ANALYTICS_FIELD = SdkField
            .<GoogleAnalyticsMetadata> builder(MarshallingType.SDK_POJO).memberName("GoogleAnalytics")
            .getter(getter(ConnectorMetadata::googleAnalytics)).setter(setter(Builder::googleAnalytics))
            .constructor(GoogleAnalyticsMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoogleAnalytics").build()).build();

    private static final SdkField<InforNexusMetadata> INFOR_NEXUS_FIELD = SdkField
            .<InforNexusMetadata> builder(MarshallingType.SDK_POJO).memberName("InforNexus")
            .getter(getter(ConnectorMetadata::inforNexus)).setter(setter(Builder::inforNexus))
            .constructor(InforNexusMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InforNexus").build()).build();

    private static final SdkField<MarketoMetadata> MARKETO_FIELD = SdkField.<MarketoMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Marketo").getter(getter(ConnectorMetadata::marketo)).setter(setter(Builder::marketo))
            .constructor(MarketoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<RedshiftMetadata> REDSHIFT_FIELD = SdkField
            .<RedshiftMetadata> builder(MarshallingType.SDK_POJO).memberName("Redshift")
            .getter(getter(ConnectorMetadata::redshift)).setter(setter(Builder::redshift)).constructor(RedshiftMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build()).build();

    private static final SdkField<S3Metadata> S3_FIELD = SdkField.<S3Metadata> builder(MarshallingType.SDK_POJO).memberName("S3")
            .getter(getter(ConnectorMetadata::s3)).setter(setter(Builder::s3)).constructor(S3Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<SalesforceMetadata> SALESFORCE_FIELD = SdkField
            .<SalesforceMetadata> builder(MarshallingType.SDK_POJO).memberName("Salesforce")
            .getter(getter(ConnectorMetadata::salesforce)).setter(setter(Builder::salesforce))
            .constructor(SalesforceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<ServiceNowMetadata> SERVICE_NOW_FIELD = SdkField
            .<ServiceNowMetadata> builder(MarshallingType.SDK_POJO).memberName("ServiceNow")
            .getter(getter(ConnectorMetadata::serviceNow)).setter(setter(Builder::serviceNow))
            .constructor(ServiceNowMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<SingularMetadata> SINGULAR_FIELD = SdkField
            .<SingularMetadata> builder(MarshallingType.SDK_POJO).memberName("Singular")
            .getter(getter(ConnectorMetadata::singular)).setter(setter(Builder::singular)).constructor(SingularMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Singular").build()).build();

    private static final SdkField<SlackMetadata> SLACK_FIELD = SdkField.<SlackMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Slack").getter(getter(ConnectorMetadata::slack)).setter(setter(Builder::slack))
            .constructor(SlackMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slack").build()).build();

    private static final SdkField<SnowflakeMetadata> SNOWFLAKE_FIELD = SdkField
            .<SnowflakeMetadata> builder(MarshallingType.SDK_POJO).memberName("Snowflake")
            .getter(getter(ConnectorMetadata::snowflake)).setter(setter(Builder::snowflake))
            .constructor(SnowflakeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snowflake").build()).build();

    private static final SdkField<TrendmicroMetadata> TRENDMICRO_FIELD = SdkField
            .<TrendmicroMetadata> builder(MarshallingType.SDK_POJO).memberName("Trendmicro")
            .getter(getter(ConnectorMetadata::trendmicro)).setter(setter(Builder::trendmicro))
            .constructor(TrendmicroMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trendmicro").build()).build();

    private static final SdkField<VeevaMetadata> VEEVA_FIELD = SdkField.<VeevaMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Veeva").getter(getter(ConnectorMetadata::veeva)).setter(setter(Builder::veeva))
            .constructor(VeevaMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Veeva").build()).build();

    private static final SdkField<ZendeskMetadata> ZENDESK_FIELD = SdkField.<ZendeskMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Zendesk").getter(getter(ConnectorMetadata::zendesk)).setter(setter(Builder::zendesk))
            .constructor(ZendeskMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final SdkField<EventBridgeMetadata> EVENT_BRIDGE_FIELD = SdkField
            .<EventBridgeMetadata> builder(MarshallingType.SDK_POJO).memberName("EventBridge")
            .getter(getter(ConnectorMetadata::eventBridge)).setter(setter(Builder::eventBridge))
            .constructor(EventBridgeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridge").build()).build();

    private static final SdkField<UpsolverMetadata> UPSOLVER_FIELD = SdkField
            .<UpsolverMetadata> builder(MarshallingType.SDK_POJO).memberName("Upsolver")
            .getter(getter(ConnectorMetadata::upsolver)).setter(setter(Builder::upsolver)).constructor(UpsolverMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsolver").build()).build();

    private static final SdkField<CustomerProfilesMetadata> CUSTOMER_PROFILES_FIELD = SdkField
            .<CustomerProfilesMetadata> builder(MarshallingType.SDK_POJO).memberName("CustomerProfiles")
            .getter(getter(ConnectorMetadata::customerProfiles)).setter(setter(Builder::customerProfiles))
            .constructor(CustomerProfilesMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProfiles").build()).build();

    private static final SdkField<HoneycodeMetadata> HONEYCODE_FIELD = SdkField
            .<HoneycodeMetadata> builder(MarshallingType.SDK_POJO).memberName("Honeycode")
            .getter(getter(ConnectorMetadata::honeycode)).setter(setter(Builder::honeycode))
            .constructor(HoneycodeMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Honeycode").build()).build();

    private static final SdkField<SAPODataMetadata> SAPO_DATA_FIELD = SdkField
            .<SAPODataMetadata> builder(MarshallingType.SDK_POJO).memberName("SAPOData")
            .getter(getter(ConnectorMetadata::sapoData)).setter(setter(Builder::sapoData)).constructor(SAPODataMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAPOData").build()).build();

    private static final SdkField<PardotMetadata> PARDOT_FIELD = SdkField.<PardotMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Pardot").getter(getter(ConnectorMetadata::pardot)).setter(setter(Builder::pardot))
            .constructor(PardotMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pardot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLITUDE_FIELD,
            DATADOG_FIELD, DYNATRACE_FIELD, GOOGLE_ANALYTICS_FIELD, INFOR_NEXUS_FIELD, MARKETO_FIELD, REDSHIFT_FIELD, S3_FIELD,
            SALESFORCE_FIELD, SERVICE_NOW_FIELD, SINGULAR_FIELD, SLACK_FIELD, SNOWFLAKE_FIELD, TRENDMICRO_FIELD, VEEVA_FIELD,
            ZENDESK_FIELD, EVENT_BRIDGE_FIELD, UPSOLVER_FIELD, CUSTOMER_PROFILES_FIELD, HONEYCODE_FIELD, SAPO_DATA_FIELD,
            PARDOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AmplitudeMetadata amplitude;

    private final DatadogMetadata datadog;

    private final DynatraceMetadata dynatrace;

    private final GoogleAnalyticsMetadata googleAnalytics;

    private final InforNexusMetadata inforNexus;

    private final MarketoMetadata marketo;

    private final RedshiftMetadata redshift;

    private final S3Metadata s3;

    private final SalesforceMetadata salesforce;

    private final ServiceNowMetadata serviceNow;

    private final SingularMetadata singular;

    private final SlackMetadata slack;

    private final SnowflakeMetadata snowflake;

    private final TrendmicroMetadata trendmicro;

    private final VeevaMetadata veeva;

    private final ZendeskMetadata zendesk;

    private final EventBridgeMetadata eventBridge;

    private final UpsolverMetadata upsolver;

    private final CustomerProfilesMetadata customerProfiles;

    private final HoneycodeMetadata honeycode;

    private final SAPODataMetadata sapoData;

    private final PardotMetadata pardot;

    private ConnectorMetadata(BuilderImpl builder) {
        this.amplitude = builder.amplitude;
        this.datadog = builder.datadog;
        this.dynatrace = builder.dynatrace;
        this.googleAnalytics = builder.googleAnalytics;
        this.inforNexus = builder.inforNexus;
        this.marketo = builder.marketo;
        this.redshift = builder.redshift;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.singular = builder.singular;
        this.slack = builder.slack;
        this.snowflake = builder.snowflake;
        this.trendmicro = builder.trendmicro;
        this.veeva = builder.veeva;
        this.zendesk = builder.zendesk;
        this.eventBridge = builder.eventBridge;
        this.upsolver = builder.upsolver;
        this.customerProfiles = builder.customerProfiles;
        this.honeycode = builder.honeycode;
        this.sapoData = builder.sapoData;
        this.pardot = builder.pardot;
    }

    /**
     * <p>
     * The connector metadata specific to Amplitude.
     * </p>
     * 
     * @return The connector metadata specific to Amplitude.
     */
    public final AmplitudeMetadata amplitude() {
        return amplitude;
    }

    /**
     * <p>
     * The connector metadata specific to Datadog.
     * </p>
     * 
     * @return The connector metadata specific to Datadog.
     */
    public final DatadogMetadata datadog() {
        return datadog;
    }

    /**
     * <p>
     * The connector metadata specific to Dynatrace.
     * </p>
     * 
     * @return The connector metadata specific to Dynatrace.
     */
    public final DynatraceMetadata dynatrace() {
        return dynatrace;
    }

    /**
     * <p>
     * The connector metadata specific to Google Analytics.
     * </p>
     * 
     * @return The connector metadata specific to Google Analytics.
     */
    public final GoogleAnalyticsMetadata googleAnalytics() {
        return googleAnalytics;
    }

    /**
     * <p>
     * The connector metadata specific to Infor Nexus.
     * </p>
     * 
     * @return The connector metadata specific to Infor Nexus.
     */
    public final InforNexusMetadata inforNexus() {
        return inforNexus;
    }

    /**
     * <p>
     * The connector metadata specific to Marketo.
     * </p>
     * 
     * @return The connector metadata specific to Marketo.
     */
    public final MarketoMetadata marketo() {
        return marketo;
    }

    /**
     * <p>
     * The connector metadata specific to Amazon Redshift.
     * </p>
     * 
     * @return The connector metadata specific to Amazon Redshift.
     */
    public final RedshiftMetadata redshift() {
        return redshift;
    }

    /**
     * <p>
     * The connector metadata specific to Amazon S3.
     * </p>
     * 
     * @return The connector metadata specific to Amazon S3.
     */
    public final S3Metadata s3() {
        return s3;
    }

    /**
     * <p>
     * The connector metadata specific to Salesforce.
     * </p>
     * 
     * @return The connector metadata specific to Salesforce.
     */
    public final SalesforceMetadata salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * The connector metadata specific to ServiceNow.
     * </p>
     * 
     * @return The connector metadata specific to ServiceNow.
     */
    public final ServiceNowMetadata serviceNow() {
        return serviceNow;
    }

    /**
     * <p>
     * The connector metadata specific to Singular.
     * </p>
     * 
     * @return The connector metadata specific to Singular.
     */
    public final SingularMetadata singular() {
        return singular;
    }

    /**
     * <p>
     * The connector metadata specific to Slack.
     * </p>
     * 
     * @return The connector metadata specific to Slack.
     */
    public final SlackMetadata slack() {
        return slack;
    }

    /**
     * <p>
     * The connector metadata specific to Snowflake.
     * </p>
     * 
     * @return The connector metadata specific to Snowflake.
     */
    public final SnowflakeMetadata snowflake() {
        return snowflake;
    }

    /**
     * <p>
     * The connector metadata specific to Trend Micro.
     * </p>
     * 
     * @return The connector metadata specific to Trend Micro.
     */
    public final TrendmicroMetadata trendmicro() {
        return trendmicro;
    }

    /**
     * <p>
     * The connector metadata specific to Veeva.
     * </p>
     * 
     * @return The connector metadata specific to Veeva.
     */
    public final VeevaMetadata veeva() {
        return veeva;
    }

    /**
     * <p>
     * The connector metadata specific to Zendesk.
     * </p>
     * 
     * @return The connector metadata specific to Zendesk.
     */
    public final ZendeskMetadata zendesk() {
        return zendesk;
    }

    /**
     * <p>
     * The connector metadata specific to Amazon EventBridge.
     * </p>
     * 
     * @return The connector metadata specific to Amazon EventBridge.
     */
    public final EventBridgeMetadata eventBridge() {
        return eventBridge;
    }

    /**
     * <p>
     * The connector metadata specific to Upsolver.
     * </p>
     * 
     * @return The connector metadata specific to Upsolver.
     */
    public final UpsolverMetadata upsolver() {
        return upsolver;
    }

    /**
     * <p>
     * The connector metadata specific to Amazon Connect Customer Profiles.
     * </p>
     * 
     * @return The connector metadata specific to Amazon Connect Customer Profiles.
     */
    public final CustomerProfilesMetadata customerProfiles() {
        return customerProfiles;
    }

    /**
     * <p>
     * The connector metadata specific to Amazon Honeycode.
     * </p>
     * 
     * @return The connector metadata specific to Amazon Honeycode.
     */
    public final HoneycodeMetadata honeycode() {
        return honeycode;
    }

    /**
     * Returns the value of the SAPOData property for this object.
     * 
     * @return The value of the SAPOData property for this object.
     */
    public final SAPODataMetadata sapoData() {
        return sapoData;
    }

    /**
     * <p>
     * The connector metadata specific to Salesforce Pardot.
     * </p>
     * 
     * @return The connector metadata specific to Salesforce Pardot.
     */
    public final PardotMetadata pardot() {
        return pardot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amplitude());
        hashCode = 31 * hashCode + Objects.hashCode(datadog());
        hashCode = 31 * hashCode + Objects.hashCode(dynatrace());
        hashCode = 31 * hashCode + Objects.hashCode(googleAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(inforNexus());
        hashCode = 31 * hashCode + Objects.hashCode(marketo());
        hashCode = 31 * hashCode + Objects.hashCode(redshift());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(singular());
        hashCode = 31 * hashCode + Objects.hashCode(slack());
        hashCode = 31 * hashCode + Objects.hashCode(snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(trendmicro());
        hashCode = 31 * hashCode + Objects.hashCode(veeva());
        hashCode = 31 * hashCode + Objects.hashCode(zendesk());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridge());
        hashCode = 31 * hashCode + Objects.hashCode(upsolver());
        hashCode = 31 * hashCode + Objects.hashCode(customerProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(honeycode());
        hashCode = 31 * hashCode + Objects.hashCode(sapoData());
        hashCode = 31 * hashCode + Objects.hashCode(pardot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorMetadata)) {
            return false;
        }
        ConnectorMetadata other = (ConnectorMetadata) obj;
        return Objects.equals(amplitude(), other.amplitude()) && Objects.equals(datadog(), other.datadog())
                && Objects.equals(dynatrace(), other.dynatrace()) && Objects.equals(googleAnalytics(), other.googleAnalytics())
                && Objects.equals(inforNexus(), other.inforNexus()) && Objects.equals(marketo(), other.marketo())
                && Objects.equals(redshift(), other.redshift()) && Objects.equals(s3(), other.s3())
                && Objects.equals(salesforce(), other.salesforce()) && Objects.equals(serviceNow(), other.serviceNow())
                && Objects.equals(singular(), other.singular()) && Objects.equals(slack(), other.slack())
                && Objects.equals(snowflake(), other.snowflake()) && Objects.equals(trendmicro(), other.trendmicro())
                && Objects.equals(veeva(), other.veeva()) && Objects.equals(zendesk(), other.zendesk())
                && Objects.equals(eventBridge(), other.eventBridge()) && Objects.equals(upsolver(), other.upsolver())
                && Objects.equals(customerProfiles(), other.customerProfiles()) && Objects.equals(honeycode(), other.honeycode())
                && Objects.equals(sapoData(), other.sapoData()) && Objects.equals(pardot(), other.pardot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorMetadata").add("Amplitude", amplitude()).add("Datadog", datadog())
                .add("Dynatrace", dynatrace()).add("GoogleAnalytics", googleAnalytics()).add("InforNexus", inforNexus())
                .add("Marketo", marketo()).add("Redshift", redshift()).add("S3", s3()).add("Salesforce", salesforce())
                .add("ServiceNow", serviceNow()).add("Singular", singular()).add("Slack", slack()).add("Snowflake", snowflake())
                .add("Trendmicro", trendmicro()).add("Veeva", veeva()).add("Zendesk", zendesk())
                .add("EventBridge", eventBridge()).add("Upsolver", upsolver()).add("CustomerProfiles", customerProfiles())
                .add("Honeycode", honeycode()).add("SAPOData", sapoData()).add("Pardot", pardot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amplitude":
            return Optional.ofNullable(clazz.cast(amplitude()));
        case "Datadog":
            return Optional.ofNullable(clazz.cast(datadog()));
        case "Dynatrace":
            return Optional.ofNullable(clazz.cast(dynatrace()));
        case "GoogleAnalytics":
            return Optional.ofNullable(clazz.cast(googleAnalytics()));
        case "InforNexus":
            return Optional.ofNullable(clazz.cast(inforNexus()));
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketo()));
        case "Redshift":
            return Optional.ofNullable(clazz.cast(redshift()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNow()));
        case "Singular":
            return Optional.ofNullable(clazz.cast(singular()));
        case "Slack":
            return Optional.ofNullable(clazz.cast(slack()));
        case "Snowflake":
            return Optional.ofNullable(clazz.cast(snowflake()));
        case "Trendmicro":
            return Optional.ofNullable(clazz.cast(trendmicro()));
        case "Veeva":
            return Optional.ofNullable(clazz.cast(veeva()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendesk()));
        case "EventBridge":
            return Optional.ofNullable(clazz.cast(eventBridge()));
        case "Upsolver":
            return Optional.ofNullable(clazz.cast(upsolver()));
        case "CustomerProfiles":
            return Optional.ofNullable(clazz.cast(customerProfiles()));
        case "Honeycode":
            return Optional.ofNullable(clazz.cast(honeycode()));
        case "SAPOData":
            return Optional.ofNullable(clazz.cast(sapoData()));
        case "Pardot":
            return Optional.ofNullable(clazz.cast(pardot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Amplitude", AMPLITUDE_FIELD);
        map.put("Datadog", DATADOG_FIELD);
        map.put("Dynatrace", DYNATRACE_FIELD);
        map.put("GoogleAnalytics", GOOGLE_ANALYTICS_FIELD);
        map.put("InforNexus", INFOR_NEXUS_FIELD);
        map.put("Marketo", MARKETO_FIELD);
        map.put("Redshift", REDSHIFT_FIELD);
        map.put("S3", S3_FIELD);
        map.put("Salesforce", SALESFORCE_FIELD);
        map.put("ServiceNow", SERVICE_NOW_FIELD);
        map.put("Singular", SINGULAR_FIELD);
        map.put("Slack", SLACK_FIELD);
        map.put("Snowflake", SNOWFLAKE_FIELD);
        map.put("Trendmicro", TRENDMICRO_FIELD);
        map.put("Veeva", VEEVA_FIELD);
        map.put("Zendesk", ZENDESK_FIELD);
        map.put("EventBridge", EVENT_BRIDGE_FIELD);
        map.put("Upsolver", UPSOLVER_FIELD);
        map.put("CustomerProfiles", CUSTOMER_PROFILES_FIELD);
        map.put("Honeycode", HONEYCODE_FIELD);
        map.put("SAPOData", SAPO_DATA_FIELD);
        map.put("Pardot", PARDOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorMetadata, T> g) {
        return obj -> g.apply((ConnectorMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorMetadata> {
        /**
         * <p>
         * The connector metadata specific to Amplitude.
         * </p>
         * 
         * @param amplitude
         *        The connector metadata specific to Amplitude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amplitude(AmplitudeMetadata amplitude);

        /**
         * <p>
         * The connector metadata specific to Amplitude.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmplitudeMetadata.Builder} avoiding the
         * need to create one manually via {@link AmplitudeMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmplitudeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #amplitude(AmplitudeMetadata)}.
         * 
         * @param amplitude
         *        a consumer that will call methods on {@link AmplitudeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amplitude(AmplitudeMetadata)
         */
        default Builder amplitude(Consumer<AmplitudeMetadata.Builder> amplitude) {
            return amplitude(AmplitudeMetadata.builder().applyMutation(amplitude).build());
        }

        /**
         * <p>
         * The connector metadata specific to Datadog.
         * </p>
         * 
         * @param datadog
         *        The connector metadata specific to Datadog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datadog(DatadogMetadata datadog);

        /**
         * <p>
         * The connector metadata specific to Datadog.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatadogMetadata.Builder} avoiding the
         * need to create one manually via {@link DatadogMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatadogMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #datadog(DatadogMetadata)}.
         * 
         * @param datadog
         *        a consumer that will call methods on {@link DatadogMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datadog(DatadogMetadata)
         */
        default Builder datadog(Consumer<DatadogMetadata.Builder> datadog) {
            return datadog(DatadogMetadata.builder().applyMutation(datadog).build());
        }

        /**
         * <p>
         * The connector metadata specific to Dynatrace.
         * </p>
         * 
         * @param dynatrace
         *        The connector metadata specific to Dynatrace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynatrace(DynatraceMetadata dynatrace);

        /**
         * <p>
         * The connector metadata specific to Dynatrace.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynatraceMetadata.Builder} avoiding the
         * need to create one manually via {@link DynatraceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynatraceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #dynatrace(DynatraceMetadata)}.
         * 
         * @param dynatrace
         *        a consumer that will call methods on {@link DynatraceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynatrace(DynatraceMetadata)
         */
        default Builder dynatrace(Consumer<DynatraceMetadata.Builder> dynatrace) {
            return dynatrace(DynatraceMetadata.builder().applyMutation(dynatrace).build());
        }

        /**
         * <p>
         * The connector metadata specific to Google Analytics.
         * </p>
         * 
         * @param googleAnalytics
         *        The connector metadata specific to Google Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder googleAnalytics(GoogleAnalyticsMetadata googleAnalytics);

        /**
         * <p>
         * The connector metadata specific to Google Analytics.
         * </p>
         * This is a convenience method that creates an instance of the {@link GoogleAnalyticsMetadata.Builder} avoiding
         * the need to create one manually via {@link GoogleAnalyticsMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GoogleAnalyticsMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #googleAnalytics(GoogleAnalyticsMetadata)}.
         * 
         * @param googleAnalytics
         *        a consumer that will call methods on {@link GoogleAnalyticsMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #googleAnalytics(GoogleAnalyticsMetadata)
         */
        default Builder googleAnalytics(Consumer<GoogleAnalyticsMetadata.Builder> googleAnalytics) {
            return googleAnalytics(GoogleAnalyticsMetadata.builder().applyMutation(googleAnalytics).build());
        }

        /**
         * <p>
         * The connector metadata specific to Infor Nexus.
         * </p>
         * 
         * @param inforNexus
         *        The connector metadata specific to Infor Nexus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inforNexus(InforNexusMetadata inforNexus);

        /**
         * <p>
         * The connector metadata specific to Infor Nexus.
         * </p>
         * This is a convenience method that creates an instance of the {@link InforNexusMetadata.Builder} avoiding the
         * need to create one manually via {@link InforNexusMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InforNexusMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #inforNexus(InforNexusMetadata)}.
         * 
         * @param inforNexus
         *        a consumer that will call methods on {@link InforNexusMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inforNexus(InforNexusMetadata)
         */
        default Builder inforNexus(Consumer<InforNexusMetadata.Builder> inforNexus) {
            return inforNexus(InforNexusMetadata.builder().applyMutation(inforNexus).build());
        }

        /**
         * <p>
         * The connector metadata specific to Marketo.
         * </p>
         * 
         * @param marketo
         *        The connector metadata specific to Marketo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketo(MarketoMetadata marketo);

        /**
         * <p>
         * The connector metadata specific to Marketo.
         * </p>
         * This is a convenience method that creates an instance of the {@link MarketoMetadata.Builder} avoiding the
         * need to create one manually via {@link MarketoMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MarketoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #marketo(MarketoMetadata)}.
         * 
         * @param marketo
         *        a consumer that will call methods on {@link MarketoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketo(MarketoMetadata)
         */
        default Builder marketo(Consumer<MarketoMetadata.Builder> marketo) {
            return marketo(MarketoMetadata.builder().applyMutation(marketo).build());
        }

        /**
         * <p>
         * The connector metadata specific to Amazon Redshift.
         * </p>
         * 
         * @param redshift
         *        The connector metadata specific to Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshift(RedshiftMetadata redshift);

        /**
         * <p>
         * The connector metadata specific to Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftMetadata.Builder} avoiding the
         * need to create one manually via {@link RedshiftMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #redshift(RedshiftMetadata)}.
         * 
         * @param redshift
         *        a consumer that will call methods on {@link RedshiftMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshift(RedshiftMetadata)
         */
        default Builder redshift(Consumer<RedshiftMetadata.Builder> redshift) {
            return redshift(RedshiftMetadata.builder().applyMutation(redshift).build());
        }

        /**
         * <p>
         * The connector metadata specific to Amazon S3.
         * </p>
         * 
         * @param s3
         *        The connector metadata specific to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Metadata s3);

        /**
         * <p>
         * The connector metadata specific to Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Metadata.Builder} avoiding the need to
         * create one manually via {@link S3Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Metadata.Builder#build()} is called immediately and its result
         * is passed to {@link #s3(S3Metadata)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Metadata)
         */
        default Builder s3(Consumer<S3Metadata.Builder> s3) {
            return s3(S3Metadata.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * The connector metadata specific to Salesforce.
         * </p>
         * 
         * @param salesforce
         *        The connector metadata specific to Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceMetadata salesforce);

        /**
         * <p>
         * The connector metadata specific to Salesforce.
         * </p>
         * This is a convenience method that creates an instance of the {@link SalesforceMetadata.Builder} avoiding the
         * need to create one manually via {@link SalesforceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #salesforce(SalesforceMetadata)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceMetadata)
         */
        default Builder salesforce(Consumer<SalesforceMetadata.Builder> salesforce) {
            return salesforce(SalesforceMetadata.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * The connector metadata specific to ServiceNow.
         * </p>
         * 
         * @param serviceNow
         *        The connector metadata specific to ServiceNow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNow(ServiceNowMetadata serviceNow);

        /**
         * <p>
         * The connector metadata specific to ServiceNow.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceNowMetadata.Builder} avoiding the
         * need to create one manually via {@link ServiceNowMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceNowMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceNow(ServiceNowMetadata)}.
         * 
         * @param serviceNow
         *        a consumer that will call methods on {@link ServiceNowMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNow(ServiceNowMetadata)
         */
        default Builder serviceNow(Consumer<ServiceNowMetadata.Builder> serviceNow) {
            return serviceNow(ServiceNowMetadata.builder().applyMutation(serviceNow).build());
        }

        /**
         * <p>
         * The connector metadata specific to Singular.
         * </p>
         * 
         * @param singular
         *        The connector metadata specific to Singular.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singular(SingularMetadata singular);

        /**
         * <p>
         * The connector metadata specific to Singular.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingularMetadata.Builder} avoiding the
         * need to create one manually via {@link SingularMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingularMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #singular(SingularMetadata)}.
         * 
         * @param singular
         *        a consumer that will call methods on {@link SingularMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singular(SingularMetadata)
         */
        default Builder singular(Consumer<SingularMetadata.Builder> singular) {
            return singular(SingularMetadata.builder().applyMutation(singular).build());
        }

        /**
         * <p>
         * The connector metadata specific to Slack.
         * </p>
         * 
         * @param slack
         *        The connector metadata specific to Slack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slack(SlackMetadata slack);

        /**
         * <p>
         * The connector metadata specific to Slack.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlackMetadata.Builder} avoiding the need
         * to create one manually via {@link SlackMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlackMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #slack(SlackMetadata)}.
         * 
         * @param slack
         *        a consumer that will call methods on {@link SlackMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slack(SlackMetadata)
         */
        default Builder slack(Consumer<SlackMetadata.Builder> slack) {
            return slack(SlackMetadata.builder().applyMutation(slack).build());
        }

        /**
         * <p>
         * The connector metadata specific to Snowflake.
         * </p>
         * 
         * @param snowflake
         *        The connector metadata specific to Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflake(SnowflakeMetadata snowflake);

        /**
         * <p>
         * The connector metadata specific to Snowflake.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeMetadata.Builder} avoiding the
         * need to create one manually via {@link SnowflakeMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #snowflake(SnowflakeMetadata)}.
         * 
         * @param snowflake
         *        a consumer that will call methods on {@link SnowflakeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflake(SnowflakeMetadata)
         */
        default Builder snowflake(Consumer<SnowflakeMetadata.Builder> snowflake) {
            return snowflake(SnowflakeMetadata.builder().applyMutation(snowflake).build());
        }

        /**
         * <p>
         * The connector metadata specific to Trend Micro.
         * </p>
         * 
         * @param trendmicro
         *        The connector metadata specific to Trend Micro.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trendmicro(TrendmicroMetadata trendmicro);

        /**
         * <p>
         * The connector metadata specific to Trend Micro.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrendmicroMetadata.Builder} avoiding the
         * need to create one manually via {@link TrendmicroMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrendmicroMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #trendmicro(TrendmicroMetadata)}.
         * 
         * @param trendmicro
         *        a consumer that will call methods on {@link TrendmicroMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trendmicro(TrendmicroMetadata)
         */
        default Builder trendmicro(Consumer<TrendmicroMetadata.Builder> trendmicro) {
            return trendmicro(TrendmicroMetadata.builder().applyMutation(trendmicro).build());
        }

        /**
         * <p>
         * The connector metadata specific to Veeva.
         * </p>
         * 
         * @param veeva
         *        The connector metadata specific to Veeva.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder veeva(VeevaMetadata veeva);

        /**
         * <p>
         * The connector metadata specific to Veeva.
         * </p>
         * This is a convenience method that creates an instance of the {@link VeevaMetadata.Builder} avoiding the need
         * to create one manually via {@link VeevaMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VeevaMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #veeva(VeevaMetadata)}.
         * 
         * @param veeva
         *        a consumer that will call methods on {@link VeevaMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #veeva(VeevaMetadata)
         */
        default Builder veeva(Consumer<VeevaMetadata.Builder> veeva) {
            return veeva(VeevaMetadata.builder().applyMutation(veeva).build());
        }

        /**
         * <p>
         * The connector metadata specific to Zendesk.
         * </p>
         * 
         * @param zendesk
         *        The connector metadata specific to Zendesk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zendesk(ZendeskMetadata zendesk);

        /**
         * <p>
         * The connector metadata specific to Zendesk.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZendeskMetadata.Builder} avoiding the
         * need to create one manually via {@link ZendeskMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZendeskMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #zendesk(ZendeskMetadata)}.
         * 
         * @param zendesk
         *        a consumer that will call methods on {@link ZendeskMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zendesk(ZendeskMetadata)
         */
        default Builder zendesk(Consumer<ZendeskMetadata.Builder> zendesk) {
            return zendesk(ZendeskMetadata.builder().applyMutation(zendesk).build());
        }

        /**
         * <p>
         * The connector metadata specific to Amazon EventBridge.
         * </p>
         * 
         * @param eventBridge
         *        The connector metadata specific to Amazon EventBridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridge(EventBridgeMetadata eventBridge);

        /**
         * <p>
         * The connector metadata specific to Amazon EventBridge.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBridgeMetadata.Builder} avoiding the
         * need to create one manually via {@link EventBridgeMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBridgeMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #eventBridge(EventBridgeMetadata)}.
         * 
         * @param eventBridge
         *        a consumer that will call methods on {@link EventBridgeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridge(EventBridgeMetadata)
         */
        default Builder eventBridge(Consumer<EventBridgeMetadata.Builder> eventBridge) {
            return eventBridge(EventBridgeMetadata.builder().applyMutation(eventBridge).build());
        }

        /**
         * <p>
         * The connector metadata specific to Upsolver.
         * </p>
         * 
         * @param upsolver
         *        The connector metadata specific to Upsolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upsolver(UpsolverMetadata upsolver);

        /**
         * <p>
         * The connector metadata specific to Upsolver.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpsolverMetadata.Builder} avoiding the
         * need to create one manually via {@link UpsolverMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpsolverMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #upsolver(UpsolverMetadata)}.
         * 
         * @param upsolver
         *        a consumer that will call methods on {@link UpsolverMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upsolver(UpsolverMetadata)
         */
        default Builder upsolver(Consumer<UpsolverMetadata.Builder> upsolver) {
            return upsolver(UpsolverMetadata.builder().applyMutation(upsolver).build());
        }

        /**
         * <p>
         * The connector metadata specific to Amazon Connect Customer Profiles.
         * </p>
         * 
         * @param customerProfiles
         *        The connector metadata specific to Amazon Connect Customer Profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfiles(CustomerProfilesMetadata customerProfiles);

        /**
         * <p>
         * The connector metadata specific to Amazon Connect Customer Profiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerProfilesMetadata.Builder}
         * avoiding the need to create one manually via {@link CustomerProfilesMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerProfilesMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #customerProfiles(CustomerProfilesMetadata)}.
         * 
         * @param customerProfiles
         *        a consumer that will call methods on {@link CustomerProfilesMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerProfiles(CustomerProfilesMetadata)
         */
        default Builder customerProfiles(Consumer<CustomerProfilesMetadata.Builder> customerProfiles) {
            return customerProfiles(CustomerProfilesMetadata.builder().applyMutation(customerProfiles).build());
        }

        /**
         * <p>
         * The connector metadata specific to Amazon Honeycode.
         * </p>
         * 
         * @param honeycode
         *        The connector metadata specific to Amazon Honeycode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honeycode(HoneycodeMetadata honeycode);

        /**
         * <p>
         * The connector metadata specific to Amazon Honeycode.
         * </p>
         * This is a convenience method that creates an instance of the {@link HoneycodeMetadata.Builder} avoiding the
         * need to create one manually via {@link HoneycodeMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HoneycodeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #honeycode(HoneycodeMetadata)}.
         * 
         * @param honeycode
         *        a consumer that will call methods on {@link HoneycodeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #honeycode(HoneycodeMetadata)
         */
        default Builder honeycode(Consumer<HoneycodeMetadata.Builder> honeycode) {
            return honeycode(HoneycodeMetadata.builder().applyMutation(honeycode).build());
        }

        /**
         * Sets the value of the SAPOData property for this object.
         *
         * @param sapoData
         *        The new value for the SAPOData property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sapoData(SAPODataMetadata sapoData);

        /**
         * Sets the value of the SAPOData property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SAPODataMetadata.Builder} avoiding the
         * need to create one manually via {@link SAPODataMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SAPODataMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #sapoData(SAPODataMetadata)}.
         * 
         * @param sapoData
         *        a consumer that will call methods on {@link SAPODataMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sapoData(SAPODataMetadata)
         */
        default Builder sapoData(Consumer<SAPODataMetadata.Builder> sapoData) {
            return sapoData(SAPODataMetadata.builder().applyMutation(sapoData).build());
        }

        /**
         * <p>
         * The connector metadata specific to Salesforce Pardot.
         * </p>
         * 
         * @param pardot
         *        The connector metadata specific to Salesforce Pardot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pardot(PardotMetadata pardot);

        /**
         * <p>
         * The connector metadata specific to Salesforce Pardot.
         * </p>
         * This is a convenience method that creates an instance of the {@link PardotMetadata.Builder} avoiding the need
         * to create one manually via {@link PardotMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PardotMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #pardot(PardotMetadata)}.
         * 
         * @param pardot
         *        a consumer that will call methods on {@link PardotMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pardot(PardotMetadata)
         */
        default Builder pardot(Consumer<PardotMetadata.Builder> pardot) {
            return pardot(PardotMetadata.builder().applyMutation(pardot).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmplitudeMetadata amplitude;

        private DatadogMetadata datadog;

        private DynatraceMetadata dynatrace;

        private GoogleAnalyticsMetadata googleAnalytics;

        private InforNexusMetadata inforNexus;

        private MarketoMetadata marketo;

        private RedshiftMetadata redshift;

        private S3Metadata s3;

        private SalesforceMetadata salesforce;

        private ServiceNowMetadata serviceNow;

        private SingularMetadata singular;

        private SlackMetadata slack;

        private SnowflakeMetadata snowflake;

        private TrendmicroMetadata trendmicro;

        private VeevaMetadata veeva;

        private ZendeskMetadata zendesk;

        private EventBridgeMetadata eventBridge;

        private UpsolverMetadata upsolver;

        private CustomerProfilesMetadata customerProfiles;

        private HoneycodeMetadata honeycode;

        private SAPODataMetadata sapoData;

        private PardotMetadata pardot;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorMetadata model) {
            amplitude(model.amplitude);
            datadog(model.datadog);
            dynatrace(model.dynatrace);
            googleAnalytics(model.googleAnalytics);
            inforNexus(model.inforNexus);
            marketo(model.marketo);
            redshift(model.redshift);
            s3(model.s3);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            singular(model.singular);
            slack(model.slack);
            snowflake(model.snowflake);
            trendmicro(model.trendmicro);
            veeva(model.veeva);
            zendesk(model.zendesk);
            eventBridge(model.eventBridge);
            upsolver(model.upsolver);
            customerProfiles(model.customerProfiles);
            honeycode(model.honeycode);
            sapoData(model.sapoData);
            pardot(model.pardot);
        }

        public final AmplitudeMetadata.Builder getAmplitude() {
            return amplitude != null ? amplitude.toBuilder() : null;
        }

        public final void setAmplitude(AmplitudeMetadata.BuilderImpl amplitude) {
            this.amplitude = amplitude != null ? amplitude.build() : null;
        }

        @Override
        public final Builder amplitude(AmplitudeMetadata amplitude) {
            this.amplitude = amplitude;
            return this;
        }

        public final DatadogMetadata.Builder getDatadog() {
            return datadog != null ? datadog.toBuilder() : null;
        }

        public final void setDatadog(DatadogMetadata.BuilderImpl datadog) {
            this.datadog = datadog != null ? datadog.build() : null;
        }

        @Override
        public final Builder datadog(DatadogMetadata datadog) {
            this.datadog = datadog;
            return this;
        }

        public final DynatraceMetadata.Builder getDynatrace() {
            return dynatrace != null ? dynatrace.toBuilder() : null;
        }

        public final void setDynatrace(DynatraceMetadata.BuilderImpl dynatrace) {
            this.dynatrace = dynatrace != null ? dynatrace.build() : null;
        }

        @Override
        public final Builder dynatrace(DynatraceMetadata dynatrace) {
            this.dynatrace = dynatrace;
            return this;
        }

        public final GoogleAnalyticsMetadata.Builder getGoogleAnalytics() {
            return googleAnalytics != null ? googleAnalytics.toBuilder() : null;
        }

        public final void setGoogleAnalytics(GoogleAnalyticsMetadata.BuilderImpl googleAnalytics) {
            this.googleAnalytics = googleAnalytics != null ? googleAnalytics.build() : null;
        }

        @Override
        public final Builder googleAnalytics(GoogleAnalyticsMetadata googleAnalytics) {
            this.googleAnalytics = googleAnalytics;
            return this;
        }

        public final InforNexusMetadata.Builder getInforNexus() {
            return inforNexus != null ? inforNexus.toBuilder() : null;
        }

        public final void setInforNexus(InforNexusMetadata.BuilderImpl inforNexus) {
            this.inforNexus = inforNexus != null ? inforNexus.build() : null;
        }

        @Override
        public final Builder inforNexus(InforNexusMetadata inforNexus) {
            this.inforNexus = inforNexus;
            return this;
        }

        public final MarketoMetadata.Builder getMarketo() {
            return marketo != null ? marketo.toBuilder() : null;
        }

        public final void setMarketo(MarketoMetadata.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        @Override
        public final Builder marketo(MarketoMetadata marketo) {
            this.marketo = marketo;
            return this;
        }

        public final RedshiftMetadata.Builder getRedshift() {
            return redshift != null ? redshift.toBuilder() : null;
        }

        public final void setRedshift(RedshiftMetadata.BuilderImpl redshift) {
            this.redshift = redshift != null ? redshift.build() : null;
        }

        @Override
        public final Builder redshift(RedshiftMetadata redshift) {
            this.redshift = redshift;
            return this;
        }

        public final S3Metadata.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3Metadata.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3Metadata s3) {
            this.s3 = s3;
            return this;
        }

        public final SalesforceMetadata.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        public final void setSalesforce(SalesforceMetadata.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        @Override
        public final Builder salesforce(SalesforceMetadata salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final ServiceNowMetadata.Builder getServiceNow() {
            return serviceNow != null ? serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowMetadata.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowMetadata serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final SingularMetadata.Builder getSingular() {
            return singular != null ? singular.toBuilder() : null;
        }

        public final void setSingular(SingularMetadata.BuilderImpl singular) {
            this.singular = singular != null ? singular.build() : null;
        }

        @Override
        public final Builder singular(SingularMetadata singular) {
            this.singular = singular;
            return this;
        }

        public final SlackMetadata.Builder getSlack() {
            return slack != null ? slack.toBuilder() : null;
        }

        public final void setSlack(SlackMetadata.BuilderImpl slack) {
            this.slack = slack != null ? slack.build() : null;
        }

        @Override
        public final Builder slack(SlackMetadata slack) {
            this.slack = slack;
            return this;
        }

        public final SnowflakeMetadata.Builder getSnowflake() {
            return snowflake != null ? snowflake.toBuilder() : null;
        }

        public final void setSnowflake(SnowflakeMetadata.BuilderImpl snowflake) {
            this.snowflake = snowflake != null ? snowflake.build() : null;
        }

        @Override
        public final Builder snowflake(SnowflakeMetadata snowflake) {
            this.snowflake = snowflake;
            return this;
        }

        public final TrendmicroMetadata.Builder getTrendmicro() {
            return trendmicro != null ? trendmicro.toBuilder() : null;
        }

        public final void setTrendmicro(TrendmicroMetadata.BuilderImpl trendmicro) {
            this.trendmicro = trendmicro != null ? trendmicro.build() : null;
        }

        @Override
        public final Builder trendmicro(TrendmicroMetadata trendmicro) {
            this.trendmicro = trendmicro;
            return this;
        }

        public final VeevaMetadata.Builder getVeeva() {
            return veeva != null ? veeva.toBuilder() : null;
        }

        public final void setVeeva(VeevaMetadata.BuilderImpl veeva) {
            this.veeva = veeva != null ? veeva.build() : null;
        }

        @Override
        public final Builder veeva(VeevaMetadata veeva) {
            this.veeva = veeva;
            return this;
        }

        public final ZendeskMetadata.Builder getZendesk() {
            return zendesk != null ? zendesk.toBuilder() : null;
        }

        public final void setZendesk(ZendeskMetadata.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public final Builder zendesk(ZendeskMetadata zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public final EventBridgeMetadata.Builder getEventBridge() {
            return eventBridge != null ? eventBridge.toBuilder() : null;
        }

        public final void setEventBridge(EventBridgeMetadata.BuilderImpl eventBridge) {
            this.eventBridge = eventBridge != null ? eventBridge.build() : null;
        }

        @Override
        public final Builder eventBridge(EventBridgeMetadata eventBridge) {
            this.eventBridge = eventBridge;
            return this;
        }

        public final UpsolverMetadata.Builder getUpsolver() {
            return upsolver != null ? upsolver.toBuilder() : null;
        }

        public final void setUpsolver(UpsolverMetadata.BuilderImpl upsolver) {
            this.upsolver = upsolver != null ? upsolver.build() : null;
        }

        @Override
        public final Builder upsolver(UpsolverMetadata upsolver) {
            this.upsolver = upsolver;
            return this;
        }

        public final CustomerProfilesMetadata.Builder getCustomerProfiles() {
            return customerProfiles != null ? customerProfiles.toBuilder() : null;
        }

        public final void setCustomerProfiles(CustomerProfilesMetadata.BuilderImpl customerProfiles) {
            this.customerProfiles = customerProfiles != null ? customerProfiles.build() : null;
        }

        @Override
        public final Builder customerProfiles(CustomerProfilesMetadata customerProfiles) {
            this.customerProfiles = customerProfiles;
            return this;
        }

        public final HoneycodeMetadata.Builder getHoneycode() {
            return honeycode != null ? honeycode.toBuilder() : null;
        }

        public final void setHoneycode(HoneycodeMetadata.BuilderImpl honeycode) {
            this.honeycode = honeycode != null ? honeycode.build() : null;
        }

        @Override
        public final Builder honeycode(HoneycodeMetadata honeycode) {
            this.honeycode = honeycode;
            return this;
        }

        public final SAPODataMetadata.Builder getSapoData() {
            return sapoData != null ? sapoData.toBuilder() : null;
        }

        public final void setSapoData(SAPODataMetadata.BuilderImpl sapoData) {
            this.sapoData = sapoData != null ? sapoData.build() : null;
        }

        @Override
        public final Builder sapoData(SAPODataMetadata sapoData) {
            this.sapoData = sapoData;
            return this;
        }

        public final PardotMetadata.Builder getPardot() {
            return pardot != null ? pardot.toBuilder() : null;
        }

        public final void setPardot(PardotMetadata.BuilderImpl pardot) {
            this.pardot = pardot != null ? pardot.build() : null;
        }

        @Override
        public final Builder pardot(PardotMetadata pardot) {
            this.pardot = pardot;
            return this;
        }

        @Override
        public ConnectorMetadata build() {
            return new ConnectorMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
