/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of the connector being registered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorProvisioningConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorProvisioningConfig.Builder, ConnectorProvisioningConfig> {
    private static final SdkField<LambdaConnectorProvisioningConfig> LAMBDA_FIELD = SdkField
            .<LambdaConnectorProvisioningConfig> builder(MarshallingType.SDK_POJO).memberName("lambda")
            .getter(getter(ConnectorProvisioningConfig::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaConnectorProvisioningConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LambdaConnectorProvisioningConfig lambda;

    private ConnectorProvisioningConfig(BuilderImpl builder) {
        this.lambda = builder.lambda;
    }

    /**
     * <p>
     * Contains information about the configuration of the lambda which is being registered as the connector.
     * </p>
     * 
     * @return Contains information about the configuration of the lambda which is being registered as the connector.
     */
    public final LambdaConnectorProvisioningConfig lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorProvisioningConfig)) {
            return false;
        }
        ConnectorProvisioningConfig other = (ConnectorProvisioningConfig) obj;
        return Objects.equals(lambda(), other.lambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorProvisioningConfig").add("Lambda", lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorProvisioningConfig, T> g) {
        return obj -> g.apply((ConnectorProvisioningConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorProvisioningConfig> {
        /**
         * <p>
         * Contains information about the configuration of the lambda which is being registered as the connector.
         * </p>
         * 
         * @param lambda
         *        Contains information about the configuration of the lambda which is being registered as the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaConnectorProvisioningConfig lambda);

        /**
         * <p>
         * Contains information about the configuration of the lambda which is being registered as the connector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaConnectorProvisioningConfig.Builder} avoiding the need to create one manually via
         * {@link LambdaConnectorProvisioningConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaConnectorProvisioningConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #lambda(LambdaConnectorProvisioningConfig)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaConnectorProvisioningConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaConnectorProvisioningConfig)
         */
        default Builder lambda(Consumer<LambdaConnectorProvisioningConfig.Builder> lambda) {
            return lambda(LambdaConnectorProvisioningConfig.builder().applyMutation(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaConnectorProvisioningConfig lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorProvisioningConfig model) {
            lambda(model.lambda);
        }

        public final LambdaConnectorProvisioningConfig.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaConnectorProvisioningConfig.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaConnectorProvisioningConfig lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public ConnectorProvisioningConfig build() {
            return new ConnectorProvisioningConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
