/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the connector runtime settings that are required for flow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorRuntimeSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorRuntimeSetting.Builder, ConnectorRuntimeSetting> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(ConnectorRuntimeSetting::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(ConnectorRuntimeSetting::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<Boolean> IS_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRequired").getter(getter(ConnectorRuntimeSetting::isRequired)).setter(setter(Builder::isRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequired").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(ConnectorRuntimeSetting::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConnectorRuntimeSetting::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(ConnectorRuntimeSetting::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<List<String>> CONNECTOR_SUPPLIED_VALUE_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("connectorSuppliedValueOptions")
            .getter(getter(ConnectorRuntimeSetting::connectorSuppliedValueOptions))
            .setter(setter(Builder::connectorSuppliedValueOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSuppliedValueOptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DATA_TYPE_FIELD,
            IS_REQUIRED_FIELD, LABEL_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, CONNECTOR_SUPPLIED_VALUE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String dataType;

    private final Boolean isRequired;

    private final String label;

    private final String description;

    private final String scope;

    private final List<String> connectorSuppliedValueOptions;

    private ConnectorRuntimeSetting(BuilderImpl builder) {
        this.key = builder.key;
        this.dataType = builder.dataType;
        this.isRequired = builder.isRequired;
        this.label = builder.label;
        this.description = builder.description;
        this.scope = builder.scope;
        this.connectorSuppliedValueOptions = builder.connectorSuppliedValueOptions;
    }

    /**
     * <p>
     * Contains value information about the connector runtime setting.
     * </p>
     * 
     * @return Contains value information about the connector runtime setting.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Data type of the connector runtime setting.
     * </p>
     * 
     * @return Data type of the connector runtime setting.
     */
    public final String dataType() {
        return dataType;
    }

    /**
     * <p>
     * Indicates whether this connector runtime setting is required.
     * </p>
     * 
     * @return Indicates whether this connector runtime setting is required.
     */
    public final Boolean isRequired() {
        return isRequired;
    }

    /**
     * <p>
     * A label used for connector runtime setting.
     * </p>
     * 
     * @return A label used for connector runtime setting.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * A description about the connector runtime setting.
     * </p>
     * 
     * @return A description about the connector runtime setting.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates the scope of the connector runtime setting.
     * </p>
     * 
     * @return Indicates the scope of the connector runtime setting.
     */
    public final String scope() {
        return scope;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorSuppliedValueOptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorSuppliedValueOptions() {
        return connectorSuppliedValueOptions != null && !(connectorSuppliedValueOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains default values for the connector runtime setting that are supplied by the connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorSuppliedValueOptions} method.
     * </p>
     * 
     * @return Contains default values for the connector runtime setting that are supplied by the connector.
     */
    public final List<String> connectorSuppliedValueOptions() {
        return connectorSuppliedValueOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(isRequired());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorSuppliedValueOptions() ? connectorSuppliedValueOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorRuntimeSetting)) {
            return false;
        }
        ConnectorRuntimeSetting other = (ConnectorRuntimeSetting) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(isRequired(), other.isRequired()) && Objects.equals(label(), other.label())
                && Objects.equals(description(), other.description()) && Objects.equals(scope(), other.scope())
                && hasConnectorSuppliedValueOptions() == other.hasConnectorSuppliedValueOptions()
                && Objects.equals(connectorSuppliedValueOptions(), other.connectorSuppliedValueOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConnectorRuntimeSetting")
                .add("Key", key())
                .add("DataType", dataType())
                .add("IsRequired", isRequired())
                .add("Label", label())
                .add("Description", description())
                .add("Scope", scope())
                .add("ConnectorSuppliedValueOptions", hasConnectorSuppliedValueOptions() ? connectorSuppliedValueOptions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "isRequired":
            return Optional.ofNullable(clazz.cast(isRequired()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "connectorSuppliedValueOptions":
            return Optional.ofNullable(clazz.cast(connectorSuppliedValueOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("isRequired", IS_REQUIRED_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("connectorSuppliedValueOptions", CONNECTOR_SUPPLIED_VALUE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorRuntimeSetting, T> g) {
        return obj -> g.apply((ConnectorRuntimeSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorRuntimeSetting> {
        /**
         * <p>
         * Contains value information about the connector runtime setting.
         * </p>
         * 
         * @param key
         *        Contains value information about the connector runtime setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Data type of the connector runtime setting.
         * </p>
         * 
         * @param dataType
         *        Data type of the connector runtime setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * Indicates whether this connector runtime setting is required.
         * </p>
         * 
         * @param isRequired
         *        Indicates whether this connector runtime setting is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRequired(Boolean isRequired);

        /**
         * <p>
         * A label used for connector runtime setting.
         * </p>
         * 
         * @param label
         *        A label used for connector runtime setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * A description about the connector runtime setting.
         * </p>
         * 
         * @param description
         *        A description about the connector runtime setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates the scope of the connector runtime setting.
         * </p>
         * 
         * @param scope
         *        Indicates the scope of the connector runtime setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);

        /**
         * <p>
         * Contains default values for the connector runtime setting that are supplied by the connector.
         * </p>
         * 
         * @param connectorSuppliedValueOptions
         *        Contains default values for the connector runtime setting that are supplied by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorSuppliedValueOptions(Collection<String> connectorSuppliedValueOptions);

        /**
         * <p>
         * Contains default values for the connector runtime setting that are supplied by the connector.
         * </p>
         * 
         * @param connectorSuppliedValueOptions
         *        Contains default values for the connector runtime setting that are supplied by the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorSuppliedValueOptions(String... connectorSuppliedValueOptions);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String dataType;

        private Boolean isRequired;

        private String label;

        private String description;

        private String scope;

        private List<String> connectorSuppliedValueOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorRuntimeSetting model) {
            key(model.key);
            dataType(model.dataType);
            isRequired(model.isRequired);
            label(model.label);
            description(model.description);
            scope(model.scope);
            connectorSuppliedValueOptions(model.connectorSuppliedValueOptions);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final Boolean getIsRequired() {
            return isRequired;
        }

        public final void setIsRequired(Boolean isRequired) {
            this.isRequired = isRequired;
        }

        @Override
        public final Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getConnectorSuppliedValueOptions() {
            if (connectorSuppliedValueOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return connectorSuppliedValueOptions;
        }

        public final void setConnectorSuppliedValueOptions(Collection<String> connectorSuppliedValueOptions) {
            this.connectorSuppliedValueOptions = ConnectorSuppliedValueOptionListCopier.copy(connectorSuppliedValueOptions);
        }

        @Override
        public final Builder connectorSuppliedValueOptions(Collection<String> connectorSuppliedValueOptions) {
            this.connectorSuppliedValueOptions = ConnectorSuppliedValueOptionListCopier.copy(connectorSuppliedValueOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorSuppliedValueOptions(String... connectorSuppliedValueOptions) {
            connectorSuppliedValueOptions(Arrays.asList(connectorSuppliedValueOptions));
            return this;
        }

        @Override
        public ConnectorRuntimeSetting build() {
            return new ConnectorRuntimeSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
