/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorProfileRequest extends AppflowRequest implements
        ToCopyableBuilder<CreateConnectorProfileRequest.Builder, CreateConnectorProfileRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(CreateConnectorProfileRequest::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsArn")
            .getter(getter(CreateConnectorProfileRequest::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsArn").build()).build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(CreateConnectorProfileRequest::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorLabel").getter(getter(CreateConnectorProfileRequest::connectorLabel))
            .setter(setter(Builder::connectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()).build();

    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionMode").getter(getter(CreateConnectorProfileRequest::connectionModeAsString))
            .setter(setter(Builder::connectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionMode").build()).build();

    private static final SdkField<ConnectorProfileConfig> CONNECTOR_PROFILE_CONFIG_FIELD = SdkField
            .<ConnectorProfileConfig> builder(MarshallingType.SDK_POJO).memberName("connectorProfileConfig")
            .getter(getter(CreateConnectorProfileRequest::connectorProfileConfig))
            .setter(setter(Builder::connectorProfileConfig)).constructor(ConnectorProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileConfig").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateConnectorProfileRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD,
            KMS_ARN_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, CONNECTION_MODE_FIELD, CONNECTOR_PROFILE_CONFIG_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorProfileName;

    private final String kmsArn;

    private final String connectorType;

    private final String connectorLabel;

    private final String connectionMode;

    private final ConnectorProfileConfig connectorProfileConfig;

    private final String clientToken;

    private CreateConnectorProfileRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.kmsArn = builder.kmsArn;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.connectionMode = builder.connectionMode;
        this.connectorProfileConfig = builder.connectorProfileConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon Web
     * Services account.
     * </p>
     * 
     * @return The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your
     *         Amazon Web Services account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is
     * required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon
     * AppFlow uses the Amazon AppFlow-managed KMS key.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This
     *         is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything
     *         here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Amplitude, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Amplitude, and so on.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon Web
     * Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
     * </p>
     * 
     * @return The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your
     *         Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
     */
    public final String connectorLabel() {
        return connectorLabel;
    }

    /**
     * <p>
     * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
     * internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     *         Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the
     *         public internet.
     * @see ConnectionMode
     */
    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(connectionMode);
    }

    /**
     * <p>
     * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
     * internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionMode}
     * will return {@link ConnectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionModeAsString}.
     * </p>
     * 
     * @return Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
     *         Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the
     *         public internet.
     * @see ConnectionMode
     */
    public final String connectionModeAsString() {
        return connectionMode;
    }

    /**
     * <p>
     * Defines the connector-specific configuration and credentials.
     * </p>
     * 
     * @return Defines the connector-specific configuration and credentials.
     */
    public final ConnectorProfileConfig connectorProfileConfig() {
        return connectorProfileConfig;
    }

    /**
     * <p>
     * The <code>clientToken</code> parameter is an idempotency token. It ensures that your
     * <code>CreateConnectorProfile</code> request completes only once. You choose the value to pass. For example, if
     * you don't receive a response from your request, you can safely retry the request with the same
     * <code>clientToken</code> parameter value.
     * </p>
     * <p>
     * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value for
     * you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own
     * value for other use cases.
     * </p>
     * <p>
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different
     * value for <code>clientToken</code>, Amazon AppFlow considers it a new call to <code>CreateConnectorProfile</code>
     * . The token is active for 8 hours.
     * </p>
     * 
     * @return The <code>clientToken</code> parameter is an idempotency token. It ensures that your
     *         <code>CreateConnectorProfile</code> request completes only once. You choose the value to pass. For
     *         example, if you don't receive a response from your request, you can safely retry the request with the
     *         same <code>clientToken</code> parameter value.</p>
     *         <p>
     *         If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
     *         value for you. This way, the SDK can safely retry requests multiple times after a network error. You must
     *         provide your own value for other use cases.
     *         </p>
     *         <p>
     *         If you specify input parameters that differ from your first request, an error occurs. If you use a
     *         different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
     *         <code>CreateConnectorProfile</code>. The token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorProfileRequest)) {
            return false;
        }
        CreateConnectorProfileRequest other = (CreateConnectorProfileRequest) obj;
        return Objects.equals(connectorProfileName(), other.connectorProfileName()) && Objects.equals(kmsArn(), other.kmsArn())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorLabel(), other.connectorLabel())
                && Objects.equals(connectionModeAsString(), other.connectionModeAsString())
                && Objects.equals(connectorProfileConfig(), other.connectorProfileConfig())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorProfileRequest").add("ConnectorProfileName", connectorProfileName())
                .add("KmsArn", kmsArn()).add("ConnectorType", connectorTypeAsString()).add("ConnectorLabel", connectorLabel())
                .add("ConnectionMode", connectionModeAsString()).add("ConnectorProfileConfig", connectorProfileConfig())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "kmsArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorLabel":
            return Optional.ofNullable(clazz.cast(connectorLabel()));
        case "connectionMode":
            return Optional.ofNullable(clazz.cast(connectionModeAsString()));
        case "connectorProfileConfig":
            return Optional.ofNullable(clazz.cast(connectorProfileConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorProfileName", CONNECTOR_PROFILE_NAME_FIELD);
        map.put("kmsArn", KMS_ARN_FIELD);
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("connectorLabel", CONNECTOR_LABEL_FIELD);
        map.put("connectionMode", CONNECTION_MODE_FIELD);
        map.put("connectorProfileConfig", CONNECTOR_PROFILE_CONFIG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorProfileRequest, T> g) {
        return obj -> g.apply((CreateConnectorProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorProfileRequest> {
        /**
         * <p>
         * The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your Amazon
         * Web Services account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile. The name is unique for each <code>ConnectorProfile</code> in your
         *        Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is
         * required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here,
         * Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * </p>
         * 
         * @param kmsArn
         *        The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         *        This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide
         *        anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Amplitude, and so on.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your Amazon
         * Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
         * </p>
         * 
         * @param connectorLabel
         *        The label of the connector. The label is unique for each <code>ConnectorRegistration</code> in your
         *        Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorLabel(String connectorLabel);

        /**
         * <p>
         * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
         * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
         * internet.
         * </p>
         * 
         * @param connectionMode
         *        Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon
         *        Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to
         *        the public internet.
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(String connectionMode);

        /**
         * <p>
         * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web
         * Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public
         * internet.
         * </p>
         * 
         * @param connectionMode
         *        Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon
         *        Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to
         *        the public internet.
         * @see ConnectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionMode
         */
        Builder connectionMode(ConnectionMode connectionMode);

        /**
         * <p>
         * Defines the connector-specific configuration and credentials.
         * </p>
         * 
         * @param connectorProfileConfig
         *        Defines the connector-specific configuration and credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileConfig(ConnectorProfileConfig connectorProfileConfig);

        /**
         * <p>
         * Defines the connector-specific configuration and credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorProfileConfig.Builder} avoiding
         * the need to create one manually via {@link ConnectorProfileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorProfileConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #connectorProfileConfig(ConnectorProfileConfig)}.
         * 
         * @param connectorProfileConfig
         *        a consumer that will call methods on {@link ConnectorProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorProfileConfig(ConnectorProfileConfig)
         */
        default Builder connectorProfileConfig(Consumer<ConnectorProfileConfig.Builder> connectorProfileConfig) {
            return connectorProfileConfig(ConnectorProfileConfig.builder().applyMutation(connectorProfileConfig).build());
        }

        /**
         * <p>
         * The <code>clientToken</code> parameter is an idempotency token. It ensures that your
         * <code>CreateConnectorProfile</code> request completes only once. You choose the value to pass. For example,
         * if you don't receive a response from your request, you can safely retry the request with the same
         * <code>clientToken</code> parameter value.
         * </p>
         * <p>
         * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value
         * for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide
         * your own value for other use cases.
         * </p>
         * <p>
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different
         * value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
         * <code>CreateConnectorProfile</code>. The token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        The <code>clientToken</code> parameter is an idempotency token. It ensures that your
         *        <code>CreateConnectorProfile</code> request completes only once. You choose the value to pass. For
         *        example, if you don't receive a response from your request, you can safely retry the request with the
         *        same <code>clientToken</code> parameter value.</p>
         *        <p>
         *        If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
         *        value for you. This way, the SDK can safely retry requests multiple times after a network error. You
         *        must provide your own value for other use cases.
         *        </p>
         *        <p>
         *        If you specify input parameters that differ from your first request, an error occurs. If you use a
         *        different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
         *        <code>CreateConnectorProfile</code>. The token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorProfileName;

        private String kmsArn;

        private String connectorType;

        private String connectorLabel;

        private String connectionMode;

        private ConnectorProfileConfig connectorProfileConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorProfileRequest model) {
            super(model);
            connectorProfileName(model.connectorProfileName);
            kmsArn(model.kmsArn);
            connectorType(model.connectorType);
            connectorLabel(model.connectorLabel);
            connectionMode(model.connectionMode);
            connectorProfileConfig(model.connectorProfileConfig);
            clientToken(model.clientToken);
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getConnectionMode() {
            return connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final ConnectorProfileConfig.Builder getConnectorProfileConfig() {
            return connectorProfileConfig != null ? connectorProfileConfig.toBuilder() : null;
        }

        public final void setConnectorProfileConfig(ConnectorProfileConfig.BuilderImpl connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig != null ? connectorProfileConfig.build() : null;
        }

        @Override
        public final Builder connectorProfileConfig(ConnectorProfileConfig connectorProfileConfig) {
            this.connectorProfileConfig = connectorProfileConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorProfileRequest build() {
            return new CreateConnectorProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
