/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorEntityResponse extends AppflowResponse implements
        ToCopyableBuilder<DescribeConnectorEntityResponse.Builder, DescribeConnectorEntityResponse> {
    private static final SdkField<List<ConnectorEntityField>> CONNECTOR_ENTITY_FIELDS_FIELD = SdkField
            .<List<ConnectorEntityField>> builder(MarshallingType.LIST)
            .memberName("connectorEntityFields")
            .getter(getter(DescribeConnectorEntityResponse::connectorEntityFields))
            .setter(setter(Builder::connectorEntityFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorEntityField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorEntityField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONNECTOR_ENTITY_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConnectorEntityField> connectorEntityFields;

    private DescribeConnectorEntityResponse(BuilderImpl builder) {
        super(builder);
        this.connectorEntityFields = builder.connectorEntityFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorEntityFields property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConnectorEntityFields() {
        return connectorEntityFields != null && !(connectorEntityFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields would be
     * <i>account name</i>, <i>account ID</i>, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorEntityFields} method.
     * </p>
     * 
     * @return Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields
     *         would be <i>account name</i>, <i>account ID</i>, and so on.
     */
    public final List<ConnectorEntityField> connectorEntityFields() {
        return connectorEntityFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorEntityFields() ? connectorEntityFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorEntityResponse)) {
            return false;
        }
        DescribeConnectorEntityResponse other = (DescribeConnectorEntityResponse) obj;
        return hasConnectorEntityFields() == other.hasConnectorEntityFields()
                && Objects.equals(connectorEntityFields(), other.connectorEntityFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorEntityResponse")
                .add("ConnectorEntityFields", hasConnectorEntityFields() ? connectorEntityFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorEntityFields":
            return Optional.ofNullable(clazz.cast(connectorEntityFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorEntityFields", CONNECTOR_ENTITY_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorEntityResponse, T> g) {
        return obj -> g.apply((DescribeConnectorEntityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorEntityResponse> {
        /**
         * <p>
         * Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields would
         * be <i>account name</i>, <i>account ID</i>, and so on.
         * </p>
         * 
         * @param connectorEntityFields
         *        Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields
         *        would be <i>account name</i>, <i>account ID</i>, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorEntityFields(Collection<ConnectorEntityField> connectorEntityFields);

        /**
         * <p>
         * Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields would
         * be <i>account name</i>, <i>account ID</i>, and so on.
         * </p>
         * 
         * @param connectorEntityFields
         *        Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields
         *        would be <i>account name</i>, <i>account ID</i>, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorEntityFields(ConnectorEntityField... connectorEntityFields);

        /**
         * <p>
         * Describes the fields for that connector entity. For example, for an <i>account</i> entity, the fields would
         * be <i>account name</i>, <i>account ID</i>, and so on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorEntityField.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.appflow.model.ConnectorEntityField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appflow.model.ConnectorEntityField.Builder#build()} is called
         * immediately and its result is passed to {@link #connectorEntityFields(List<ConnectorEntityField>)}.
         * 
         * @param connectorEntityFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appflow.model.ConnectorEntityField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorEntityFields(java.util.Collection<ConnectorEntityField>)
         */
        Builder connectorEntityFields(Consumer<ConnectorEntityField.Builder>... connectorEntityFields);
    }

    static final class BuilderImpl extends AppflowResponse.BuilderImpl implements Builder {
        private List<ConnectorEntityField> connectorEntityFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorEntityResponse model) {
            super(model);
            connectorEntityFields(model.connectorEntityFields);
        }

        public final List<ConnectorEntityField.Builder> getConnectorEntityFields() {
            List<ConnectorEntityField.Builder> result = ConnectorEntityFieldListCopier.copyToBuilder(this.connectorEntityFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectorEntityFields(Collection<ConnectorEntityField.BuilderImpl> connectorEntityFields) {
            this.connectorEntityFields = ConnectorEntityFieldListCopier.copyFromBuilder(connectorEntityFields);
        }

        @Override
        public final Builder connectorEntityFields(Collection<ConnectorEntityField> connectorEntityFields) {
            this.connectorEntityFields = ConnectorEntityFieldListCopier.copy(connectorEntityFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorEntityFields(ConnectorEntityField... connectorEntityFields) {
            connectorEntityFields(Arrays.asList(connectorEntityFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorEntityFields(Consumer<ConnectorEntityField.Builder>... connectorEntityFields) {
            connectorEntityFields(Stream.of(connectorEntityFields)
                    .map(c -> ConnectorEntityField.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeConnectorEntityResponse build() {
            return new DescribeConnectorEntityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
