/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefixConfig implements SdkPojo, Serializable, ToCopyableBuilder<PrefixConfig.Builder, PrefixConfig> {
    private static final SdkField<String> PREFIX_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("prefixType").getter(getter(PrefixConfig::prefixTypeAsString)).setter(setter(Builder::prefixType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixType").build()).build();

    private static final SdkField<String> PREFIX_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("prefixFormat").getter(getter(PrefixConfig::prefixFormatAsString)).setter(setter(Builder::prefixFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixFormat").build()).build();

    private static final SdkField<List<String>> PATH_PREFIX_HIERARCHY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("pathPrefixHierarchy")
            .getter(getter(PrefixConfig::pathPrefixHierarchyAsStrings))
            .setter(setter(Builder::pathPrefixHierarchyWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathPrefixHierarchy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_TYPE_FIELD,
            PREFIX_FORMAT_FIELD, PATH_PREFIX_HIERARCHY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String prefixType;

    private final String prefixFormat;

    private final List<String> pathPrefixHierarchy;

    private PrefixConfig(BuilderImpl builder) {
        this.prefixType = builder.prefixType;
        this.prefixFormat = builder.prefixFormat;
        this.pathPrefixHierarchy = builder.pathPrefixHierarchy;
    }

    /**
     * <p>
     * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #prefixType} will
     * return {@link PrefixType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #prefixTypeAsString}.
     * </p>
     * 
     * @return Determines the format of the prefix, and whether it applies to the file name, file path, or both.
     * @see PrefixType
     */
    public final PrefixType prefixType() {
        return PrefixType.fromValue(prefixType);
    }

    /**
     * <p>
     * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #prefixType} will
     * return {@link PrefixType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #prefixTypeAsString}.
     * </p>
     * 
     * @return Determines the format of the prefix, and whether it applies to the file name, file path, or both.
     * @see PrefixType
     */
    public final String prefixTypeAsString() {
        return prefixType;
    }

    /**
     * <p>
     * Determines the level of granularity for the date and time that's included in the prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #prefixFormat} will
     * return {@link PrefixFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #prefixFormatAsString}.
     * </p>
     * 
     * @return Determines the level of granularity for the date and time that's included in the prefix.
     * @see PrefixFormat
     */
    public final PrefixFormat prefixFormat() {
        return PrefixFormat.fromValue(prefixFormat);
    }

    /**
     * <p>
     * Determines the level of granularity for the date and time that's included in the prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #prefixFormat} will
     * return {@link PrefixFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #prefixFormatAsString}.
     * </p>
     * 
     * @return Determines the level of granularity for the date and time that's included in the prefix.
     * @see PrefixFormat
     */
    public final String prefixFormatAsString() {
        return prefixFormat;
    }

    /**
     * <p>
     * Specifies whether the destination file path includes either or both of the following elements:
     * </p>
     * <dl>
     * <dt>EXECUTION_ID</dt>
     * <dd>
     * <p>
     * The ID that Amazon AppFlow assigns to the flow run.
     * </p>
     * </dd>
     * <dt>SCHEMA_VERSION</dt>
     * <dd>
     * <p>
     * The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases
     * by one when you change any of the following settings in your flow configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Source-to-destination field mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Field data types
     * </p>
     * </li>
     * <li>
     * <p>
     * Partition keys
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPathPrefixHierarchy} method.
     * </p>
     * 
     * @return Specifies whether the destination file path includes either or both of the following elements:</p>
     *         <dl>
     *         <dt>EXECUTION_ID</dt>
     *         <dd>
     *         <p>
     *         The ID that Amazon AppFlow assigns to the flow run.
     *         </p>
     *         </dd>
     *         <dt>SCHEMA_VERSION</dt>
     *         <dd>
     *         <p>
     *         The version number of your data schema. Amazon AppFlow assigns this version number. The version number
     *         increases by one when you change any of the following settings in your flow configuration:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Source-to-destination field mappings
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Field data types
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Partition keys
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     */
    public final List<PathPrefix> pathPrefixHierarchy() {
        return PathPrefixHierarchyCopier.copyStringToEnum(pathPrefixHierarchy);
    }

    /**
     * For responses, this returns true if the service returned a value for the PathPrefixHierarchy property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPathPrefixHierarchy() {
        return pathPrefixHierarchy != null && !(pathPrefixHierarchy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether the destination file path includes either or both of the following elements:
     * </p>
     * <dl>
     * <dt>EXECUTION_ID</dt>
     * <dd>
     * <p>
     * The ID that Amazon AppFlow assigns to the flow run.
     * </p>
     * </dd>
     * <dt>SCHEMA_VERSION</dt>
     * <dd>
     * <p>
     * The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases
     * by one when you change any of the following settings in your flow configuration:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Source-to-destination field mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Field data types
     * </p>
     * </li>
     * <li>
     * <p>
     * Partition keys
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPathPrefixHierarchy} method.
     * </p>
     * 
     * @return Specifies whether the destination file path includes either or both of the following elements:</p>
     *         <dl>
     *         <dt>EXECUTION_ID</dt>
     *         <dd>
     *         <p>
     *         The ID that Amazon AppFlow assigns to the flow run.
     *         </p>
     *         </dd>
     *         <dt>SCHEMA_VERSION</dt>
     *         <dd>
     *         <p>
     *         The version number of your data schema. Amazon AppFlow assigns this version number. The version number
     *         increases by one when you change any of the following settings in your flow configuration:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Source-to-destination field mappings
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Field data types
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Partition keys
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     */
    public final List<String> pathPrefixHierarchyAsStrings() {
        return pathPrefixHierarchy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefixTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefixFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPathPrefixHierarchy() ? pathPrefixHierarchyAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixConfig)) {
            return false;
        }
        PrefixConfig other = (PrefixConfig) obj;
        return Objects.equals(prefixTypeAsString(), other.prefixTypeAsString())
                && Objects.equals(prefixFormatAsString(), other.prefixFormatAsString())
                && hasPathPrefixHierarchy() == other.hasPathPrefixHierarchy()
                && Objects.equals(pathPrefixHierarchyAsStrings(), other.pathPrefixHierarchyAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefixConfig").add("PrefixType", prefixTypeAsString())
                .add("PrefixFormat", prefixFormatAsString())
                .add("PathPrefixHierarchy", hasPathPrefixHierarchy() ? pathPrefixHierarchyAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "prefixType":
            return Optional.ofNullable(clazz.cast(prefixTypeAsString()));
        case "prefixFormat":
            return Optional.ofNullable(clazz.cast(prefixFormatAsString()));
        case "pathPrefixHierarchy":
            return Optional.ofNullable(clazz.cast(pathPrefixHierarchyAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("prefixType", PREFIX_TYPE_FIELD);
        map.put("prefixFormat", PREFIX_FORMAT_FIELD);
        map.put("pathPrefixHierarchy", PATH_PREFIX_HIERARCHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefixConfig, T> g) {
        return obj -> g.apply((PrefixConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefixConfig> {
        /**
         * <p>
         * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         * </p>
         * 
         * @param prefixType
         *        Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         * @see PrefixType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefixType
         */
        Builder prefixType(String prefixType);

        /**
         * <p>
         * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         * </p>
         * 
         * @param prefixType
         *        Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         * @see PrefixType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefixType
         */
        Builder prefixType(PrefixType prefixType);

        /**
         * <p>
         * Determines the level of granularity for the date and time that's included in the prefix.
         * </p>
         * 
         * @param prefixFormat
         *        Determines the level of granularity for the date and time that's included in the prefix.
         * @see PrefixFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefixFormat
         */
        Builder prefixFormat(String prefixFormat);

        /**
         * <p>
         * Determines the level of granularity for the date and time that's included in the prefix.
         * </p>
         * 
         * @param prefixFormat
         *        Determines the level of granularity for the date and time that's included in the prefix.
         * @see PrefixFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefixFormat
         */
        Builder prefixFormat(PrefixFormat prefixFormat);

        /**
         * <p>
         * Specifies whether the destination file path includes either or both of the following elements:
         * </p>
         * <dl>
         * <dt>EXECUTION_ID</dt>
         * <dd>
         * <p>
         * The ID that Amazon AppFlow assigns to the flow run.
         * </p>
         * </dd>
         * <dt>SCHEMA_VERSION</dt>
         * <dd>
         * <p>
         * The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         * increases by one when you change any of the following settings in your flow configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Source-to-destination field mappings
         * </p>
         * </li>
         * <li>
         * <p>
         * Field data types
         * </p>
         * </li>
         * <li>
         * <p>
         * Partition keys
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param pathPrefixHierarchy
         *        Specifies whether the destination file path includes either or both of the following elements:</p>
         *        <dl>
         *        <dt>EXECUTION_ID</dt>
         *        <dd>
         *        <p>
         *        The ID that Amazon AppFlow assigns to the flow run.
         *        </p>
         *        </dd>
         *        <dt>SCHEMA_VERSION</dt>
         *        <dd>
         *        <p>
         *        The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         *        increases by one when you change any of the following settings in your flow configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Source-to-destination field mappings
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Field data types
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Partition keys
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPrefixHierarchyWithStrings(Collection<String> pathPrefixHierarchy);

        /**
         * <p>
         * Specifies whether the destination file path includes either or both of the following elements:
         * </p>
         * <dl>
         * <dt>EXECUTION_ID</dt>
         * <dd>
         * <p>
         * The ID that Amazon AppFlow assigns to the flow run.
         * </p>
         * </dd>
         * <dt>SCHEMA_VERSION</dt>
         * <dd>
         * <p>
         * The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         * increases by one when you change any of the following settings in your flow configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Source-to-destination field mappings
         * </p>
         * </li>
         * <li>
         * <p>
         * Field data types
         * </p>
         * </li>
         * <li>
         * <p>
         * Partition keys
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param pathPrefixHierarchy
         *        Specifies whether the destination file path includes either or both of the following elements:</p>
         *        <dl>
         *        <dt>EXECUTION_ID</dt>
         *        <dd>
         *        <p>
         *        The ID that Amazon AppFlow assigns to the flow run.
         *        </p>
         *        </dd>
         *        <dt>SCHEMA_VERSION</dt>
         *        <dd>
         *        <p>
         *        The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         *        increases by one when you change any of the following settings in your flow configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Source-to-destination field mappings
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Field data types
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Partition keys
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPrefixHierarchyWithStrings(String... pathPrefixHierarchy);

        /**
         * <p>
         * Specifies whether the destination file path includes either or both of the following elements:
         * </p>
         * <dl>
         * <dt>EXECUTION_ID</dt>
         * <dd>
         * <p>
         * The ID that Amazon AppFlow assigns to the flow run.
         * </p>
         * </dd>
         * <dt>SCHEMA_VERSION</dt>
         * <dd>
         * <p>
         * The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         * increases by one when you change any of the following settings in your flow configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Source-to-destination field mappings
         * </p>
         * </li>
         * <li>
         * <p>
         * Field data types
         * </p>
         * </li>
         * <li>
         * <p>
         * Partition keys
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param pathPrefixHierarchy
         *        Specifies whether the destination file path includes either or both of the following elements:</p>
         *        <dl>
         *        <dt>EXECUTION_ID</dt>
         *        <dd>
         *        <p>
         *        The ID that Amazon AppFlow assigns to the flow run.
         *        </p>
         *        </dd>
         *        <dt>SCHEMA_VERSION</dt>
         *        <dd>
         *        <p>
         *        The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         *        increases by one when you change any of the following settings in your flow configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Source-to-destination field mappings
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Field data types
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Partition keys
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPrefixHierarchy(Collection<PathPrefix> pathPrefixHierarchy);

        /**
         * <p>
         * Specifies whether the destination file path includes either or both of the following elements:
         * </p>
         * <dl>
         * <dt>EXECUTION_ID</dt>
         * <dd>
         * <p>
         * The ID that Amazon AppFlow assigns to the flow run.
         * </p>
         * </dd>
         * <dt>SCHEMA_VERSION</dt>
         * <dd>
         * <p>
         * The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         * increases by one when you change any of the following settings in your flow configuration:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Source-to-destination field mappings
         * </p>
         * </li>
         * <li>
         * <p>
         * Field data types
         * </p>
         * </li>
         * <li>
         * <p>
         * Partition keys
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * 
         * @param pathPrefixHierarchy
         *        Specifies whether the destination file path includes either or both of the following elements:</p>
         *        <dl>
         *        <dt>EXECUTION_ID</dt>
         *        <dd>
         *        <p>
         *        The ID that Amazon AppFlow assigns to the flow run.
         *        </p>
         *        </dd>
         *        <dt>SCHEMA_VERSION</dt>
         *        <dd>
         *        <p>
         *        The version number of your data schema. Amazon AppFlow assigns this version number. The version number
         *        increases by one when you change any of the following settings in your flow configuration:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Source-to-destination field mappings
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Field data types
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Partition keys
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathPrefixHierarchy(PathPrefix... pathPrefixHierarchy);
    }

    static final class BuilderImpl implements Builder {
        private String prefixType;

        private String prefixFormat;

        private List<String> pathPrefixHierarchy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixConfig model) {
            prefixType(model.prefixType);
            prefixFormat(model.prefixFormat);
            pathPrefixHierarchyWithStrings(model.pathPrefixHierarchy);
        }

        public final String getPrefixType() {
            return prefixType;
        }

        public final void setPrefixType(String prefixType) {
            this.prefixType = prefixType;
        }

        @Override
        public final Builder prefixType(String prefixType) {
            this.prefixType = prefixType;
            return this;
        }

        @Override
        public final Builder prefixType(PrefixType prefixType) {
            this.prefixType(prefixType == null ? null : prefixType.toString());
            return this;
        }

        public final String getPrefixFormat() {
            return prefixFormat;
        }

        public final void setPrefixFormat(String prefixFormat) {
            this.prefixFormat = prefixFormat;
        }

        @Override
        public final Builder prefixFormat(String prefixFormat) {
            this.prefixFormat = prefixFormat;
            return this;
        }

        @Override
        public final Builder prefixFormat(PrefixFormat prefixFormat) {
            this.prefixFormat(prefixFormat == null ? null : prefixFormat.toString());
            return this;
        }

        public final Collection<String> getPathPrefixHierarchy() {
            if (pathPrefixHierarchy instanceof SdkAutoConstructList) {
                return null;
            }
            return pathPrefixHierarchy;
        }

        public final void setPathPrefixHierarchy(Collection<String> pathPrefixHierarchy) {
            this.pathPrefixHierarchy = PathPrefixHierarchyCopier.copy(pathPrefixHierarchy);
        }

        @Override
        public final Builder pathPrefixHierarchyWithStrings(Collection<String> pathPrefixHierarchy) {
            this.pathPrefixHierarchy = PathPrefixHierarchyCopier.copy(pathPrefixHierarchy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathPrefixHierarchyWithStrings(String... pathPrefixHierarchy) {
            pathPrefixHierarchyWithStrings(Arrays.asList(pathPrefixHierarchy));
            return this;
        }

        @Override
        public final Builder pathPrefixHierarchy(Collection<PathPrefix> pathPrefixHierarchy) {
            this.pathPrefixHierarchy = PathPrefixHierarchyCopier.copyEnumToString(pathPrefixHierarchy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathPrefixHierarchy(PathPrefix... pathPrefixHierarchy) {
            pathPrefixHierarchy(Arrays.asList(pathPrefixHierarchy));
            return this;
        }

        @Override
        public PrefixConfig build() {
            return new PrefixConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
