/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResetConnectorMetadataCacheRequest extends AppflowRequest implements
        ToCopyableBuilder<ResetConnectorMetadataCacheRequest.Builder, ResetConnectorMetadataCacheRequest> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProfileName").getter(getter(ResetConnectorMetadataCacheRequest::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProfileName").build())
            .build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(ResetConnectorMetadataCacheRequest::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_ENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorEntityName").getter(getter(ResetConnectorMetadataCacheRequest::connectorEntityName))
            .setter(setter(Builder::connectorEntityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorEntityName").build())
            .build();

    private static final SdkField<String> ENTITIES_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entitiesPath").getter(getter(ResetConnectorMetadataCacheRequest::entitiesPath))
            .setter(setter(Builder::entitiesPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitiesPath").build()).build();

    private static final SdkField<String> API_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiVersion").getter(getter(ResetConnectorMetadataCacheRequest::apiVersion))
            .setter(setter(Builder::apiVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD,
            CONNECTOR_TYPE_FIELD, CONNECTOR_ENTITY_NAME_FIELD, ENTITIES_PATH_FIELD, API_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorProfileName;

    private final String connectorType;

    private final String connectorEntityName;

    private final String entitiesPath;

    private final String apiVersion;

    private ResetConnectorMetadataCacheRequest(BuilderImpl builder) {
        super(builder);
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.connectorEntityName = builder.connectorEntityName;
        this.entitiesPath = builder.entitiesPath;
        this.apiVersion = builder.apiVersion;
    }

    /**
     * <p>
     * The name of the connector profile that you want to reset cached metadata for.
     * </p>
     * <p>
     * You can omit this parameter if you're resetting the cache for any of the following connectors: Amazon Connect,
     * Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the cache for any
     * other connector, you must include this parameter in your request.
     * </p>
     * 
     * @return The name of the connector profile that you want to reset cached metadata for.</p>
     *         <p>
     *         You can omit this parameter if you're resetting the cache for any of the following connectors: Amazon
     *         Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the
     *         cache for any other connector, you must include this parameter in your request.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The type of connector to reset cached metadata for.
     * </p>
     * <p>
     * You must include this parameter in your request if you're resetting the cache for any of the following
     * connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're
     * resetting the cache for any other connector, you can omit this parameter from your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector to reset cached metadata for.</p>
     *         <p>
     *         You must include this parameter in your request if you're resetting the cache for any of the following
     *         connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If
     *         you're resetting the cache for any other connector, you can omit this parameter from your request.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector to reset cached metadata for.
     * </p>
     * <p>
     * You must include this parameter in your request if you're resetting the cache for any of the following
     * connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're
     * resetting the cache for any other connector, you can omit this parameter from your request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector to reset cached metadata for.</p>
     *         <p>
     *         You must include this parameter in your request if you're resetting the cache for any of the following
     *         connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If
     *         you're resetting the cache for any other connector, you can omit this parameter from your request.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * Use this parameter if you want to reset cached metadata about the details for an individual entity.
     * </p>
     * <p>
     * If you don't include this parameter in your request, Amazon AppFlow only resets cached metadata about entity
     * names, not entity details.
     * </p>
     * 
     * @return Use this parameter if you want to reset cached metadata about the details for an individual entity.</p>
     *         <p>
     *         If you don't include this parameter in your request, Amazon AppFlow only resets cached metadata about
     *         entity names, not entity details.
     */
    public final String connectorEntityName() {
        return connectorEntityName;
    }

    /**
     * <p>
     * Use this parameter only if you’re resetting the cached metadata about a nested entity. Only some connectors
     * support nested entities. A nested entity is one that has another entity as a parent. To use this parameter,
     * specify the name of the parent entity.
     * </p>
     * <p>
     * To look up the parent-child relationship of entities, you can send a ListConnectorEntities request that omits the
     * entitiesPath parameter. Amazon AppFlow will return a list of top-level entities. For each one, it indicates
     * whether the entity has nested entities. Then, in a subsequent ListConnectorEntities request, you can specify a
     * parent entity name for the entitiesPath parameter. Amazon AppFlow will return a list of the child entities for
     * that parent.
     * </p>
     * 
     * @return Use this parameter only if you’re resetting the cached metadata about a nested entity. Only some
     *         connectors support nested entities. A nested entity is one that has another entity as a parent. To use
     *         this parameter, specify the name of the parent entity.</p>
     *         <p>
     *         To look up the parent-child relationship of entities, you can send a ListConnectorEntities request that
     *         omits the entitiesPath parameter. Amazon AppFlow will return a list of top-level entities. For each one,
     *         it indicates whether the entity has nested entities. Then, in a subsequent ListConnectorEntities request,
     *         you can specify a parent entity name for the entitiesPath parameter. Amazon AppFlow will return a list of
     *         the child entities for that parent.
     */
    public final String entitiesPath() {
        return entitiesPath;
    }

    /**
     * <p>
     * The API version that you specified in the connector profile that you’re resetting cached metadata for. You must
     * use this parameter only if the connector supports multiple API versions or if the connector type is
     * CustomConnector.
     * </p>
     * <p>
     * To look up how many versions a connector supports, use the DescribeConnectors action. In the response, find the
     * value that Amazon AppFlow returns for the connectorVersion parameter.
     * </p>
     * <p>
     * To look up the connector type, use the DescribeConnectorProfiles action. In the response, find the value that
     * Amazon AppFlow returns for the connectorType parameter.
     * </p>
     * <p>
     * To look up the API version that you specified in a connector profile, use the DescribeConnectorProfiles action.
     * </p>
     * 
     * @return The API version that you specified in the connector profile that you’re resetting cached metadata for.
     *         You must use this parameter only if the connector supports multiple API versions or if the connector type
     *         is CustomConnector.</p>
     *         <p>
     *         To look up how many versions a connector supports, use the DescribeConnectors action. In the response,
     *         find the value that Amazon AppFlow returns for the connectorVersion parameter.
     *         </p>
     *         <p>
     *         To look up the connector type, use the DescribeConnectorProfiles action. In the response, find the value
     *         that Amazon AppFlow returns for the connectorType parameter.
     *         </p>
     *         <p>
     *         To look up the API version that you specified in a connector profile, use the DescribeConnectorProfiles
     *         action.
     */
    public final String apiVersion() {
        return apiVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorEntityName());
        hashCode = 31 * hashCode + Objects.hashCode(entitiesPath());
        hashCode = 31 * hashCode + Objects.hashCode(apiVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetConnectorMetadataCacheRequest)) {
            return false;
        }
        ResetConnectorMetadataCacheRequest other = (ResetConnectorMetadataCacheRequest) obj;
        return Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorEntityName(), other.connectorEntityName())
                && Objects.equals(entitiesPath(), other.entitiesPath()) && Objects.equals(apiVersion(), other.apiVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResetConnectorMetadataCacheRequest").add("ConnectorProfileName", connectorProfileName())
                .add("ConnectorType", connectorTypeAsString()).add("ConnectorEntityName", connectorEntityName())
                .add("EntitiesPath", entitiesPath()).add("ApiVersion", apiVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorEntityName":
            return Optional.ofNullable(clazz.cast(connectorEntityName()));
        case "entitiesPath":
            return Optional.ofNullable(clazz.cast(entitiesPath()));
        case "apiVersion":
            return Optional.ofNullable(clazz.cast(apiVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorProfileName", CONNECTOR_PROFILE_NAME_FIELD);
        map.put("connectorType", CONNECTOR_TYPE_FIELD);
        map.put("connectorEntityName", CONNECTOR_ENTITY_NAME_FIELD);
        map.put("entitiesPath", ENTITIES_PATH_FIELD);
        map.put("apiVersion", API_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResetConnectorMetadataCacheRequest, T> g) {
        return obj -> g.apply((ResetConnectorMetadataCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ResetConnectorMetadataCacheRequest> {
        /**
         * <p>
         * The name of the connector profile that you want to reset cached metadata for.
         * </p>
         * <p>
         * You can omit this parameter if you're resetting the cache for any of the following connectors: Amazon
         * Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the
         * cache for any other connector, you must include this parameter in your request.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the connector profile that you want to reset cached metadata for.</p>
         *        <p>
         *        You can omit this parameter if you're resetting the cache for any of the following connectors: Amazon
         *        Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting
         *        the cache for any other connector, you must include this parameter in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The type of connector to reset cached metadata for.
         * </p>
         * <p>
         * You must include this parameter in your request if you're resetting the cache for any of the following
         * connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're
         * resetting the cache for any other connector, you can omit this parameter from your request.
         * </p>
         * 
         * @param connectorType
         *        The type of connector to reset cached metadata for.</p>
         *        <p>
         *        You must include this parameter in your request if you're resetting the cache for any of the following
         *        connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If
         *        you're resetting the cache for any other connector, you can omit this parameter from your request.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector to reset cached metadata for.
         * </p>
         * <p>
         * You must include this parameter in your request if you're resetting the cache for any of the following
         * connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're
         * resetting the cache for any other connector, you can omit this parameter from your request.
         * </p>
         * 
         * @param connectorType
         *        The type of connector to reset cached metadata for.</p>
         *        <p>
         *        You must include this parameter in your request if you're resetting the cache for any of the following
         *        connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If
         *        you're resetting the cache for any other connector, you can omit this parameter from your request.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * Use this parameter if you want to reset cached metadata about the details for an individual entity.
         * </p>
         * <p>
         * If you don't include this parameter in your request, Amazon AppFlow only resets cached metadata about entity
         * names, not entity details.
         * </p>
         * 
         * @param connectorEntityName
         *        Use this parameter if you want to reset cached metadata about the details for an individual
         *        entity.</p>
         *        <p>
         *        If you don't include this parameter in your request, Amazon AppFlow only resets cached metadata about
         *        entity names, not entity details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorEntityName(String connectorEntityName);

        /**
         * <p>
         * Use this parameter only if you’re resetting the cached metadata about a nested entity. Only some connectors
         * support nested entities. A nested entity is one that has another entity as a parent. To use this parameter,
         * specify the name of the parent entity.
         * </p>
         * <p>
         * To look up the parent-child relationship of entities, you can send a ListConnectorEntities request that omits
         * the entitiesPath parameter. Amazon AppFlow will return a list of top-level entities. For each one, it
         * indicates whether the entity has nested entities. Then, in a subsequent ListConnectorEntities request, you
         * can specify a parent entity name for the entitiesPath parameter. Amazon AppFlow will return a list of the
         * child entities for that parent.
         * </p>
         * 
         * @param entitiesPath
         *        Use this parameter only if you’re resetting the cached metadata about a nested entity. Only some
         *        connectors support nested entities. A nested entity is one that has another entity as a parent. To use
         *        this parameter, specify the name of the parent entity.</p>
         *        <p>
         *        To look up the parent-child relationship of entities, you can send a ListConnectorEntities request
         *        that omits the entitiesPath parameter. Amazon AppFlow will return a list of top-level entities. For
         *        each one, it indicates whether the entity has nested entities. Then, in a subsequent
         *        ListConnectorEntities request, you can specify a parent entity name for the entitiesPath parameter.
         *        Amazon AppFlow will return a list of the child entities for that parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesPath(String entitiesPath);

        /**
         * <p>
         * The API version that you specified in the connector profile that you’re resetting cached metadata for. You
         * must use this parameter only if the connector supports multiple API versions or if the connector type is
         * CustomConnector.
         * </p>
         * <p>
         * To look up how many versions a connector supports, use the DescribeConnectors action. In the response, find
         * the value that Amazon AppFlow returns for the connectorVersion parameter.
         * </p>
         * <p>
         * To look up the connector type, use the DescribeConnectorProfiles action. In the response, find the value that
         * Amazon AppFlow returns for the connectorType parameter.
         * </p>
         * <p>
         * To look up the API version that you specified in a connector profile, use the DescribeConnectorProfiles
         * action.
         * </p>
         * 
         * @param apiVersion
         *        The API version that you specified in the connector profile that you’re resetting cached metadata for.
         *        You must use this parameter only if the connector supports multiple API versions or if the connector
         *        type is CustomConnector.</p>
         *        <p>
         *        To look up how many versions a connector supports, use the DescribeConnectors action. In the response,
         *        find the value that Amazon AppFlow returns for the connectorVersion parameter.
         *        </p>
         *        <p>
         *        To look up the connector type, use the DescribeConnectorProfiles action. In the response, find the
         *        value that Amazon AppFlow returns for the connectorType parameter.
         *        </p>
         *        <p>
         *        To look up the API version that you specified in a connector profile, use the
         *        DescribeConnectorProfiles action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiVersion(String apiVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String connectorProfileName;

        private String connectorType;

        private String connectorEntityName;

        private String entitiesPath;

        private String apiVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetConnectorMetadataCacheRequest model) {
            super(model);
            connectorProfileName(model.connectorProfileName);
            connectorType(model.connectorType);
            connectorEntityName(model.connectorEntityName);
            entitiesPath(model.entitiesPath);
            apiVersion(model.apiVersion);
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorEntityName() {
            return connectorEntityName;
        }

        public final void setConnectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
        }

        @Override
        public final Builder connectorEntityName(String connectorEntityName) {
            this.connectorEntityName = connectorEntityName;
            return this;
        }

        public final String getEntitiesPath() {
            return entitiesPath;
        }

        public final void setEntitiesPath(String entitiesPath) {
            this.entitiesPath = entitiesPath;
        }

        @Override
        public final Builder entitiesPath(String entitiesPath) {
            this.entitiesPath = entitiesPath;
            return this;
        }

        public final String getApiVersion() {
            return apiVersion;
        }

        public final void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetConnectorMetadataCacheRequest build() {
            return new ResetConnectorMetadataCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
