/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Salesforce is being used as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceDestinationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceDestinationProperties.Builder, SalesforceDestinationProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("object")
            .getter(getter(SalesforceDestinationProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("object").build()).build();

    private static final SdkField<List<String>> ID_FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("idFieldNames")
            .getter(getter(SalesforceDestinationProperties::idFieldNames))
            .setter(setter(Builder::idFieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idFieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorHandlingConfig> ERROR_HANDLING_CONFIG_FIELD = SdkField
            .<ErrorHandlingConfig> builder(MarshallingType.SDK_POJO).memberName("errorHandlingConfig")
            .getter(getter(SalesforceDestinationProperties::errorHandlingConfig)).setter(setter(Builder::errorHandlingConfig))
            .constructor(ErrorHandlingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorHandlingConfig").build())
            .build();

    private static final SdkField<String> WRITE_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("writeOperationType").getter(getter(SalesforceDestinationProperties::writeOperationTypeAsString))
            .setter(setter(Builder::writeOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeOperationType").build())
            .build();

    private static final SdkField<String> DATA_TRANSFER_API_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTransferApi").getter(getter(SalesforceDestinationProperties::dataTransferApiAsString))
            .setter(setter(Builder::dataTransferApi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferApi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD,
            ID_FIELD_NAMES_FIELD, ERROR_HANDLING_CONFIG_FIELD, WRITE_OPERATION_TYPE_FIELD, DATA_TRANSFER_API_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String object;

    private final List<String> idFieldNames;

    private final ErrorHandlingConfig errorHandlingConfig;

    private final String writeOperationType;

    private final String dataTransferApi;

    private SalesforceDestinationProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.idFieldNames = builder.idFieldNames;
        this.errorHandlingConfig = builder.errorHandlingConfig;
        this.writeOperationType = builder.writeOperationType;
        this.dataTransferApi = builder.dataTransferApi;
    }

    /**
     * <p>
     * The object specified in the Salesforce flow destination.
     * </p>
     * 
     * @return The object specified in the Salesforce flow destination.
     */
    public final String object() {
        return object;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdFieldNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdFieldNames() {
        return idFieldNames != null && !(idFieldNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or
     * delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdFieldNames} method.
     * </p>
     * 
     * @return The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update
     *         or delete.
     */
    public final List<String> idFieldNames() {
        return idFieldNames;
    }

    /**
     * <p>
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
     * For example, this setting would determine if the flow should fail after one insertion error, or continue and
     * attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of
     * the destination connector details.
     * </p>
     * 
     * @return The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce
     *         destination. For example, this setting would determine if the flow should fail after one insertion error,
     *         or continue and attempt to insert every record regardless of the initial failure.
     *         <code>ErrorHandlingConfig</code> is a part of the destination connector details.
     */
    public final ErrorHandlingConfig errorHandlingConfig() {
        return errorHandlingConfig;
    }

    /**
     * <p>
     * This specifies the type of write operation to be performed in Salesforce. When the value is <code>UPSERT</code>,
     * then <code>idFieldNames</code> is required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeOperationType} will return {@link WriteOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #writeOperationTypeAsString}.
     * </p>
     * 
     * @return This specifies the type of write operation to be performed in Salesforce. When the value is
     *         <code>UPSERT</code>, then <code>idFieldNames</code> is required.
     * @see WriteOperationType
     */
    public final WriteOperationType writeOperationType() {
        return WriteOperationType.fromValue(writeOperationType);
    }

    /**
     * <p>
     * This specifies the type of write operation to be performed in Salesforce. When the value is <code>UPSERT</code>,
     * then <code>idFieldNames</code> is required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeOperationType} will return {@link WriteOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #writeOperationTypeAsString}.
     * </p>
     * 
     * @return This specifies the type of write operation to be performed in Salesforce. When the value is
     *         <code>UPSERT</code>, then <code>idFieldNames</code> is required.
     * @see WriteOperationType
     */
    public final String writeOperationTypeAsString() {
        return writeOperationType;
    }

    /**
     * <p>
     * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
     * </p>
     * <dl>
     * <dt>AUTOMATIC</dt>
     * <dd>
     * <p>
     * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to
     * Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your
     * flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
     * </p>
     * <p>
     * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be
     * aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow
     * runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next
     * day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data
     * differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk
     * API 2.0 doesn't transfer Salesforce compound fields.
     * </p>
     * <p>
     * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff
     * is inconsistent formatting in the output.
     * </p>
     * </dd>
     * <dt>BULKV2</dt>
     * <dd>
     * <p>
     * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for
     * large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize
     * performance only for large data transfers.
     * </p>
     * <p>
     * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
     * </p>
     * </dd>
     * <dt>REST_SYNC</dt>
     * <dd>
     * <p>
     * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes
     * consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0.
     * In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTransferApi}
     * will return {@link SalesforceDataTransferApi#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataTransferApiAsString}.
     * </p>
     * 
     * @return Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.</p>
     *         <dl>
     *         <dt>AUTOMATIC</dt>
     *         <dd>
     *         <p>
     *         The default. Amazon AppFlow selects which API to use based on the number of records that your flow
     *         transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce
     *         REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
     *         </p>
     *         <p>
     *         Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API
     *         automatically, be aware that, for recurring flows, the data output might vary from one flow run to the
     *         next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it
     *         might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the
     *         respective Salesforce API formats the data differently. Some of the differences include how dates are
     *         formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound
     *         fields.
     *         </p>
     *         <p>
     *         By choosing this option, you optimize flow performance for both small and large data transfers, but the
     *         tradeoff is inconsistent formatting in the output.
     *         </p>
     *         </dd>
     *         <dt>BULKV2</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's
     *         optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent
     *         output, but you optimize performance only for large data transfers.
     *         </p>
     *         <p>
     *         Note that Bulk API 2.0 does not transfer Salesforce compound fields.
     *         </p>
     *         </dd>
     *         <dt>REST_SYNC</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes
     *         consistent output, but you decrease performance for large data transfers that are better suited for Bulk
     *         API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a
     *         timed out error.
     *         </p>
     *         </dd>
     * @see SalesforceDataTransferApi
     */
    public final SalesforceDataTransferApi dataTransferApi() {
        return SalesforceDataTransferApi.fromValue(dataTransferApi);
    }

    /**
     * <p>
     * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
     * </p>
     * <dl>
     * <dt>AUTOMATIC</dt>
     * <dd>
     * <p>
     * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to
     * Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your
     * flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
     * </p>
     * <p>
     * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be
     * aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow
     * runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next
     * day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data
     * differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk
     * API 2.0 doesn't transfer Salesforce compound fields.
     * </p>
     * <p>
     * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff
     * is inconsistent formatting in the output.
     * </p>
     * </dd>
     * <dt>BULKV2</dt>
     * <dd>
     * <p>
     * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for
     * large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize
     * performance only for large data transfers.
     * </p>
     * <p>
     * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
     * </p>
     * </dd>
     * <dt>REST_SYNC</dt>
     * <dd>
     * <p>
     * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes
     * consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0.
     * In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTransferApi}
     * will return {@link SalesforceDataTransferApi#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataTransferApiAsString}.
     * </p>
     * 
     * @return Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.</p>
     *         <dl>
     *         <dt>AUTOMATIC</dt>
     *         <dd>
     *         <p>
     *         The default. Amazon AppFlow selects which API to use based on the number of records that your flow
     *         transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce
     *         REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
     *         </p>
     *         <p>
     *         Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API
     *         automatically, be aware that, for recurring flows, the data output might vary from one flow run to the
     *         next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it
     *         might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the
     *         respective Salesforce API formats the data differently. Some of the differences include how dates are
     *         formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound
     *         fields.
     *         </p>
     *         <p>
     *         By choosing this option, you optimize flow performance for both small and large data transfers, but the
     *         tradeoff is inconsistent formatting in the output.
     *         </p>
     *         </dd>
     *         <dt>BULKV2</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's
     *         optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent
     *         output, but you optimize performance only for large data transfers.
     *         </p>
     *         <p>
     *         Note that Bulk API 2.0 does not transfer Salesforce compound fields.
     *         </p>
     *         </dd>
     *         <dt>REST_SYNC</dt>
     *         <dd>
     *         <p>
     *         Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes
     *         consistent output, but you decrease performance for large data transfers that are better suited for Bulk
     *         API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a
     *         timed out error.
     *         </p>
     *         </dd>
     * @see SalesforceDataTransferApi
     */
    public final String dataTransferApiAsString() {
        return dataTransferApi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdFieldNames() ? idFieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(errorHandlingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(writeOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferApiAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceDestinationProperties)) {
            return false;
        }
        SalesforceDestinationProperties other = (SalesforceDestinationProperties) obj;
        return Objects.equals(object(), other.object()) && hasIdFieldNames() == other.hasIdFieldNames()
                && Objects.equals(idFieldNames(), other.idFieldNames())
                && Objects.equals(errorHandlingConfig(), other.errorHandlingConfig())
                && Objects.equals(writeOperationTypeAsString(), other.writeOperationTypeAsString())
                && Objects.equals(dataTransferApiAsString(), other.dataTransferApiAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceDestinationProperties").add("Object", object())
                .add("IdFieldNames", hasIdFieldNames() ? idFieldNames() : null).add("ErrorHandlingConfig", errorHandlingConfig())
                .add("WriteOperationType", writeOperationTypeAsString()).add("DataTransferApi", dataTransferApiAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "object":
            return Optional.ofNullable(clazz.cast(object()));
        case "idFieldNames":
            return Optional.ofNullable(clazz.cast(idFieldNames()));
        case "errorHandlingConfig":
            return Optional.ofNullable(clazz.cast(errorHandlingConfig()));
        case "writeOperationType":
            return Optional.ofNullable(clazz.cast(writeOperationTypeAsString()));
        case "dataTransferApi":
            return Optional.ofNullable(clazz.cast(dataTransferApiAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("object", OBJECT_FIELD);
        map.put("idFieldNames", ID_FIELD_NAMES_FIELD);
        map.put("errorHandlingConfig", ERROR_HANDLING_CONFIG_FIELD);
        map.put("writeOperationType", WRITE_OPERATION_TYPE_FIELD);
        map.put("dataTransferApi", DATA_TRANSFER_API_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SalesforceDestinationProperties, T> g) {
        return obj -> g.apply((SalesforceDestinationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceDestinationProperties> {
        /**
         * <p>
         * The object specified in the Salesforce flow destination.
         * </p>
         * 
         * @param object
         *        The object specified in the Salesforce flow destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * <p>
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or
         * delete.
         * </p>
         * 
         * @param idFieldNames
         *        The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as
         *        update or delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idFieldNames(Collection<String> idFieldNames);

        /**
         * <p>
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or
         * delete.
         * </p>
         * 
         * @param idFieldNames
         *        The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as
         *        update or delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idFieldNames(String... idFieldNames);

        /**
         * <p>
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce
         * destination. For example, this setting would determine if the flow should fail after one insertion error, or
         * continue and attempt to insert every record regardless of the initial failure.
         * <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * </p>
         * 
         * @param errorHandlingConfig
         *        The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce
         *        destination. For example, this setting would determine if the flow should fail after one insertion
         *        error, or continue and attempt to insert every record regardless of the initial failure.
         *        <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig);

        /**
         * <p>
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce
         * destination. For example, this setting would determine if the flow should fail after one insertion error, or
         * continue and attempt to insert every record regardless of the initial failure.
         * <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorHandlingConfig.Builder} avoiding the
         * need to create one manually via {@link ErrorHandlingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorHandlingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #errorHandlingConfig(ErrorHandlingConfig)}.
         * 
         * @param errorHandlingConfig
         *        a consumer that will call methods on {@link ErrorHandlingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorHandlingConfig(ErrorHandlingConfig)
         */
        default Builder errorHandlingConfig(Consumer<ErrorHandlingConfig.Builder> errorHandlingConfig) {
            return errorHandlingConfig(ErrorHandlingConfig.builder().applyMutation(errorHandlingConfig).build());
        }

        /**
         * <p>
         * This specifies the type of write operation to be performed in Salesforce. When the value is
         * <code>UPSERT</code>, then <code>idFieldNames</code> is required.
         * </p>
         * 
         * @param writeOperationType
         *        This specifies the type of write operation to be performed in Salesforce. When the value is
         *        <code>UPSERT</code>, then <code>idFieldNames</code> is required.
         * @see WriteOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteOperationType
         */
        Builder writeOperationType(String writeOperationType);

        /**
         * <p>
         * This specifies the type of write operation to be performed in Salesforce. When the value is
         * <code>UPSERT</code>, then <code>idFieldNames</code> is required.
         * </p>
         * 
         * @param writeOperationType
         *        This specifies the type of write operation to be performed in Salesforce. When the value is
         *        <code>UPSERT</code>, then <code>idFieldNames</code> is required.
         * @see WriteOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WriteOperationType
         */
        Builder writeOperationType(WriteOperationType writeOperationType);

        /**
         * <p>
         * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
         * </p>
         * <dl>
         * <dt>AUTOMATIC</dt>
         * <dd>
         * <p>
         * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers
         * to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If
         * your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
         * </p>
         * <p>
         * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically,
         * be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if
         * a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on
         * the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats
         * the data differently. Some of the differences include how dates are formatted and null values are
         * represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
         * </p>
         * <p>
         * By choosing this option, you optimize flow performance for both small and large data transfers, but the
         * tradeoff is inconsistent formatting in the output.
         * </p>
         * </dd>
         * <dt>BULKV2</dt>
         * <dd>
         * <p>
         * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal
         * for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you
         * optimize performance only for large data transfers.
         * </p>
         * <p>
         * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         * </p>
         * </dd>
         * <dt>REST_SYNC</dt>
         * <dd>
         * <p>
         * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes
         * consistent output, but you decrease performance for large data transfers that are better suited for Bulk API
         * 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed
         * out error.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param dataTransferApi
         *        Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to
         *        Salesforce.</p>
         *        <dl>
         *        <dt>AUTOMATIC</dt>
         *        <dd>
         *        <p>
         *        The default. Amazon AppFlow selects which API to use based on the number of records that your flow
         *        transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses
         *        Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk
         *        API 2.0.
         *        </p>
         *        <p>
         *        Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API
         *        automatically, be aware that, for recurring flows, the data output might vary from one flow run to the
         *        next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and
         *        it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the
         *        respective Salesforce API formats the data differently. Some of the differences include how dates are
         *        formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound
         *        fields.
         *        </p>
         *        <p>
         *        By choosing this option, you optimize flow performance for both small and large data transfers, but
         *        the tradeoff is inconsistent formatting in the output.
         *        </p>
         *        </dd>
         *        <dt>BULKV2</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's
         *        optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent
         *        output, but you optimize performance only for large data transfers.
         *        </p>
         *        <p>
         *        Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         *        </p>
         *        </dd>
         *        <dt>REST_SYNC</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow
         *        writes consistent output, but you decrease performance for large data transfers that are better suited
         *        for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might
         *        fail with a timed out error.
         *        </p>
         *        </dd>
         * @see SalesforceDataTransferApi
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceDataTransferApi
         */
        Builder dataTransferApi(String dataTransferApi);

        /**
         * <p>
         * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
         * </p>
         * <dl>
         * <dt>AUTOMATIC</dt>
         * <dd>
         * <p>
         * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers
         * to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If
         * your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
         * </p>
         * <p>
         * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically,
         * be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if
         * a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on
         * the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats
         * the data differently. Some of the differences include how dates are formatted and null values are
         * represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
         * </p>
         * <p>
         * By choosing this option, you optimize flow performance for both small and large data transfers, but the
         * tradeoff is inconsistent formatting in the output.
         * </p>
         * </dd>
         * <dt>BULKV2</dt>
         * <dd>
         * <p>
         * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal
         * for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you
         * optimize performance only for large data transfers.
         * </p>
         * <p>
         * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         * </p>
         * </dd>
         * <dt>REST_SYNC</dt>
         * <dd>
         * <p>
         * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes
         * consistent output, but you decrease performance for large data transfers that are better suited for Bulk API
         * 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed
         * out error.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param dataTransferApi
         *        Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to
         *        Salesforce.</p>
         *        <dl>
         *        <dt>AUTOMATIC</dt>
         *        <dd>
         *        <p>
         *        The default. Amazon AppFlow selects which API to use based on the number of records that your flow
         *        transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses
         *        Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk
         *        API 2.0.
         *        </p>
         *        <p>
         *        Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API
         *        automatically, be aware that, for recurring flows, the data output might vary from one flow run to the
         *        next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and
         *        it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the
         *        respective Salesforce API formats the data differently. Some of the differences include how dates are
         *        formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound
         *        fields.
         *        </p>
         *        <p>
         *        By choosing this option, you optimize flow performance for both small and large data transfers, but
         *        the tradeoff is inconsistent formatting in the output.
         *        </p>
         *        </dd>
         *        <dt>BULKV2</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's
         *        optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent
         *        output, but you optimize performance only for large data transfers.
         *        </p>
         *        <p>
         *        Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         *        </p>
         *        </dd>
         *        <dt>REST_SYNC</dt>
         *        <dd>
         *        <p>
         *        Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow
         *        writes consistent output, but you decrease performance for large data transfers that are better suited
         *        for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might
         *        fail with a timed out error.
         *        </p>
         *        </dd>
         * @see SalesforceDataTransferApi
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceDataTransferApi
         */
        Builder dataTransferApi(SalesforceDataTransferApi dataTransferApi);
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private List<String> idFieldNames = DefaultSdkAutoConstructList.getInstance();

        private ErrorHandlingConfig errorHandlingConfig;

        private String writeOperationType;

        private String dataTransferApi;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceDestinationProperties model) {
            object(model.object);
            idFieldNames(model.idFieldNames);
            errorHandlingConfig(model.errorHandlingConfig);
            writeOperationType(model.writeOperationType);
            dataTransferApi(model.dataTransferApi);
        }

        public final String getObject() {
            return object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final Collection<String> getIdFieldNames() {
            if (idFieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return idFieldNames;
        }

        public final void setIdFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
        }

        @Override
        public final Builder idFieldNames(Collection<String> idFieldNames) {
            this.idFieldNames = IdFieldNameListCopier.copy(idFieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idFieldNames(String... idFieldNames) {
            idFieldNames(Arrays.asList(idFieldNames));
            return this;
        }

        public final ErrorHandlingConfig.Builder getErrorHandlingConfig() {
            return errorHandlingConfig != null ? errorHandlingConfig.toBuilder() : null;
        }

        public final void setErrorHandlingConfig(ErrorHandlingConfig.BuilderImpl errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig != null ? errorHandlingConfig.build() : null;
        }

        @Override
        public final Builder errorHandlingConfig(ErrorHandlingConfig errorHandlingConfig) {
            this.errorHandlingConfig = errorHandlingConfig;
            return this;
        }

        public final String getWriteOperationType() {
            return writeOperationType;
        }

        public final void setWriteOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
        }

        @Override
        public final Builder writeOperationType(String writeOperationType) {
            this.writeOperationType = writeOperationType;
            return this;
        }

        @Override
        public final Builder writeOperationType(WriteOperationType writeOperationType) {
            this.writeOperationType(writeOperationType == null ? null : writeOperationType.toString());
            return this;
        }

        public final String getDataTransferApi() {
            return dataTransferApi;
        }

        public final void setDataTransferApi(String dataTransferApi) {
            this.dataTransferApi = dataTransferApi;
        }

        @Override
        public final Builder dataTransferApi(String dataTransferApi) {
            this.dataTransferApi = dataTransferApi;
            return this;
        }

        @Override
        public final Builder dataTransferApi(SalesforceDataTransferApi dataTransferApi) {
            this.dataTransferApi(dataTransferApi == null ? null : dataTransferApi.toString());
            return this;
        }

        @Override
        public SalesforceDestinationProperties build() {
            return new SalesforceDestinationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
