/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile credentials required when using ServiceNow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNowConnectorProfileCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNowConnectorProfileCredentials.Builder, ServiceNowConnectorProfileCredentials> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(ServiceNowConnectorProfileCredentials::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("password").getter(getter(ServiceNowConnectorProfileCredentials::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<OAuth2Credentials> O_AUTH2_CREDENTIALS_FIELD = SdkField
            .<OAuth2Credentials> builder(MarshallingType.SDK_POJO).memberName("oAuth2Credentials")
            .getter(getter(ServiceNowConnectorProfileCredentials::oAuth2Credentials)).setter(setter(Builder::oAuth2Credentials))
            .constructor(OAuth2Credentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Credentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, O_AUTH2_CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private final OAuth2Credentials oAuth2Credentials;

    private ServiceNowConnectorProfileCredentials(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.oAuth2Credentials = builder.oAuth2Credentials;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The password that corresponds to the user name.
     * </p>
     * 
     * @return The password that corresponds to the user name.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The OAuth 2.0 credentials required to authenticate the user.
     * </p>
     * 
     * @return The OAuth 2.0 credentials required to authenticate the user.
     */
    public final OAuth2Credentials oAuth2Credentials() {
        return oAuth2Credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth2Credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowConnectorProfileCredentials)) {
            return false;
        }
        ServiceNowConnectorProfileCredentials other = (ServiceNowConnectorProfileCredentials) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(oAuth2Credentials(), other.oAuth2Credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNowConnectorProfileCredentials").add("Username", username())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OAuth2Credentials", oAuth2Credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "password":
            return Optional.ofNullable(clazz.cast(password()));
        case "oAuth2Credentials":
            return Optional.ofNullable(clazz.cast(oAuth2Credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("username", USERNAME_FIELD);
        map.put("password", PASSWORD_FIELD);
        map.put("oAuth2Credentials", O_AUTH2_CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowConnectorProfileCredentials, T> g) {
        return obj -> g.apply((ServiceNowConnectorProfileCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNowConnectorProfileCredentials> {
        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param username
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password that corresponds to the user name.
         * </p>
         * 
         * @param password
         *        The password that corresponds to the user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The OAuth 2.0 credentials required to authenticate the user.
         * </p>
         * 
         * @param oAuth2Credentials
         *        The OAuth 2.0 credentials required to authenticate the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth2Credentials(OAuth2Credentials oAuth2Credentials);

        /**
         * <p>
         * The OAuth 2.0 credentials required to authenticate the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link OAuth2Credentials.Builder} avoiding the
         * need to create one manually via {@link OAuth2Credentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OAuth2Credentials.Builder#build()} is called immediately and its
         * result is passed to {@link #oAuth2Credentials(OAuth2Credentials)}.
         * 
         * @param oAuth2Credentials
         *        a consumer that will call methods on {@link OAuth2Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth2Credentials(OAuth2Credentials)
         */
        default Builder oAuth2Credentials(Consumer<OAuth2Credentials.Builder> oAuth2Credentials) {
            return oAuth2Credentials(OAuth2Credentials.builder().applyMutation(oAuth2Credentials).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private OAuth2Credentials oAuth2Credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowConnectorProfileCredentials model) {
            username(model.username);
            password(model.password);
            oAuth2Credentials(model.oAuth2Credentials);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final OAuth2Credentials.Builder getOAuth2Credentials() {
            return oAuth2Credentials != null ? oAuth2Credentials.toBuilder() : null;
        }

        public final void setOAuth2Credentials(OAuth2Credentials.BuilderImpl oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials != null ? oAuth2Credentials.build() : null;
        }

        @Override
        public final Builder oAuth2Credentials(OAuth2Credentials oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials;
            return this;
        }

        @Override
        public ServiceNowConnectorProfileCredentials build() {
            return new ServiceNowConnectorProfileCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
