/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.OAuth2GrantType;
import software.amazon.awssdk.services.appflow.model.TokenUrlCustomPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2Properties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2Properties> {
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenUrl").getter(OAuth2Properties.getter(OAuth2Properties::tokenUrl)).setter(OAuth2Properties.setter(Builder::tokenUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()}).build();
    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oAuth2GrantType").getter(OAuth2Properties.getter(OAuth2Properties::oAuth2GrantTypeAsString)).setter(OAuth2Properties.setter(Builder::oAuth2GrantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2GrantType").build()}).build();
    private static final SdkField<Map<String, String>> TOKEN_URL_CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tokenUrlCustomProperties").getter(OAuth2Properties.getter(OAuth2Properties::tokenUrlCustomProperties)).setter(OAuth2Properties.setter(Builder::tokenUrlCustomProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrlCustomProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_URL_FIELD, O_AUTH2_GRANT_TYPE_FIELD, TOKEN_URL_CUSTOM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuth2Properties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tokenUrl;
    private final String oAuth2GrantType;
    private final Map<String, String> tokenUrlCustomProperties;

    private OAuth2Properties(BuilderImpl builder) {
        this.tokenUrl = builder.tokenUrl;
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.tokenUrlCustomProperties = builder.tokenUrlCustomProperties;
    }

    public final String tokenUrl() {
        return this.tokenUrl;
    }

    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(this.oAuth2GrantType);
    }

    public final String oAuth2GrantTypeAsString() {
        return this.oAuth2GrantType;
    }

    public final boolean hasTokenUrlCustomProperties() {
        return this.tokenUrlCustomProperties != null && !(this.tokenUrlCustomProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tokenUrlCustomProperties() {
        return this.tokenUrlCustomProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenUrlCustomProperties() ? this.tokenUrlCustomProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Properties)) {
            return false;
        }
        OAuth2Properties other = (OAuth2Properties)obj;
        return Objects.equals(this.tokenUrl(), other.tokenUrl()) && Objects.equals(this.oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString()) && this.hasTokenUrlCustomProperties() == other.hasTokenUrlCustomProperties() && Objects.equals(this.tokenUrlCustomProperties(), other.tokenUrlCustomProperties());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2Properties").add("TokenUrl", (Object)this.tokenUrl()).add("OAuth2GrantType", (Object)this.oAuth2GrantTypeAsString()).add("TokenUrlCustomProperties", this.hasTokenUrlCustomProperties() ? this.tokenUrlCustomProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenUrl()));
            }
            case "oAuth2GrantType": {
                return Optional.ofNullable(clazz.cast(this.oAuth2GrantTypeAsString()));
            }
            case "tokenUrlCustomProperties": {
                return Optional.ofNullable(clazz.cast(this.tokenUrlCustomProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tokenUrl", TOKEN_URL_FIELD);
        map.put("oAuth2GrantType", O_AUTH2_GRANT_TYPE_FIELD);
        map.put("tokenUrlCustomProperties", TOKEN_URL_CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Properties, T> g) {
        return obj -> g.apply((OAuth2Properties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tokenUrl;
        private String oAuth2GrantType;
        private Map<String, String> tokenUrlCustomProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Properties model) {
            this.tokenUrl(model.tokenUrl);
            this.oAuth2GrantType(model.oAuth2GrantType);
            this.tokenUrlCustomProperties(model.tokenUrlCustomProperties);
        }

        public final String getTokenUrl() {
            return this.tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final String getOAuth2GrantType() {
            return this.oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final Map<String, String> getTokenUrlCustomProperties() {
            if (this.tokenUrlCustomProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tokenUrlCustomProperties;
        }

        public final void setTokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties) {
            this.tokenUrlCustomProperties = TokenUrlCustomPropertiesCopier.copy(tokenUrlCustomProperties);
        }

        @Override
        public final Builder tokenUrlCustomProperties(Map<String, String> tokenUrlCustomProperties) {
            this.tokenUrlCustomProperties = TokenUrlCustomPropertiesCopier.copy(tokenUrlCustomProperties);
            return this;
        }

        public OAuth2Properties build() {
            return new OAuth2Properties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2Properties> {
        public Builder tokenUrl(String var1);

        public Builder oAuth2GrantType(String var1);

        public Builder oAuth2GrantType(OAuth2GrantType var1);

        public Builder tokenUrlCustomProperties(Map<String, String> var1);
    }
}

