/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftConnectorProfileProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftConnectorProfileProperties> {
    private static final SdkField<String> DATABASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseUrl").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::databaseUrl)).setter(RedshiftConnectorProfileProperties.setter(Builder::databaseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseUrl").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::bucketName)).setter(RedshiftConnectorProfileProperties.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketPrefix").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::bucketPrefix)).setter(RedshiftConnectorProfileProperties.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPrefix").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::roleArn)).setter(RedshiftConnectorProfileProperties.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DATA_API_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataApiRoleArn").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::dataApiRoleArn)).setter(RedshiftConnectorProfileProperties.setter(Builder::dataApiRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataApiRoleArn").build()}).build();
    private static final SdkField<Boolean> IS_REDSHIFT_SERVERLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRedshiftServerless").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::isRedshiftServerless)).setter(RedshiftConnectorProfileProperties.setter(Builder::isRedshiftServerless)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRedshiftServerless").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterIdentifier").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::clusterIdentifier)).setter(RedshiftConnectorProfileProperties.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::workgroupName)).setter(RedshiftConnectorProfileProperties.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(RedshiftConnectorProfileProperties.getter(RedshiftConnectorProfileProperties::databaseName)).setter(RedshiftConnectorProfileProperties.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_URL_FIELD, BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD, ROLE_ARN_FIELD, DATA_API_ROLE_ARN_FIELD, IS_REDSHIFT_SERVERLESS_FIELD, CLUSTER_IDENTIFIER_FIELD, WORKGROUP_NAME_FIELD, DATABASE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftConnectorProfileProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseUrl;
    private final String bucketName;
    private final String bucketPrefix;
    private final String roleArn;
    private final String dataApiRoleArn;
    private final Boolean isRedshiftServerless;
    private final String clusterIdentifier;
    private final String workgroupName;
    private final String databaseName;

    private RedshiftConnectorProfileProperties(BuilderImpl builder) {
        this.databaseUrl = builder.databaseUrl;
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.roleArn = builder.roleArn;
        this.dataApiRoleArn = builder.dataApiRoleArn;
        this.isRedshiftServerless = builder.isRedshiftServerless;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.workgroupName = builder.workgroupName;
        this.databaseName = builder.databaseName;
    }

    public final String databaseUrl() {
        return this.databaseUrl;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketPrefix() {
        return this.bucketPrefix;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String dataApiRoleArn() {
        return this.dataApiRoleArn;
    }

    public final Boolean isRedshiftServerless() {
        return this.isRedshiftServerless;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataApiRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRedshiftServerless());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftConnectorProfileProperties)) {
            return false;
        }
        RedshiftConnectorProfileProperties other = (RedshiftConnectorProfileProperties)obj;
        return Objects.equals(this.databaseUrl(), other.databaseUrl()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataApiRoleArn(), other.dataApiRoleArn()) && Objects.equals(this.isRedshiftServerless(), other.isRedshiftServerless()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.workgroupName(), other.workgroupName()) && Objects.equals(this.databaseName(), other.databaseName());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftConnectorProfileProperties").add("DatabaseUrl", (Object)this.databaseUrl()).add("BucketName", (Object)this.bucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).add("RoleArn", (Object)this.roleArn()).add("DataApiRoleArn", (Object)this.dataApiRoleArn()).add("IsRedshiftServerless", (Object)this.isRedshiftServerless()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("WorkgroupName", (Object)this.workgroupName()).add("DatabaseName", (Object)this.databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "databaseUrl": {
                return Optional.ofNullable(clazz.cast(this.databaseUrl()));
            }
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "bucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "dataApiRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataApiRoleArn()));
            }
            case "isRedshiftServerless": {
                return Optional.ofNullable(clazz.cast(this.isRedshiftServerless()));
            }
            case "clusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("databaseUrl", DATABASE_URL_FIELD);
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("bucketPrefix", BUCKET_PREFIX_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("dataApiRoleArn", DATA_API_ROLE_ARN_FIELD);
        map.put("isRedshiftServerless", IS_REDSHIFT_SERVERLESS_FIELD);
        map.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftConnectorProfileProperties, T> g) {
        return obj -> g.apply((RedshiftConnectorProfileProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseUrl;
        private String bucketName;
        private String bucketPrefix;
        private String roleArn;
        private String dataApiRoleArn;
        private Boolean isRedshiftServerless;
        private String clusterIdentifier;
        private String workgroupName;
        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftConnectorProfileProperties model) {
            this.databaseUrl(model.databaseUrl);
            this.bucketName(model.bucketName);
            this.bucketPrefix(model.bucketPrefix);
            this.roleArn(model.roleArn);
            this.dataApiRoleArn(model.dataApiRoleArn);
            this.isRedshiftServerless(model.isRedshiftServerless);
            this.clusterIdentifier(model.clusterIdentifier);
            this.workgroupName(model.workgroupName);
            this.databaseName(model.databaseName);
        }

        public final String getDatabaseUrl() {
            return this.databaseUrl;
        }

        public final void setDatabaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
        }

        @Override
        public final Builder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDataApiRoleArn() {
            return this.dataApiRoleArn;
        }

        public final void setDataApiRoleArn(String dataApiRoleArn) {
            this.dataApiRoleArn = dataApiRoleArn;
        }

        @Override
        public final Builder dataApiRoleArn(String dataApiRoleArn) {
            this.dataApiRoleArn = dataApiRoleArn;
            return this;
        }

        public final Boolean getIsRedshiftServerless() {
            return this.isRedshiftServerless;
        }

        public final void setIsRedshiftServerless(Boolean isRedshiftServerless) {
            this.isRedshiftServerless = isRedshiftServerless;
        }

        @Override
        public final Builder isRedshiftServerless(Boolean isRedshiftServerless) {
            this.isRedshiftServerless = isRedshiftServerless;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public RedshiftConnectorProfileProperties build() {
            return new RedshiftConnectorProfileProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftConnectorProfileProperties> {
        public Builder databaseUrl(String var1);

        public Builder bucketName(String var1);

        public Builder bucketPrefix(String var1);

        public Builder roleArn(String var1);

        public Builder dataApiRoleArn(String var1);

        public Builder isRedshiftServerless(Boolean var1);

        public Builder clusterIdentifier(String var1);

        public Builder workgroupName(String var1);

        public Builder databaseName(String var1);
    }
}

