/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.internal.UserAgentUtils;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesRequest;
import software.amazon.awssdk.services.appflow.model.DescribeConnectorProfilesResponse;

public class DescribeConnectorProfilesIterable
implements SdkIterable<DescribeConnectorProfilesResponse> {
    private final AppflowClient client;
    private final DescribeConnectorProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConnectorProfilesIterable(AppflowClient client, DescribeConnectorProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConnectorProfilesResponseFetcher();
    }

    public Iterator<DescribeConnectorProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeConnectorProfilesResponseFetcher
    implements SyncPageFetcher<DescribeConnectorProfilesResponse> {
        private DescribeConnectorProfilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConnectorProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConnectorProfilesResponse nextPage(DescribeConnectorProfilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeConnectorProfilesIterable.this.client.describeConnectorProfiles(DescribeConnectorProfilesIterable.this.firstRequest);
            }
            return DescribeConnectorProfilesIterable.this.client.describeConnectorProfiles((DescribeConnectorProfilesRequest)((Object)DescribeConnectorProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

