/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the access logging information for a virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLog implements SdkPojo, Serializable, ToCopyableBuilder<AccessLog.Builder, AccessLog> {
    private static final SdkField<FileAccessLog> FILE_FIELD = SdkField.<FileAccessLog> builder(MarshallingType.SDK_POJO)
            .memberName("file").getter(getter(AccessLog::file)).setter(setter(Builder::file)).constructor(FileAccessLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FileAccessLog file;

    private final Type type;

    private AccessLog(BuilderImpl builder) {
        this.file = builder.file;
        this.type = builder.type;
    }

    /**
     * <p>
     * The file object to send virtual node access logs to.
     * </p>
     * 
     * @return The file object to send virtual node access logs to.
     */
    public final FileAccessLog file() {
        return file;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLog)) {
            return false;
        }
        AccessLog other = (AccessLog) obj;
        return Objects.equals(file(), other.file());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessLog").add("File", file()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * The file object to send virtual node access logs to.
     * </p>
     * 
     * @param file
     *        The file object to send virtual node access logs to.
     */
    public static AccessLog fromFile(FileAccessLog file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * The file object to send virtual node access logs to.
     * </p>
     * 
     * @param file
     *        The file object to send virtual node access logs to.
     */
    public static AccessLog fromFile(Consumer<FileAccessLog.Builder> file) {
        FileAccessLog.Builder builder = FileAccessLog.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("file", FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessLog, T> g) {
        return obj -> g.apply((AccessLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessLog> {
        /**
         * <p>
         * The file object to send virtual node access logs to.
         * </p>
         * 
         * @param file
         *        The file object to send virtual node access logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(FileAccessLog file);

        /**
         * <p>
         * The file object to send virtual node access logs to.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileAccessLog.Builder} avoiding the need
         * to create one manually via {@link FileAccessLog#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileAccessLog.Builder#build()} is called immediately and its
         * result is passed to {@link #file(FileAccessLog)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link FileAccessLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(FileAccessLog)
         */
        default Builder file(Consumer<FileAccessLog.Builder> file) {
            return file(FileAccessLog.builder().applyMutation(file).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileAccessLog file;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLog model) {
            file(model.file);
        }

        public final FileAccessLog.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(FileAccessLog.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(FileAccessLog file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        @Override
        public AccessLog build() {
            return new AccessLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AccessLog#type()
     */
    public enum Type {
        FILE,

        UNKNOWN_TO_SDK_VERSION
    }
}
