/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGatewayRouteRequest extends AppMeshRequest implements
        ToCopyableBuilder<DeleteGatewayRouteRequest.Builder, DeleteGatewayRouteRequest> {
    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayRouteName").getter(getter(DeleteGatewayRouteRequest::gatewayRouteName))
            .setter(setter(Builder::gatewayRouteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayRouteName").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(DeleteGatewayRouteRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(DeleteGatewayRouteRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayName").getter(getter(DeleteGatewayRouteRequest::virtualGatewayName))
            .setter(setter(Builder::virtualGatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTE_NAME_FIELD,
            MESH_NAME_FIELD, MESH_OWNER_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayRouteName;

    private final String meshName;

    private final String meshOwner;

    private final String virtualGatewayName;

    private DeleteGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    /**
     * <p>
     * The name of the gateway route to delete.
     * </p>
     * 
     * @return The name of the gateway route to delete.
     */
    public final String gatewayRouteName() {
        return gatewayRouteName;
    }

    /**
     * <p>
     * The name of the service mesh to delete the gateway route from.
     * </p>
     * 
     * @return The name of the service mesh to delete the gateway route from.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then
     *         it's the ID of the account that shared the mesh with your account. For more information about mesh
     *         sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with
     *         shared meshes</a>.
     */
    public final String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The name of the virtual gateway to delete the route from.
     * </p>
     * 
     * @return The name of the virtual gateway to delete the route from.
     */
    public final String virtualGatewayName() {
        return virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGatewayRouteRequest)) {
            return false;
        }
        DeleteGatewayRouteRequest other = (DeleteGatewayRouteRequest) obj;
        return Objects.equals(gatewayRouteName(), other.gatewayRouteName()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(meshOwner(), other.meshOwner())
                && Objects.equals(virtualGatewayName(), other.virtualGatewayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGatewayRouteRequest").add("GatewayRouteName", gatewayRouteName())
                .add("MeshName", meshName()).add("MeshOwner", meshOwner()).add("VirtualGatewayName", virtualGatewayName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayRouteName":
            return Optional.ofNullable(clazz.cast(gatewayRouteName()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "virtualGatewayName":
            return Optional.ofNullable(clazz.cast(virtualGatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayRouteName", GATEWAY_ROUTE_NAME_FIELD);
        map.put("meshName", MESH_NAME_FIELD);
        map.put("meshOwner", MESH_OWNER_FIELD);
        map.put("virtualGatewayName", VIRTUAL_GATEWAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGatewayRouteRequest, T> g) {
        return obj -> g.apply((DeleteGatewayRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGatewayRouteRequest> {
        /**
         * <p>
         * The name of the gateway route to delete.
         * </p>
         * 
         * @param gatewayRouteName
         *        The name of the gateway route to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRouteName(String gatewayRouteName);

        /**
         * <p>
         * The name of the service mesh to delete the gateway route from.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh to delete the gateway route from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then
         * it's the ID of the account that shared the mesh with your account. For more information about mesh sharing,
         * see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         * meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own,
         *        then it's the ID of the account that shared the mesh with your account. For more information about
         *        mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working
         *        with shared meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The name of the virtual gateway to delete the route from.
         * </p>
         * 
         * @param virtualGatewayName
         *        The name of the virtual gateway to delete the route from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayName(String virtualGatewayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String gatewayRouteName;

        private String meshName;

        private String meshOwner;

        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGatewayRouteRequest model) {
            super(model);
            gatewayRouteName(model.gatewayRouteName);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            virtualGatewayName(model.virtualGatewayName);
        }

        public final String getGatewayRouteName() {
            return gatewayRouteName;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final String getMeshName() {
            return meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final String getVirtualGatewayName() {
            return virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGatewayRouteRequest build() {
            return new DeleteGatewayRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
