/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGatewayRouteResponse extends AppMeshResponse implements
        ToCopyableBuilder<DeleteGatewayRouteResponse.Builder, DeleteGatewayRouteResponse> {
    private static final SdkField<GatewayRouteData> GATEWAY_ROUTE_FIELD = SdkField
            .<GatewayRouteData> builder(MarshallingType.SDK_POJO)
            .memberName("gatewayRoute")
            .getter(getter(DeleteGatewayRouteResponse::gatewayRoute))
            .setter(setter(Builder::gatewayRoute))
            .constructor(GatewayRouteData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayRoute").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ROUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GatewayRouteData gatewayRoute;

    private DeleteGatewayRouteResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayRoute = builder.gatewayRoute;
    }

    /**
     * <p>
     * The gateway route that was deleted.
     * </p>
     * 
     * @return The gateway route that was deleted.
     */
    public final GatewayRouteData gatewayRoute() {
        return gatewayRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRoute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGatewayRouteResponse)) {
            return false;
        }
        DeleteGatewayRouteResponse other = (DeleteGatewayRouteResponse) obj;
        return Objects.equals(gatewayRoute(), other.gatewayRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGatewayRouteResponse").add("GatewayRoute", gatewayRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayRoute":
            return Optional.ofNullable(clazz.cast(gatewayRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayRoute", GATEWAY_ROUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGatewayRouteResponse, T> g) {
        return obj -> g.apply((DeleteGatewayRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGatewayRouteResponse> {
        /**
         * <p>
         * The gateway route that was deleted.
         * </p>
         * 
         * @param gatewayRoute
         *        The gateway route that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRoute(GatewayRouteData gatewayRoute);

        /**
         * <p>
         * The gateway route that was deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayRouteData.Builder} avoiding the
         * need to create one manually via {@link GatewayRouteData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayRouteData.Builder#build()} is called immediately and its
         * result is passed to {@link #gatewayRoute(GatewayRouteData)}.
         * 
         * @param gatewayRoute
         *        a consumer that will call methods on {@link GatewayRouteData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayRoute(GatewayRouteData)
         */
        default Builder gatewayRoute(Consumer<GatewayRouteData.Builder> gatewayRoute) {
            return gatewayRoute(GatewayRouteData.builder().applyMutation(gatewayRoute).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private GatewayRouteData gatewayRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGatewayRouteResponse model) {
            super(model);
            gatewayRoute(model.gatewayRoute);
        }

        public final GatewayRouteData.Builder getGatewayRoute() {
            return gatewayRoute != null ? gatewayRoute.toBuilder() : null;
        }

        public final void setGatewayRoute(GatewayRouteData.BuilderImpl gatewayRoute) {
            this.gatewayRoute = gatewayRoute != null ? gatewayRoute.build() : null;
        }

        @Override
        public final Builder gatewayRoute(GatewayRouteData gatewayRoute) {
            this.gatewayRoute = gatewayRoute;
            return this;
        }

        @Override
        public DeleteGatewayRouteResponse build() {
            return new DeleteGatewayRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
