/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the action to take if a match is determined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcGatewayRouteAction implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcGatewayRouteAction.Builder, GrpcGatewayRouteAction> {
    private static final SdkField<GrpcGatewayRouteRewrite> REWRITE_FIELD = SdkField
            .<GrpcGatewayRouteRewrite> builder(MarshallingType.SDK_POJO).memberName("rewrite")
            .getter(getter(GrpcGatewayRouteAction::rewrite)).setter(setter(Builder::rewrite))
            .constructor(GrpcGatewayRouteRewrite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rewrite").build()).build();

    private static final SdkField<GatewayRouteTarget> TARGET_FIELD = SdkField
            .<GatewayRouteTarget> builder(MarshallingType.SDK_POJO).memberName("target")
            .getter(getter(GrpcGatewayRouteAction::target)).setter(setter(Builder::target))
            .constructor(GatewayRouteTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REWRITE_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GrpcGatewayRouteRewrite rewrite;

    private final GatewayRouteTarget target;

    private GrpcGatewayRouteAction(BuilderImpl builder) {
        this.rewrite = builder.rewrite;
        this.target = builder.target;
    }

    /**
     * <p>
     * The gateway route action to rewrite.
     * </p>
     * 
     * @return The gateway route action to rewrite.
     */
    public final GrpcGatewayRouteRewrite rewrite() {
        return rewrite;
    }

    /**
     * <p>
     * An object that represents the target that traffic is routed to when a request matches the gateway route.
     * </p>
     * 
     * @return An object that represents the target that traffic is routed to when a request matches the gateway route.
     */
    public final GatewayRouteTarget target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rewrite());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcGatewayRouteAction)) {
            return false;
        }
        GrpcGatewayRouteAction other = (GrpcGatewayRouteAction) obj;
        return Objects.equals(rewrite(), other.rewrite()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcGatewayRouteAction").add("Rewrite", rewrite()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rewrite":
            return Optional.ofNullable(clazz.cast(rewrite()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rewrite", REWRITE_FIELD);
        map.put("target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrpcGatewayRouteAction, T> g) {
        return obj -> g.apply((GrpcGatewayRouteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcGatewayRouteAction> {
        /**
         * <p>
         * The gateway route action to rewrite.
         * </p>
         * 
         * @param rewrite
         *        The gateway route action to rewrite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rewrite(GrpcGatewayRouteRewrite rewrite);

        /**
         * <p>
         * The gateway route action to rewrite.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrpcGatewayRouteRewrite.Builder} avoiding
         * the need to create one manually via {@link GrpcGatewayRouteRewrite#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GrpcGatewayRouteRewrite.Builder#build()} is called immediately
         * and its result is passed to {@link #rewrite(GrpcGatewayRouteRewrite)}.
         * 
         * @param rewrite
         *        a consumer that will call methods on {@link GrpcGatewayRouteRewrite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rewrite(GrpcGatewayRouteRewrite)
         */
        default Builder rewrite(Consumer<GrpcGatewayRouteRewrite.Builder> rewrite) {
            return rewrite(GrpcGatewayRouteRewrite.builder().applyMutation(rewrite).build());
        }

        /**
         * <p>
         * An object that represents the target that traffic is routed to when a request matches the gateway route.
         * </p>
         * 
         * @param target
         *        An object that represents the target that traffic is routed to when a request matches the gateway
         *        route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(GatewayRouteTarget target);

        /**
         * <p>
         * An object that represents the target that traffic is routed to when a request matches the gateway route.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayRouteTarget.Builder} avoiding the
         * need to create one manually via {@link GatewayRouteTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayRouteTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #target(GatewayRouteTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link GatewayRouteTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(GatewayRouteTarget)
         */
        default Builder target(Consumer<GatewayRouteTarget.Builder> target) {
            return target(GatewayRouteTarget.builder().applyMutation(target).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrpcGatewayRouteRewrite rewrite;

        private GatewayRouteTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcGatewayRouteAction model) {
            rewrite(model.rewrite);
            target(model.target);
        }

        public final GrpcGatewayRouteRewrite.Builder getRewrite() {
            return rewrite != null ? rewrite.toBuilder() : null;
        }

        public final void setRewrite(GrpcGatewayRouteRewrite.BuilderImpl rewrite) {
            this.rewrite = rewrite != null ? rewrite.build() : null;
        }

        @Override
        public final Builder rewrite(GrpcGatewayRouteRewrite rewrite) {
            this.rewrite = rewrite;
            return this;
        }

        public final GatewayRouteTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(GatewayRouteTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(GatewayRouteTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public GrpcGatewayRouteAction build() {
            return new GrpcGatewayRouteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
