/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents an HTTP gateway route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpGatewayRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpGatewayRoute.Builder, HttpGatewayRoute> {
    private static final SdkField<HttpGatewayRouteAction> ACTION_FIELD = SdkField
            .<HttpGatewayRouteAction> builder(MarshallingType.SDK_POJO).memberName("action")
            .getter(getter(HttpGatewayRoute::action)).setter(setter(Builder::action))
            .constructor(HttpGatewayRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<HttpGatewayRouteMatch> MATCH_FIELD = SdkField
            .<HttpGatewayRouteMatch> builder(MarshallingType.SDK_POJO).memberName("match")
            .getter(getter(HttpGatewayRoute::match)).setter(setter(Builder::match)).constructor(HttpGatewayRouteMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HttpGatewayRouteAction action;

    private final HttpGatewayRouteMatch match;

    private HttpGatewayRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
    }

    /**
     * <p>
     * An object that represents the action to take if a match is determined.
     * </p>
     * 
     * @return An object that represents the action to take if a match is determined.
     */
    public final HttpGatewayRouteAction action() {
        return action;
    }

    /**
     * <p>
     * An object that represents the criteria for determining a request match.
     * </p>
     * 
     * @return An object that represents the criteria for determining a request match.
     */
    public final HttpGatewayRouteMatch match() {
        return match;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRoute)) {
            return false;
        }
        HttpGatewayRoute other = (HttpGatewayRoute) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(match(), other.match());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpGatewayRoute").add("Action", action()).add("Match", match()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("match", MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRoute, T> g) {
        return obj -> g.apply((HttpGatewayRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpGatewayRoute> {
        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * 
         * @param action
         *        An object that represents the action to take if a match is determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(HttpGatewayRouteAction action);

        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpGatewayRouteAction.Builder} avoiding
         * the need to create one manually via {@link HttpGatewayRouteAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpGatewayRouteAction.Builder#build()} is called immediately and
         * its result is passed to {@link #action(HttpGatewayRouteAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link HttpGatewayRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(HttpGatewayRouteAction)
         */
        default Builder action(Consumer<HttpGatewayRouteAction.Builder> action) {
            return action(HttpGatewayRouteAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * 
         * @param match
         *        An object that represents the criteria for determining a request match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(HttpGatewayRouteMatch match);

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpGatewayRouteMatch.Builder} avoiding
         * the need to create one manually via {@link HttpGatewayRouteMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpGatewayRouteMatch.Builder#build()} is called immediately and
         * its result is passed to {@link #match(HttpGatewayRouteMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link HttpGatewayRouteMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(HttpGatewayRouteMatch)
         */
        default Builder match(Consumer<HttpGatewayRouteMatch.Builder> match) {
            return match(HttpGatewayRouteMatch.builder().applyMutation(match).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HttpGatewayRouteAction action;

        private HttpGatewayRouteMatch match;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRoute model) {
            action(model.action);
            match(model.match);
        }

        public final HttpGatewayRouteAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(HttpGatewayRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(HttpGatewayRouteAction action) {
            this.action = action;
            return this;
        }

        public final HttpGatewayRouteMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(HttpGatewayRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(HttpGatewayRouteMatch match) {
            this.match = match;
            return this;
        }

        @Override
        public HttpGatewayRoute build() {
            return new HttpGatewayRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
