/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the format for the logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingFormat implements SdkPojo, Serializable, ToCopyableBuilder<LoggingFormat.Builder, LoggingFormat> {
    private static final SdkField<List<JsonFormatRef>> JSON_FIELD = SdkField
            .<List<JsonFormatRef>> builder(MarshallingType.LIST)
            .memberName("json")
            .getter(getter(LoggingFormat::json))
            .setter(setter(Builder::json))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("json").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JsonFormatRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(JsonFormatRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(LoggingFormat::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<JsonFormatRef> json;

    private final String text;

    private final Type type;

    private LoggingFormat(BuilderImpl builder) {
        this.json = builder.json;
        this.text = builder.text;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Json property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasJson() {
        return json != null && !(json instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJson} method.
     * </p>
     * 
     * @return
     */
    public final List<JsonFormatRef> json() {
        return json;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJson() ? json() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingFormat)) {
            return false;
        }
        LoggingFormat other = (LoggingFormat) obj;
        return hasJson() == other.hasJson() && Objects.equals(json(), other.json()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingFormat").add("Json", hasJson() ? json() : null).add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "json":
            return Optional.ofNullable(clazz.cast(json()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #json()} initialized to the given value.
     *
     * <p/>
     * 
     * @param json
     */
    public static LoggingFormat fromJson(List<JsonFormatRef> json) {
        return builder().json(json).build();
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p/>
     * 
     * @param text
     */
    public static LoggingFormat fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("json", JSON_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingFormat, T> g) {
        return obj -> g.apply((LoggingFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingFormat> {
        /**
         * <p/>
         * 
         * @param json
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder json(Collection<JsonFormatRef> json);

        /**
         * <p/>
         * 
         * @param json
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder json(JsonFormatRef... json);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appmesh.model.JsonFormatRef.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appmesh.model.JsonFormatRef#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appmesh.model.JsonFormatRef.Builder#build()} is called immediately and
         * its result is passed to {@link #json(List<JsonFormatRef>)}.
         * 
         * @param json
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appmesh.model.JsonFormatRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #json(java.util.Collection<JsonFormatRef>)
         */
        Builder json(Consumer<JsonFormatRef.Builder>... json);

        /**
         * <p/>
         * 
         * @param text
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private List<JsonFormatRef> json = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingFormat model) {
            json(model.json);
            text(model.text);
        }

        public final List<JsonFormatRef.Builder> getJson() {
            List<JsonFormatRef.Builder> result = JsonFormatCopier.copyToBuilder(this.json);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJson(Collection<JsonFormatRef.BuilderImpl> json) {
            Object oldValue = this.json;
            this.json = JsonFormatCopier.copyFromBuilder(json);
            handleUnionValueChange(Type.JSON, oldValue, this.json);
        }

        @Override
        public final Builder json(Collection<JsonFormatRef> json) {
            Object oldValue = this.json;
            this.json = JsonFormatCopier.copy(json);
            handleUnionValueChange(Type.JSON, oldValue, this.json);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder json(JsonFormatRef... json) {
            json(Arrays.asList(json));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder json(Consumer<JsonFormatRef.Builder>... json) {
            json(Stream.of(json).map(c -> JsonFormatRef.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        @Override
        public LoggingFormat build() {
            return new LoggingFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see LoggingFormat#type()
     */
    public enum Type {
        JSON,

        TEXT,

        UNKNOWN_TO_SDK_VERSION
    }
}
