/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents an access log file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayFileAccessLog implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayFileAccessLog.Builder, VirtualGatewayFileAccessLog> {
    private static final SdkField<LoggingFormat> FORMAT_FIELD = SdkField.<LoggingFormat> builder(MarshallingType.SDK_POJO)
            .memberName("format").getter(getter(VirtualGatewayFileAccessLog::format)).setter(setter(Builder::format))
            .constructor(LoggingFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(VirtualGatewayFileAccessLog::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LoggingFormat format;

    private final String path;

    private VirtualGatewayFileAccessLog(BuilderImpl builder) {
        this.format = builder.format;
        this.path = builder.path;
    }

    /**
     * <p>
     * The specified format for the virtual gateway access logs. It can be either <code>json_format</code> or
     * <code>text_format</code>.
     * </p>
     * 
     * @return The specified format for the virtual gateway access logs. It can be either <code>json_format</code> or
     *         <code>text_format</code>.
     */
    public final LoggingFormat format() {
        return format;
    }

    /**
     * <p>
     * The file path to write access logs to. You can use <code>/dev/stdout</code> to send access logs to standard out
     * and configure your Envoy container to use a log driver, such as <code>awslogs</code>, to export the access logs
     * to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
     * file system to write the files to disk.
     * </p>
     * 
     * @return The file path to write access logs to. You can use <code>/dev/stdout</code> to send access logs to
     *         standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code>, to
     *         export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a
     *         path in the Envoy container's file system to write the files to disk.
     */
    public final String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayFileAccessLog)) {
            return false;
        }
        VirtualGatewayFileAccessLog other = (VirtualGatewayFileAccessLog) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayFileAccessLog").add("Format", format()).add("Path", path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("format", FORMAT_FIELD);
        map.put("path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayFileAccessLog, T> g) {
        return obj -> g.apply((VirtualGatewayFileAccessLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayFileAccessLog> {
        /**
         * <p>
         * The specified format for the virtual gateway access logs. It can be either <code>json_format</code> or
         * <code>text_format</code>.
         * </p>
         * 
         * @param format
         *        The specified format for the virtual gateway access logs. It can be either <code>json_format</code> or
         *        <code>text_format</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(LoggingFormat format);

        /**
         * <p>
         * The specified format for the virtual gateway access logs. It can be either <code>json_format</code> or
         * <code>text_format</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingFormat.Builder} avoiding the need
         * to create one manually via {@link LoggingFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #format(LoggingFormat)}.
         * 
         * @param format
         *        a consumer that will call methods on {@link LoggingFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #format(LoggingFormat)
         */
        default Builder format(Consumer<LoggingFormat.Builder> format) {
            return format(LoggingFormat.builder().applyMutation(format).build());
        }

        /**
         * <p>
         * The file path to write access logs to. You can use <code>/dev/stdout</code> to send access logs to standard
         * out and configure your Envoy container to use a log driver, such as <code>awslogs</code>, to export the
         * access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy
         * container's file system to write the files to disk.
         * </p>
         * 
         * @param path
         *        The file path to write access logs to. You can use <code>/dev/stdout</code> to send access logs to
         *        standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code>, to
         *        export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a
         *        path in the Envoy container's file system to write the files to disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);
    }

    static final class BuilderImpl implements Builder {
        private LoggingFormat format;

        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayFileAccessLog model) {
            format(model.format);
            path(model.path);
        }

        public final LoggingFormat.Builder getFormat() {
            return format != null ? format.toBuilder() : null;
        }

        public final void setFormat(LoggingFormat.BuilderImpl format) {
            this.format = format != null ? format.build() : null;
        }

        @Override
        public final Builder format(LoggingFormat format) {
            this.format = format;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public VirtualGatewayFileAccessLog build() {
            return new VirtualGatewayFileAccessLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
